/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.priority.impl;

import com.xuexiang.xtask.thread.priority.IPriority;
import com.xuexiang.xtask.thread.priority.IPriorityRunnable;
import com.xuexiang.xtask.thread.utils.PriorityUtils;

public class DefaultPriorityRunnable
implements IPriorityRunnable {
    private IPriority mPriority;
    private Runnable mRunnable;

    public DefaultPriorityRunnable(IPriority priority, Runnable runnable) {
        this.mPriority = priority;
        this.mRunnable = runnable;
        this.setId(PriorityUtils.generateId());
    }

    @Override
    public void priority(int priority) {
        if (this.mPriority != null) {
            this.mPriority.priority(priority);
        }
    }

    @Override
    public long getId() {
        return this.mPriority != null ? this.mPriority.getId() : 0L;
    }

    @Override
    public void setId(long id) {
        if (this.mPriority != null) {
            this.mPriority.setId(id);
        }
    }

    @Override
    public int priority() {
        return this.mPriority != null ? this.mPriority.priority() : 0;
    }

    @Override
    public int compareTo(IPriority other) {
        return PriorityUtils.compare(this, other);
    }

    @Override
    public void run() {
        if (this.mRunnable != null) {
            this.mRunnable.run();
        }
    }

    public String toString() {
        return "DefaultPriorityRunnable{, mPriority=" + this.mPriority + ", mRunnable=" + this.mRunnable + '}';
    }
}

