/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.pool.base;

import com.xuexiang.xtask.logger.TaskLogger;
import com.xuexiang.xtask.thread.priority.IPriority;
import com.xuexiang.xtask.thread.utils.PriorityUtils;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;

public class BaseScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor {
    private static final String TAG = TaskLogger.getLogTag("BaseScheduledThreadPoolExecutor");

    public BaseScheduledThreadPoolExecutor(int corePoolSize) {
        super(corePoolSize);
    }

    public BaseScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    public BaseScheduledThreadPoolExecutor(int corePoolSize, RejectedExecutionHandler handler) {
        super(corePoolSize, handler);
    }

    public BaseScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        if (t == null) {
            return;
        }
        if (!TaskLogger.isLogThreadName()) {
            return;
        }
        if (r instanceof IPriority) {
            TaskLogger.dTag(TAG, "Running task start execute, id:" + ((IPriority)((Object)r)).getId() + ", priority:" + ((IPriority)((Object)r)).priority() + ", in Thread [" + Thread.currentThread().getName() + "]");
        } else {
            TaskLogger.dTag(TAG, "Running task start execute, in Thread [" + Thread.currentThread().getName() + "]");
        }
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (t == null && r instanceof Future && ((Future)((Object)r)).isDone()) {
            try {
                ((Future)((Object)r)).get();
            }
            catch (CancellationException ce) {
                t = ce;
            }
            catch (ExecutionException ee) {
                t = ee.getCause();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
        }
        if (t != null) {
            TaskLogger.wTag(TAG, "Running task appeared exception! Thread [" + Thread.currentThread().getName() + "], because [" + t.getMessage() + "]\n" + PriorityUtils.formatStackTrace(t.getStackTrace()));
        }
    }
}

