/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread.pool;

import com.xuexiang.xtask.thread.pool.TaskRecordPolicy;
import com.xuexiang.xtask.thread.pool.TaskThreadFactory;
import com.xuexiang.xtask.thread.pool.base.BaseScheduledThreadPoolExecutor;
import com.xuexiang.xtask.thread.pool.cancel.IScheduledFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class DefaultScheduledThreadPoolExecutor
extends BaseScheduledThreadPoolExecutor {
    public static DefaultScheduledThreadPoolExecutor getDefault() {
        return new Builder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(int corePoolSize) {
        return new Builder(corePoolSize);
    }

    public DefaultScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return new DefaultScheduledFuture<V>(callable, task);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return new DefaultScheduledFuture<V>(runnable, task);
    }

    public IScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return (IScheduledFuture)super.schedule(command, delay, unit);
    }

    public IScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return (IScheduledFuture)super.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public IScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return (IScheduledFuture)super.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    public static final class Builder {
        private static final int DEFAULT_CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors() + 1;
        private static final String DEFAULT_FACTORY_NAME = "DefaultScheduled";
        int corePoolSize;
        ThreadFactory threadFactory;
        RejectedExecutionHandler handler;

        public Builder() {
            this(DEFAULT_CORE_POOL_SIZE);
        }

        public Builder(int corePoolSize) {
            this.corePoolSize = corePoolSize;
        }

        public Builder setCorePoolSize(int corePoolSize) {
            this.corePoolSize = corePoolSize;
            return this;
        }

        public Builder setThreadFactory(ThreadFactory threadFactory) {
            this.threadFactory = threadFactory;
            return this;
        }

        public Builder setHandler(RejectedExecutionHandler handler) {
            this.handler = handler;
            return this;
        }

        public DefaultScheduledThreadPoolExecutor build() {
            if (this.threadFactory == null) {
                this.threadFactory = TaskThreadFactory.getFactory(DEFAULT_FACTORY_NAME);
            }
            if (this.handler == null) {
                this.handler = new TaskRecordPolicy();
            }
            return new DefaultScheduledThreadPoolExecutor(this.corePoolSize, this.threadFactory, this.handler);
        }
    }

    public static class DefaultScheduledFuture<V>
    extends FutureTask<V>
    implements IScheduledFuture<V> {
        private RunnableScheduledFuture<V> mTask;

        DefaultScheduledFuture(Callable<V> callable, RunnableScheduledFuture<V> task) {
            super(callable);
            this.mTask = task;
        }

        DefaultScheduledFuture(Runnable runnable, RunnableScheduledFuture<V> task) {
            super(runnable, null);
            this.mTask = task;
        }

        @Override
        public void cancel() {
            this.cancel(true);
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.mTask.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.mTask.compareTo(o);
        }

        @Override
        public boolean isPeriodic() {
            return this.mTask.isPeriodic();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.mTask.cancel(mayInterruptIfRunning);
        }

        @Override
        public void run() {
            this.mTask.run();
        }
    }
}

