/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xtask.thread;

import androidx.annotation.NonNull;
import com.xuexiang.xtask.thread.executor.ICategoryExecutorCore;
import com.xuexiang.xtask.thread.executor.IPriorityExecutorCore;
import com.xuexiang.xtask.thread.executor.IScheduledExecutorCore;
import com.xuexiang.xtask.thread.executor.impl.CategoryExecutorCore;
import com.xuexiang.xtask.thread.executor.impl.PriorityExecutorCore;
import com.xuexiang.xtask.thread.executor.impl.ScheduledExecutorCore;
import com.xuexiang.xtask.thread.pool.cancel.ICancelable;
import java.util.concurrent.TimeUnit;

public class XTaskExecutor
implements IPriorityExecutorCore,
ICategoryExecutorCore,
IScheduledExecutorCore {
    private static volatile XTaskExecutor sInstance = null;
    private IPriorityExecutorCore mPriorityExecutorCore;
    private ICategoryExecutorCore mCategoryExecutorCore = new CategoryExecutorCore();
    private IScheduledExecutorCore mScheduledExecutorCore;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XTaskExecutor get() {
        if (sInstance != null) return sInstance;
        Class<XTaskExecutor> clazz = XTaskExecutor.class;
        synchronized (XTaskExecutor.class) {
            if (sInstance != null) return sInstance;
            sInstance = new XTaskExecutor();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    private XTaskExecutor() {
        this.mPriorityExecutorCore = new PriorityExecutorCore();
        this.mScheduledExecutorCore = new ScheduledExecutorCore();
    }

    public XTaskExecutor setPriorityExecutorCore(@NonNull IPriorityExecutorCore priorityExecutorCore) {
        this.mPriorityExecutorCore = priorityExecutorCore;
        return this;
    }

    public XTaskExecutor setCategoryExecutorCore(@NonNull ICategoryExecutorCore categoryExecutorCore) {
        this.mCategoryExecutorCore = categoryExecutorCore;
        return this;
    }

    public XTaskExecutor setScheduledExecutorCore(@NonNull IScheduledExecutorCore scheduledExecutorCore) {
        this.mScheduledExecutorCore = scheduledExecutorCore;
        return this;
    }

    @Override
    public void shutdown() {
        this.mCategoryExecutorCore.shutdown();
        this.mPriorityExecutorCore.shutdown();
        this.mScheduledExecutorCore.shutdown();
    }

    @Override
    public ICancelable submit(Runnable task, int priority) {
        return this.mPriorityExecutorCore.submit(task, priority);
    }

    @Override
    public ICancelable submit(String groupName, Runnable task, int priority) {
        return this.mPriorityExecutorCore.submit(groupName, task, priority);
    }

    @Override
    public boolean postToMain(Runnable task) {
        return this.mCategoryExecutorCore.postToMain(task);
    }

    @Override
    public ICancelable postToMainDelay(Runnable task, long delayMillis) {
        return this.mCategoryExecutorCore.postToMainDelay(task, delayMillis);
    }

    @Override
    public ICancelable emergentSubmit(Runnable task) {
        return this.mCategoryExecutorCore.emergentSubmit(task);
    }

    @Override
    public ICancelable submit(Runnable task) {
        return this.mCategoryExecutorCore.submit(task);
    }

    @Override
    public ICancelable backgroundSubmit(Runnable task) {
        return this.mCategoryExecutorCore.backgroundSubmit(task);
    }

    @Override
    public ICancelable ioSubmit(Runnable task) {
        return this.mCategoryExecutorCore.ioSubmit(task);
    }

    @Override
    public ICancelable groupSubmit(String groupName, Runnable task) {
        return this.mCategoryExecutorCore.groupSubmit(groupName, task);
    }

    @Override
    public ICancelable schedule(Runnable task, long delay, TimeUnit unit) {
        return this.mScheduledExecutorCore.schedule(task, delay, unit);
    }

    @Override
    public ICancelable scheduleAtFixedRate(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return this.mScheduledExecutorCore.scheduleAtFixedRate(task, initialDelay, period, unit);
    }

    @Override
    public ICancelable scheduleWithFixedDelay(Runnable task, long initialDelay, long period, TimeUnit unit) {
        return this.mScheduledExecutorCore.scheduleWithFixedDelay(task, initialDelay, period, unit);
    }
}

