/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xqrcode.util;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.text.TextUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.WriterException;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.QRCodeWriter;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import com.google.zxing.qrcode.encoder.ByteMatrix;
import com.google.zxing.qrcode.encoder.Encoder;
import com.google.zxing.qrcode.encoder.QRCode;
import com.xuexiang.xqrcode.logs.QCLog;
import java.util.HashMap;
import java.util.Hashtable;

public final class QRCodeProduceUtils {
    private static final int BYTE_EPT = 0;
    private static final int BYTE_DTA = 1;
    private static final int BYTE_POS = 2;
    private static final int BYTE_AGN = 3;
    private static final int BYTE_TMG = 4;
    private static final int BYTE_PTC = 5;
    public static final int QRCODE_BITMAP_MAX_SIZE = 400;
    private static int DEFAULT_MARGIN = 20;
    private static float DEFAULT_DATA_DOT_SCALE = 0.3f;
    private static int DEFAULT_BINARIZING_THRESHOLD = 128;

    private QRCodeProduceUtils() {
        throw new UnsupportedOperationException("Do not need instantiate!");
    }

    public static Builder newBuilder(String contents) {
        return new Builder(contents);
    }

    public static Bitmap create(String contents, int size, int margin, int colorDark, int colorLight) throws IllegalArgumentException {
        return QRCodeProduceUtils.create(contents, size, margin, DEFAULT_DATA_DOT_SCALE, colorDark, colorLight, null, true, true);
    }

    public static Bitmap create(String contents, int size, int margin, int colorDark, int colorLight, Bitmap backgroundImage) throws IllegalArgumentException {
        return QRCodeProduceUtils.create(contents, size, margin, DEFAULT_DATA_DOT_SCALE, colorDark, colorLight, backgroundImage, true, true);
    }

    public static Bitmap create(String contents, int size, int margin, int colorDark, int colorLight, Bitmap backgroundImage, boolean whiteMargin) throws IllegalArgumentException {
        return QRCodeProduceUtils.create(contents, size, margin, DEFAULT_DATA_DOT_SCALE, colorDark, colorLight, backgroundImage, whiteMargin, true);
    }

    public static Bitmap create(String contents, int size, int margin, float dataDotScale, int colorDark, int colorLight, Bitmap backgroundImage, boolean whiteMargin) throws IllegalArgumentException {
        return QRCodeProduceUtils.create(contents, size, margin, dataDotScale, colorDark, colorLight, backgroundImage, whiteMargin, false);
    }

    public static Bitmap create(String contents, int size, int margin, float dataDotScale, Bitmap backgroundImage, boolean whiteMargin, boolean binarize) throws IllegalArgumentException {
        return QRCodeProduceUtils.create(contents, size, margin, dataDotScale, -16777216, -1, backgroundImage, whiteMargin, true, binarize, DEFAULT_BINARIZING_THRESHOLD);
    }

    public static Bitmap create(String contents, int size, int margin, float dataDotScale, Bitmap backgroundImage, boolean whiteMargin, boolean binarize, int binarizeThreshold) throws IllegalArgumentException {
        return QRCodeProduceUtils.create(contents, size, margin, dataDotScale, -16777216, -1, backgroundImage, whiteMargin, true, binarize, binarizeThreshold);
    }

    public static Bitmap create(String contents, int size, int margin, float dataDotScale, int colorDark, int colorLight, Bitmap backgroundImage, boolean whiteMargin, boolean autoColor) throws IllegalArgumentException {
        return QRCodeProduceUtils.create(contents, size, margin, dataDotScale, colorDark, colorLight, backgroundImage, whiteMargin, autoColor, false, DEFAULT_BINARIZING_THRESHOLD);
    }

    public static Bitmap create(String contents, int size, int margin, float dataDotScale, int colorDark, int colorLight, Bitmap backgroundImage, boolean whiteMargin, boolean autoColor, boolean binarize) throws IllegalArgumentException {
        return QRCodeProduceUtils.create(contents, size, margin, dataDotScale, colorDark, colorLight, backgroundImage, whiteMargin, autoColor, binarize, DEFAULT_BINARIZING_THRESHOLD);
    }

    public static Bitmap create(String contents, int size, int margin, float dataDotScale, int colorDark, int colorLight, Bitmap backgroundImage, boolean whiteMargin, boolean autoColor, boolean binarize, int binarizeThreshold) throws IllegalArgumentException {
        if (contents.isEmpty()) {
            throw new IllegalArgumentException("Error: contents is empty. (contents.isEmpty())");
        }
        if (size < 0) {
            throw new IllegalArgumentException("Error: a negative size is given. (size < 0)");
        }
        if (margin < 0) {
            throw new IllegalArgumentException("Error: a negative margin is given. (margin < 0)");
        }
        if (size - 2 * margin <= 0) {
            throw new IllegalArgumentException("Error: there is no space left for the QRCode. (size - 2 * margin <= 0)");
        }
        ByteMatrix byteMatrix = QRCodeProduceUtils.getBitMatrix(contents);
        if (size - 2 * margin < byteMatrix.getWidth()) {
            throw new IllegalArgumentException("Error: there is no space left for the QRCode. (size - 2 * margin < " + byteMatrix.getWidth() + ")");
        }
        if (dataDotScale < 0.0f || dataDotScale > 1.0f) {
            throw new IllegalArgumentException("Error: an illegal data dot scale is given. (dataDotScale < 0 || dataDotScale > 1)");
        }
        return QRCodeProduceUtils.render(byteMatrix, size - 2 * margin, margin, dataDotScale, colorDark, colorLight, backgroundImage, whiteMargin, autoColor, binarize, binarizeThreshold);
    }

    private static Bitmap render(ByteMatrix byteMatrix, int innerRenderedSize, int margin, float dataDotScale, int colorDark, int colorLight, Bitmap backgroundImage, boolean whiteMargin, boolean autoColor, boolean binarize, int binarizeThreshold) {
        int nCount = byteMatrix.getWidth();
        float nWidth = (float)innerRenderedSize / (float)nCount;
        float nHeight = (float)innerRenderedSize / (float)nCount;
        Bitmap backgroundImageScaled = Bitmap.createBitmap((int)(innerRenderedSize + (whiteMargin ? 0 : margin * 2)), (int)(innerRenderedSize + (whiteMargin ? 0 : margin * 2)), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (backgroundImage != null) {
            QRCodeProduceUtils.scaleBitmap(backgroundImage, backgroundImageScaled);
        }
        Bitmap renderedBitmap = Bitmap.createBitmap((int)(innerRenderedSize + margin * 2), (int)(innerRenderedSize + margin * 2), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        if (autoColor && backgroundImage != null) {
            colorDark = QRCodeProduceUtils.getDominantColor(backgroundImage);
        }
        if (binarize && backgroundImage != null) {
            int threshold = DEFAULT_BINARIZING_THRESHOLD;
            if (binarizeThreshold > 0 && binarizeThreshold < 255) {
                threshold = binarizeThreshold;
            }
            colorDark = -16777216;
            colorLight = -1;
            QRCodeProduceUtils.binarize(backgroundImageScaled, threshold);
        }
        Paint paint = new Paint();
        Paint paintDark = new Paint();
        paintDark.setColor(colorDark);
        paintDark.setAntiAlias(true);
        Paint paintLight = new Paint();
        paintLight.setColor(colorLight);
        paintLight.setAntiAlias(true);
        Paint paintProtector = new Paint();
        paintProtector.setColor(Color.argb((int)120, (int)255, (int)255, (int)255));
        paintProtector.setAntiAlias(true);
        Canvas canvas = new Canvas(renderedBitmap);
        canvas.drawColor(-1);
        canvas.drawBitmap(backgroundImageScaled, whiteMargin ? (float)margin : 0.0f, whiteMargin ? (float)margin : 0.0f, paint);
        for (int row = 0; row < byteMatrix.getHeight(); ++row) {
            String s = "";
            block7: for (int col = 0; col < byteMatrix.getWidth(); ++col) {
                switch (byteMatrix.get(col, row)) {
                    case 2: 
                    case 3: 
                    case 4: {
                        canvas.drawRect((float)margin + (float)col * nWidth, (float)margin + (float)row * nHeight, (float)margin + ((float)col + 1.0f) * nWidth, (float)margin + ((float)row + 1.0f) * nHeight, paintDark);
                        s = s + "\uff38";
                        continue block7;
                    }
                    case 1: {
                        canvas.drawRect((float)margin + ((float)col + 0.5f * (1.0f - dataDotScale)) * nWidth, (float)margin + ((float)row + 0.5f * (1.0f - dataDotScale)) * nHeight, (float)margin + ((float)col + 0.5f * (1.0f + dataDotScale)) * nWidth, (float)margin + ((float)row + 0.5f * (1.0f + dataDotScale)) * nHeight, paintDark);
                        s = s + "\u3007";
                        continue block7;
                    }
                    case 5: {
                        canvas.drawRect((float)margin + (float)col * nWidth, (float)margin + (float)row * nHeight, (float)margin + ((float)col + 1.0f) * nWidth, (float)margin + ((float)row + 1.0f) * nHeight, paintProtector);
                        s = s + "\uff0b";
                        continue block7;
                    }
                    case 0: {
                        canvas.drawRect((float)margin + ((float)col + 0.5f * (1.0f - dataDotScale)) * nWidth, (float)margin + ((float)row + 0.5f * (1.0f - dataDotScale)) * nHeight, (float)margin + ((float)col + 0.5f * (1.0f + dataDotScale)) * nWidth, (float)margin + ((float)row + 0.5f * (1.0f + dataDotScale)) * nHeight, paintLight);
                        s = s + "\u3000";
                        continue block7;
                    }
                }
            }
            QCLog.dTag("QR_MAPPING", s);
        }
        return renderedBitmap;
    }

    private static ByteMatrix getBitMatrix(String contents) {
        try {
            QRCode qrCode = QRCodeProduceUtils.getProtoQRCode(contents, ErrorCorrectionLevel.H);
            int[] agnCenter = qrCode.getVersion().getAlignmentPatternCenters();
            ByteMatrix byteMatrix = qrCode.getMatrix();
            int matSize = byteMatrix.getWidth();
            for (int row = 0; row < matSize; ++row) {
                for (int col = 0; col < matSize; ++col) {
                    if (QRCodeProduceUtils.isTypeAGN(col, row, agnCenter, true)) {
                        if (byteMatrix.get(col, row) != 0) {
                            byteMatrix.set(col, row, 3);
                        } else {
                            byteMatrix.set(col, row, 5);
                        }
                    } else if (QRCodeProduceUtils.isTypePOS(col, row, matSize, true)) {
                        if (byteMatrix.get(col, row) != 0) {
                            byteMatrix.set(col, row, 2);
                        } else {
                            byteMatrix.set(col, row, 5);
                        }
                    } else if (QRCodeProduceUtils.isTypeTMG(col, row, matSize)) {
                        if (byteMatrix.get(col, row) != 0) {
                            byteMatrix.set(col, row, 4);
                        } else {
                            byteMatrix.set(col, row, 5);
                        }
                    }
                    if (!QRCodeProduceUtils.isTypePOS(col, row, matSize, false) || byteMatrix.get(col, row) != 0) continue;
                    byteMatrix.set(col, row, 5);
                }
            }
            return byteMatrix;
        }
        catch (WriterException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static QRCode getProtoQRCode(String contents, ErrorCorrectionLevel errorCorrectionLevel) throws WriterException {
        if (contents.isEmpty()) {
            throw new IllegalArgumentException("Found empty contents");
        }
        HashMap<EncodeHintType, ErrorCorrectionLevel> hintMap = new HashMap<EncodeHintType, ErrorCorrectionLevel>();
        hintMap.put(EncodeHintType.ERROR_CORRECTION, errorCorrectionLevel);
        return Encoder.encode((String)contents, (ErrorCorrectionLevel)errorCorrectionLevel, hintMap);
    }

    private static boolean isTypeAGN(int x, int y, int[] agnCenter, boolean edgeOnly) {
        if (agnCenter.length == 0) {
            return false;
        }
        int edgeCenter = agnCenter[agnCenter.length - 1];
        for (int agnY : agnCenter) {
            for (int agnX : agnCenter) {
                if (edgeOnly && agnX != 6 && agnY != 6 && agnX != edgeCenter && agnY != edgeCenter || agnX == 6 && agnY == 6 || agnX == 6 && agnY == edgeCenter || agnY == 6 && agnX == edgeCenter || x < agnX - 2 || x > agnX + 2 || y < agnY - 2 || y > agnY + 2) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean isTypePOS(int x, int y, int size, boolean inner) {
        if (inner) {
            return x < 7 && (y < 7 || y >= size - 7) || x >= size - 7 && y < 7;
        }
        return x <= 7 && (y <= 7 || y >= size - 8) || x >= size - 8 && y <= 7;
    }

    private static boolean isTypeTMG(int x, int y, int size) {
        return y == 6 && x >= 8 && x < size - 8 || x == 6 && y >= 8 && y < size - 8;
    }

    private static void scaleBitmap(Bitmap src, Bitmap dst) {
        Paint cPaint = new Paint();
        cPaint.setAntiAlias(true);
        cPaint.setDither(true);
        cPaint.setFilterBitmap(true);
        float ratioX = (float)dst.getWidth() / (float)src.getWidth();
        float ratioY = (float)dst.getHeight() / (float)src.getHeight();
        float middleX = (float)dst.getWidth() * 0.5f;
        float middleY = (float)dst.getHeight() * 0.5f;
        Matrix scaleMatrix = new Matrix();
        scaleMatrix.setScale(ratioX, ratioY, middleX, middleY);
        Canvas canvas = new Canvas(dst);
        canvas.setMatrix(scaleMatrix);
        canvas.drawBitmap(src, middleX - (float)(src.getWidth() / 2), middleY - (float)(src.getHeight() / 2), cPaint);
    }

    private static int getDominantColor(Bitmap bitmap) {
        Bitmap newBitmap = Bitmap.createScaledBitmap((Bitmap)bitmap, (int)8, (int)8, (boolean)true);
        int red = 0;
        int green = 0;
        int blue = 0;
        int c = 0;
        for (int y = 0; y < newBitmap.getHeight(); ++y) {
            for (int x = 0; x < newBitmap.getHeight(); ++x) {
                int color = newBitmap.getPixel(x, y);
                int r = color >> 16 & 0xFF;
                int g = color >> 8 & 0xFF;
                int b = color & 0xFF;
                if (r > 200 || g > 200 || b > 200) continue;
                red += r;
                green += g;
                blue += b;
                ++c;
            }
        }
        newBitmap.recycle();
        red = Math.max(0, Math.min(255, red / c));
        green = Math.max(0, Math.min(255, green / c));
        blue = Math.max(0, Math.min(255, blue / c));
        return 0xFF000000 | red << 16 | green << 8 | blue;
    }

    private static void binarize(Bitmap bitmap, int threshold) {
        for (int y = 0; y < bitmap.getHeight(); ++y) {
            for (int x = 0; x < bitmap.getHeight(); ++x) {
                int b;
                int g;
                int color = bitmap.getPixel(x, y);
                int r = color >> 16 & 0xFF;
                float sum = 0.3f * (float)r + 0.59f * (float)(g = color >> 8 & 0xFF) + 0.11f * (float)(b = color & 0xFF);
                bitmap.setPixel(x, y, sum > (float)threshold ? -1 : -16777216);
            }
        }
    }

    public static Bitmap create(String contents, int width, int height, Bitmap logo) {
        if (TextUtils.isEmpty((CharSequence)contents)) {
            return null;
        }
        try {
            Bitmap scaleLogo = QRCodeProduceUtils.getScaleLogo(logo, width, height);
            int offsetX = width / 2;
            int offsetY = height / 2;
            int scaleWidth = 0;
            int scaleHeight = 0;
            if (scaleLogo != null) {
                scaleWidth = scaleLogo.getWidth();
                scaleHeight = scaleLogo.getHeight();
                offsetX = (width - scaleWidth) / 2;
                offsetY = (height - scaleHeight) / 2;
            }
            Hashtable<EncodeHintType, Object> hints = new Hashtable<EncodeHintType, Object>();
            hints.put(EncodeHintType.CHARACTER_SET, "utf-8");
            hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.H);
            hints.put(EncodeHintType.MARGIN, 0);
            BitMatrix bitMatrix = new QRCodeWriter().encode(contents, BarcodeFormat.QR_CODE, width, height, hints);
            int[] pixels = new int[width * height];
            for (int y = 0; y < height; ++y) {
                for (int x = 0; x < width; ++x) {
                    if (x >= offsetX && x < offsetX + scaleWidth && y >= offsetY && y < offsetY + scaleHeight) {
                        int pixel = scaleLogo.getPixel(x - offsetX, y - offsetY);
                        if (pixel == 0) {
                            pixel = bitMatrix.get(x, y) ? -16777216 : -1;
                        }
                        pixels[y * width + x] = pixel;
                        continue;
                    }
                    pixels[y * width + x] = bitMatrix.get(x, y) ? -16777216 : -1;
                }
            }
            Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
            return bitmap;
        }
        catch (WriterException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static Bitmap getScaleLogo(Bitmap logo, int w, int h) {
        if (logo == null) {
            return null;
        }
        Matrix matrix = new Matrix();
        float scaleFactor = Math.min((float)w * 1.0f / 5.0f / (float)logo.getWidth(), (float)h * 1.0f / 5.0f / (float)logo.getHeight());
        matrix.postScale(scaleFactor, scaleFactor);
        return Bitmap.createBitmap((Bitmap)logo, (int)0, (int)0, (int)logo.getWidth(), (int)logo.getHeight(), (Matrix)matrix, (boolean)true);
    }

    public static class Builder {
        String contents;
        int size;
        int margin;
        float dataDotScale;
        boolean autoColor;
        int colorDark;
        int colorLight;
        Bitmap backgroundImage;
        boolean whiteMargin;
        boolean binarize;
        int binarizeThreshold;

        public Builder(String contents) {
            this.contents = contents;
            this.size = 400;
            this.margin = DEFAULT_MARGIN;
            this.dataDotScale = DEFAULT_DATA_DOT_SCALE;
            this.autoColor = true;
            this.colorDark = -16777216;
            this.colorLight = -1;
            this.whiteMargin = false;
            this.binarize = false;
            this.binarizeThreshold = DEFAULT_BINARIZING_THRESHOLD;
        }

        public Builder setContents(String contents) {
            this.contents = contents;
            return this;
        }

        public Builder setSize(int size) {
            this.size = size;
            return this;
        }

        public Builder setMargin(int margin) {
            this.margin = margin;
            return this;
        }

        public Builder setDataDotScale(float dataDotScale) {
            this.dataDotScale = dataDotScale;
            return this;
        }

        public Builder setColorDark(int colorDark) {
            this.colorDark = colorDark;
            return this;
        }

        public Builder setColorLight(int colorLight) {
            this.colorLight = colorLight;
            return this;
        }

        public Builder setBackgroundImage(Bitmap backgroundImage) {
            this.backgroundImage = backgroundImage;
            return this;
        }

        public Builder setWhiteMargin(boolean whiteMargin) {
            this.whiteMargin = whiteMargin;
            return this;
        }

        public Builder setAutoColor(boolean autoColor) {
            this.autoColor = autoColor;
            return this;
        }

        public Builder setBinarize(boolean binarize) {
            this.binarize = binarize;
            return this;
        }

        public Builder setBinarizeThreshold(int binarizeThreshold) {
            this.binarizeThreshold = binarizeThreshold;
            return this;
        }

        public Bitmap build() {
            return QRCodeProduceUtils.create(this.contents, this.size, this.margin, this.dataDotScale, this.colorDark, this.colorLight, this.backgroundImage, this.whiteMargin, this.autoColor, this.binarize, this.binarizeThreshold);
        }
    }
}

