/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xqrcode.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Build;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AppCompatActivity;
import androidx.core.app.ActivityCompat;
import androidx.fragment.app.Fragment;
import com.xuexiang.xqrcode.R;
import com.xuexiang.xqrcode.ui.CaptureFragment;
import com.xuexiang.xqrcode.util.QRCodeAnalyzeUtils;

public class CaptureActivity
extends AppCompatActivity {
    public static final int REQUEST_CODE_REQUEST_PERMISSIONS = 222;
    public static final String KEY_CAPTURE_THEME = "com.xuexiang.xqrcode.ui.KEY_CAPTURE_THEME";
    CaptureFragment.CameraInitCallBack cameraInitCallBack = new CaptureFragment.CameraInitCallBack(){

        @Override
        public void callBack(@Nullable Exception e) {
            if (e != null) {
                CaptureActivity.showNoPermissionTip((Activity)CaptureActivity.this);
                CaptureActivity.this.onCameraInitFailed();
            } else {
                CaptureActivity.this.onCameraInitSuccess();
            }
        }
    };
    QRCodeAnalyzeUtils.AnalyzeCallback analyzeCallback = new QRCodeAnalyzeUtils.AnalyzeCallback(){

        @Override
        public void onAnalyzeSuccess(Bitmap bitmap, String result) {
            CaptureActivity.this.handleAnalyzeSuccess(bitmap, result);
        }

        @Override
        public void onAnalyzeFailed() {
            CaptureActivity.this.handleAnalyzeFailed();
        }
    };

    public static void start(Fragment fragment, int requestCode, int theme) {
        Intent intent = new Intent(fragment.getContext(), CaptureActivity.class);
        intent.putExtra(KEY_CAPTURE_THEME, theme);
        fragment.startActivityForResult(intent, requestCode);
    }

    public static void start(Activity activity, int requestCode, int theme) {
        Intent intent = new Intent((Context)activity, CaptureActivity.class);
        intent.putExtra(KEY_CAPTURE_THEME, theme);
        activity.startActivityForResult(intent, requestCode);
    }

    protected void onCreate(Bundle savedInstanceState) {
        this.setTheme(this.getIntent().getIntExtra(KEY_CAPTURE_THEME, R.style.XQRCodeTheme));
        super.onCreate(savedInstanceState);
        this.setContentView(this.getCaptureLayoutId());
        this.beforeCapture();
        if (Build.VERSION.SDK_INT >= 23 && ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.CAMERA") != 0) {
            this.requestPermissions(new String[]{"android.permission.CAMERA"}, 222);
            return;
        }
        this.initCaptureFragment();
    }

    protected int getCaptureLayoutId() {
        return R.layout.xqrcode_activity_capture;
    }

    protected void beforeCapture() {
    }

    protected void initCaptureFragment() {
        CaptureFragment captureFragment = new CaptureFragment();
        captureFragment.setAnalyzeCallback(this.analyzeCallback);
        captureFragment.setCameraInitCallBack(this.cameraInitCallBack);
        this.getSupportFragmentManager().beginTransaction().replace(R.id.fl_zxing_container, (Fragment)captureFragment).commit();
    }

    protected void onCameraInitSuccess() {
    }

    protected void onCameraInitFailed() {
    }

    public static AlertDialog showNoPermissionTip(Activity activity, DialogInterface.OnClickListener listener) {
        return new AlertDialog.Builder((Context)activity).setTitle(R.string.xqrcode_pay_attention).setMessage(R.string.xqrcode_not_get_permission).setPositiveButton(R.string.xqrcode_submit, listener).show();
    }

    public static AlertDialog showNoPermissionTip(final Activity activity) {
        return CaptureActivity.showNoPermissionTip(activity, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                activity.finish();
            }
        });
    }

    protected void handleAnalyzeSuccess(Bitmap bitmap, String result) {
        Intent resultIntent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putInt("result_type", 1);
        bundle.putString("result_data", result);
        resultIntent.putExtras(bundle);
        this.setResult(-1, resultIntent);
        this.finish();
    }

    protected void handleAnalyzeFailed() {
        Intent resultIntent = new Intent();
        Bundle bundle = new Bundle();
        bundle.putInt("result_type", 2);
        bundle.putString("result_data", "");
        resultIntent.putExtras(bundle);
        this.setResult(-1, resultIntent);
        this.finish();
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 222) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.initCaptureFragment();
            } else {
                this.handleRequestPermissionDeny();
            }
        }
    }

    protected void handleRequestPermissionDeny() {
        CaptureActivity.showNoPermissionTip((Activity)this);
    }
}

