/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xqrcode.decoding;

import android.app.Activity;
import com.xuexiang.xqrcode.decoding.FinishListener;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public final class InactivityTimer {
    private static final int INACTIVITY_DELAY_SECONDS = 300;
    private final ScheduledExecutorService inactivityTimer = Executors.newSingleThreadScheduledExecutor(new DaemonThreadFactory());
    private final Activity mActivity;
    private ScheduledFuture<?> mInactivityFuture = null;

    public InactivityTimer(Activity activity) {
        this.mActivity = activity;
        this.onActivity();
    }

    public void onActivity() {
        this.cancel();
        this.mInactivityFuture = this.inactivityTimer.schedule(new FinishListener(this.mActivity), 300L, TimeUnit.SECONDS);
    }

    private void cancel() {
        if (this.mInactivityFuture != null) {
            this.mInactivityFuture.cancel(true);
            this.mInactivityFuture = null;
        }
    }

    public void shutdown() {
        this.cancel();
        this.inactivityTimer.shutdown();
    }

    private static final class DaemonThreadFactory
    implements ThreadFactory {
        private DaemonThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            return thread;
        }
    }
}

