/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.utils;

import com.xuexiang.xhttp2.model.ApiResult;
import com.xuexiang.xhttp2.reflect.TypeBuilder;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import okhttp3.ResponseBody;

public final class TypeUtils {
    private TypeUtils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static <T> Type findNeedClass(Class<T> cls) {
        Type finalNeedType;
        Type genType = cls.getGenericSuperclass();
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        Type type = params[0];
        if (params.length > 1) {
            if (!(type instanceof ParameterizedType)) {
                throw new IllegalStateException("\u6ca1\u6709\u586b\u5199\u6cdb\u578b\u53c2\u6570");
            }
            finalNeedType = ((ParameterizedType)type).getActualTypeArguments()[0];
        } else {
            finalNeedType = type;
        }
        return finalNeedType;
    }

    public static <T> Type findRawType(Class<T> cls) {
        Type genType = cls.getGenericSuperclass();
        return TypeUtils.getGenericType((ParameterizedType)genType, 0);
    }

    private static Type getGenericType(ParameterizedType parameterizedType, int i) {
        Type genericType = parameterizedType.getActualTypeArguments()[i];
        if (genericType instanceof ParameterizedType) {
            return ((ParameterizedType)genericType).getRawType();
        }
        if (genericType instanceof GenericArrayType) {
            return ((GenericArrayType)genericType).getGenericComponentType();
        }
        if (genericType instanceof TypeVariable) {
            return TypeUtils.getClass(((TypeVariable)genericType).getBounds()[0], 0);
        }
        return genericType;
    }

    public static Class getClass(Type type, int i) {
        if (type instanceof ParameterizedType) {
            return TypeUtils.getGenericClass((ParameterizedType)type, i);
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.getClass(((TypeVariable)type).getBounds()[0], 0);
        }
        return (Class)type;
    }

    private static Class getGenericClass(ParameterizedType parameterizedType, int i) {
        Type genericClass = parameterizedType.getActualTypeArguments()[i];
        if (genericClass instanceof ParameterizedType) {
            return (Class)((ParameterizedType)genericClass).getRawType();
        }
        if (genericClass instanceof GenericArrayType) {
            return (Class)((GenericArrayType)genericClass).getGenericComponentType();
        }
        if (genericClass instanceof TypeVariable) {
            return TypeUtils.getClass(((TypeVariable)genericClass).getBounds()[0], 0);
        }
        return (Class)genericClass;
    }

    public static Type getParameterizedType(Type type, int i) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[i];
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.getType(((TypeVariable)type).getBounds()[0], 0);
        }
        return type;
    }

    private static Type getType(Type type, int i) {
        if (type instanceof ParameterizedType) {
            return TypeUtils.getGenericType((ParameterizedType)type, i);
        }
        if (type instanceof TypeVariable) {
            return TypeUtils.getType(((TypeVariable)type).getBounds()[0], 0);
        }
        return type;
    }

    public static <R> Type findNeedType(Class<R> cls) {
        List<Type> typeList = TypeUtils.getAllTypes(cls);
        if (typeList == null || typeList.isEmpty()) {
            return ResponseBody.class;
        }
        return typeList.get(0);
    }

    public static <T> List<Type> getAllTypes(Class<T> cls) {
        Type genType = cls.getGenericSuperclass();
        ArrayList<Type> needTypes = null;
        if (genType instanceof ParameterizedType) {
            Type[] parentTypes;
            needTypes = new ArrayList<Type>();
            for (Type childType : parentTypes = ((ParameterizedType)genType).getActualTypeArguments()) {
                needTypes.add(childType);
                if (!(childType instanceof ParameterizedType)) continue;
                Type[] childTypes = ((ParameterizedType)childType).getActualTypeArguments();
                Collections.addAll(needTypes, childTypes);
            }
        }
        return needTypes;
    }

    public static Type getApiResultType(Type type) {
        return TypeBuilder.newInstance(ApiResult.class).addTypeParam(type).build();
    }

    public static Type getListType(Type type) {
        return TypeBuilder.newInstance(List.class).addTypeParam(type).build();
    }
}

