/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.subsciber;

import com.xuexiang.xhttp2.callback.CallBack;
import com.xuexiang.xhttp2.callback.ProgressLoadingCallBack;
import com.xuexiang.xhttp2.exception.ApiException;
import com.xuexiang.xhttp2.subsciber.BaseSubscriber;
import io.reactivex.disposables.Disposable;

public class CallBackSubscriber<T>
extends BaseSubscriber<T> {
    private CallBack<T> mCallBack;

    public CallBackSubscriber(CallBack<T> callBack) {
        this.mCallBack = callBack;
        if (callBack instanceof ProgressLoadingCallBack) {
            ((ProgressLoadingCallBack)callBack).subscription((Disposable)this);
        }
    }

    @Override
    public void onStart() {
        super.onStart();
        if (this.mCallBack != null) {
            this.mCallBack.onStart();
        }
    }

    @Override
    public void onError(ApiException e) {
        if (this.mCallBack != null) {
            this.mCallBack.onError(e);
        }
    }

    @Override
    public void onSuccess(T t) {
        try {
            if (this.mCallBack != null) {
                this.mCallBack.onSuccess(t);
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.onError(e);
        }
    }

    @Override
    public void onComplete() {
        super.onComplete();
        if (this.mCallBack != null) {
            this.mCallBack.onCompleted();
        }
    }
}

