/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.subsciber;

import com.xuexiang.xhttp2.exception.ApiException;
import com.xuexiang.xhttp2.exception.ApiExceptionHandler;
import com.xuexiang.xhttp2.logs.HttpLog;
import io.reactivex.observers.DisposableObserver;

public abstract class BaseSubscriber<T>
extends DisposableObserver<T> {
    protected void onStart() {
        HttpLog.d("--> Subscriber is onStart");
    }

    public void onComplete() {
        HttpLog.d("--> Subscriber is Complete");
    }

    public void onNext(T t) {
        try {
            this.onSuccess(t);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.onError(e);
        }
    }

    public final void onError(Throwable e) {
        HttpLog.e("--> Subscriber is onError");
        try {
            if (e instanceof ApiException) {
                HttpLog.e("--> e instanceof ApiException, message:" + e.getMessage());
                this.onError((ApiException)e);
            } else {
                HttpLog.e("--> e !instanceof ApiException, message:" + e.getMessage());
                this.onError(ApiExceptionHandler.handleException(e));
            }
        }
        catch (Throwable throwable) {
            e.printStackTrace();
        }
    }

    protected abstract void onError(ApiException var1);

    protected abstract void onSuccess(T var1);
}

