/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.request;

import android.content.Context;
import android.text.TextUtils;
import com.google.gson.reflect.TypeToken;
import com.xuexiang.xhttp2.XHttp;
import com.xuexiang.xhttp2.api.ApiService;
import com.xuexiang.xhttp2.cache.RxCache;
import com.xuexiang.xhttp2.cache.converter.IDiskConverter;
import com.xuexiang.xhttp2.cache.model.CacheMode;
import com.xuexiang.xhttp2.cache.model.CacheResult;
import com.xuexiang.xhttp2.callback.CallBack;
import com.xuexiang.xhttp2.callback.CallBackProxy;
import com.xuexiang.xhttp2.callback.CallClazzProxy;
import com.xuexiang.xhttp2.https.HttpsUtils;
import com.xuexiang.xhttp2.interceptor.BaseDynamicInterceptor;
import com.xuexiang.xhttp2.interceptor.CacheInterceptor;
import com.xuexiang.xhttp2.interceptor.CacheInterceptorOffline;
import com.xuexiang.xhttp2.interceptor.HeadersInterceptor;
import com.xuexiang.xhttp2.interceptor.NoCacheInterceptor;
import com.xuexiang.xhttp2.model.ApiResult;
import com.xuexiang.xhttp2.model.HttpHeaders;
import com.xuexiang.xhttp2.model.HttpParams;
import com.xuexiang.xhttp2.subsciber.CallBackSubscriber;
import com.xuexiang.xhttp2.transform.HttpResultTransformer;
import com.xuexiang.xhttp2.transform.HttpSchedulersTransformer;
import com.xuexiang.xhttp2.transform.func.ApiResultFunc;
import com.xuexiang.xhttp2.transform.func.CacheResultFunc;
import com.xuexiang.xhttp2.transform.func.RetryExceptionFunc;
import com.xuexiang.xhttp2.utils.Utils;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import java.io.File;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import okhttp3.Cache;
import okhttp3.Cookie;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.ResponseBody;
import retrofit2.CallAdapter;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.adapter.rxjava2.RxJava2CallAdapterFactory;

public abstract class BaseRequest<R extends BaseRequest> {
    protected Context mContext;
    protected HttpUrl mHttpUrl;
    protected String mBaseUrl;
    private String mSubUrl;
    protected String mUrl;
    protected boolean mIsSyncRequest = false;
    protected boolean mIsOnMainThread = true;
    protected boolean mKeepJson = false;
    private boolean mSign = false;
    private boolean mTimeStamp = false;
    private boolean mAccessToken = false;
    protected long mReadTimeOut;
    protected long mWriteTimeOut;
    protected long mConnectTimeout;
    protected int mRetryCount;
    protected int mRetryDelay;
    protected int mRetryIncreaseDelay;
    protected HttpHeaders mHeaders = new HttpHeaders();
    protected HttpParams mParams = new HttpParams();
    protected RxCache mRxCache;
    protected Cache mCache;
    protected CacheMode mCacheMode;
    protected long mCacheTime;
    protected String mCacheKey;
    protected IDiskConverter mDiskConverter;
    protected OkHttpClient mOkHttpClient;
    protected Proxy mProxy;
    protected final List<Interceptor> mNetworkInterceptors = new ArrayList<Interceptor>();
    protected final List<Interceptor> mInterceptors = new ArrayList<Interceptor>();
    protected Retrofit mRetrofit;
    protected ApiService mApiManager;
    protected List<Converter.Factory> mConverterFactories = new ArrayList<Converter.Factory>();
    protected List<CallAdapter.Factory> mAdapterFactories = new ArrayList<CallAdapter.Factory>();
    protected HttpsUtils.SSLParams mSSLParams;
    protected HostnameVerifier mHostnameVerifier;
    protected List<Cookie> mCookies = new ArrayList<Cookie>();

    public BaseRequest(String url) {
        String userAgent;
        this.mContext = XHttp.getContext();
        this.mUrl = url;
        this.mBaseUrl = XHttp.getBaseUrl();
        this.mSubUrl = XHttp.getSubUrl();
        if (!TextUtils.isEmpty((CharSequence)this.mBaseUrl)) {
            this.mHttpUrl = HttpUrl.parse((String)this.mBaseUrl);
        }
        this.mCacheMode = XHttp.getCacheMode();
        this.mCacheTime = XHttp.getCacheTime();
        this.mRetryCount = XHttp.getRetryCount();
        this.mRetryDelay = XHttp.getRetryDelay();
        this.mRetryIncreaseDelay = XHttp.getRetryIncreaseDelay();
        this.mCache = XHttp.getHttpCache();
        String acceptLanguage = HttpHeaders.getAcceptLanguage();
        if (!TextUtils.isEmpty((CharSequence)acceptLanguage)) {
            this.headers("Accept-Language", acceptLanguage);
        }
        if (!TextUtils.isEmpty((CharSequence)(userAgent = HttpHeaders.getUserAgent()))) {
            this.headers("User-Agent", userAgent);
        }
        if (XHttp.getCommonParams() != null) {
            this.mParams.put(XHttp.getCommonParams());
        }
        if (XHttp.getCommonHeaders() != null) {
            this.mHeaders.put(XHttp.getCommonHeaders());
        }
    }

    public R url(String url) {
        this.mUrl = Utils.checkNotNull(url, "mUrl == null");
        return (R)this;
    }

    public R baseUrl(String baseUrl) {
        this.mBaseUrl = baseUrl;
        if (!TextUtils.isEmpty((CharSequence)this.mBaseUrl)) {
            this.mHttpUrl = HttpUrl.parse((String)baseUrl);
        }
        return (R)this;
    }

    public R subUrl(String subUrl) {
        this.mSubUrl = Utils.checkNotNull(subUrl, "mSubUrl == null");
        return (R)this;
    }

    public String getUrl() {
        return this.mSubUrl + this.mUrl;
    }

    public String getBaseUrl() {
        return this.mBaseUrl;
    }

    public R keepJson(boolean keepJson) {
        this.mKeepJson = keepJson;
        return (R)this;
    }

    public R syncRequest(boolean syncRequest) {
        this.mIsSyncRequest = syncRequest;
        return (R)this;
    }

    public R onMainThread(boolean onMainThread) {
        this.mIsOnMainThread = onMainThread;
        return (R)this;
    }

    public R threadType(String threadType) {
        if ("executeToMain".equals(threadType)) {
            ((BaseRequest)this.syncRequest(false)).onMainThread(true);
        } else if ("executeToIO".equals(threadType)) {
            ((BaseRequest)this.syncRequest(false)).onMainThread(false);
        } else if ("executeInThread".equals(threadType)) {
            ((BaseRequest)this.syncRequest(true)).onMainThread(false);
        }
        return (R)this;
    }

    public R sign(boolean sign) {
        this.mSign = sign;
        return (R)this;
    }

    public R timeStamp(boolean timeStamp) {
        this.mTimeStamp = timeStamp;
        return (R)this;
    }

    public R accessToken(boolean accessToken) {
        this.mAccessToken = accessToken;
        return (R)this;
    }

    public R readTimeOut(long readTimeOut) {
        this.mReadTimeOut = readTimeOut;
        return (R)this;
    }

    public R writeTimeOut(long writeTimeOut) {
        this.mWriteTimeOut = writeTimeOut;
        return (R)this;
    }

    public R connectTimeout(long connectTimeout) {
        this.mConnectTimeout = connectTimeout;
        return (R)this;
    }

    public R timeOut(long timeOut) {
        this.mReadTimeOut = timeOut;
        this.mWriteTimeOut = timeOut;
        this.mConnectTimeout = timeOut;
        return (R)this;
    }

    public R retryCount(int retryCount) {
        if (retryCount < 0) {
            throw new IllegalArgumentException("mRetryCount must > 0");
        }
        this.mRetryCount = retryCount;
        return (R)this;
    }

    public R retryDelay(int retryDelay) {
        if (retryDelay < 0) {
            throw new IllegalArgumentException("mRetryDelay must > 0");
        }
        this.mRetryDelay = retryDelay;
        return (R)this;
    }

    public R retryIncreaseDelay(int retryIncreaseDelay) {
        if (retryIncreaseDelay < 0) {
            throw new IllegalArgumentException("mRetryIncreaseDelay must > 0");
        }
        this.mRetryIncreaseDelay = retryIncreaseDelay;
        return (R)this;
    }

    public R headers(HttpHeaders headers) {
        this.mHeaders.put(headers);
        return (R)this;
    }

    public R headers(String key, String value) {
        this.mHeaders.put(key, value);
        return (R)this;
    }

    public R removeHeader(String key) {
        this.mHeaders.remove(key);
        return (R)this;
    }

    public R removeAllHeaders() {
        this.mHeaders.clear();
        return (R)this;
    }

    public R params(HttpParams params) {
        this.mParams.put(params);
        return (R)this;
    }

    public R params(Map<String, Object> params) {
        this.mParams.put(params);
        return (R)this;
    }

    public R params(String key, Object value) {
        this.mParams.put(key, value);
        return (R)this;
    }

    public R removeParam(String key) {
        this.mParams.remove(key);
        return (R)this;
    }

    public R removeAllParams() {
        this.mParams.clear();
        return (R)this;
    }

    public HttpParams getParams() {
        return this.mParams;
    }

    public R okCache(Cache cache) {
        this.mCache = cache;
        return (R)this;
    }

    public R cacheMode(CacheMode cacheMode) {
        this.mCacheMode = cacheMode;
        return (R)this;
    }

    public R cacheKey(String cacheKey) {
        this.mCacheKey = cacheKey;
        return (R)this;
    }

    public R cacheTime(long cacheTime) {
        if (cacheTime <= -1L) {
            cacheTime = -1L;
        }
        this.mCacheTime = cacheTime;
        return (R)this;
    }

    public R cacheDiskConverter(IDiskConverter converter) {
        this.mDiskConverter = Utils.checkNotNull(converter, "converter == null");
        return (R)this;
    }

    public R okproxy(Proxy proxy) {
        this.mProxy = proxy;
        return (R)this;
    }

    public R addInterceptor(Interceptor interceptor) {
        this.mInterceptors.add(Utils.checkNotNull(interceptor, "interceptor == null"));
        return (R)this;
    }

    public R addNetworkInterceptor(Interceptor interceptor) {
        this.mNetworkInterceptors.add(Utils.checkNotNull(interceptor, "interceptor == null"));
        return (R)this;
    }

    public R addConverterFactory(Converter.Factory factory) {
        this.mConverterFactories.add(factory);
        return (R)this;
    }

    public R addCallAdapterFactory(CallAdapter.Factory factory) {
        this.mAdapterFactories.add(factory);
        return (R)this;
    }

    public R hostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.mHostnameVerifier = hostnameVerifier;
        return (R)this;
    }

    public R certificates(InputStream ... certificates) {
        this.mSSLParams = HttpsUtils.getSslSocketFactory(null, null, certificates);
        return (R)this;
    }

    public R certificates(InputStream bksFile, String password, InputStream ... certificates) {
        this.mSSLParams = HttpsUtils.getSslSocketFactory(bksFile, password, certificates);
        return (R)this;
    }

    public R addCookie(String name, String value) {
        Cookie.Builder builder = new Cookie.Builder();
        Cookie cookie = builder.name(name).value(value).domain(this.mHttpUrl.host()).build();
        this.mCookies.add(cookie);
        return (R)this;
    }

    public R addCookie(Cookie cookie) {
        this.mCookies.add(cookie);
        return (R)this;
    }

    public R addCookies(List<Cookie> cookies) {
        this.mCookies.addAll(cookies);
        return (R)this;
    }

    protected abstract Observable<ResponseBody> generateRequest();

    private OkHttpClient.Builder generateOkClient() {
        if (this.mReadTimeOut <= 0L && this.mWriteTimeOut <= 0L && this.mConnectTimeout <= 0L && this.mSSLParams == null && this.mCookies.size() == 0 && this.mHostnameVerifier == null && this.mProxy == null && this.mHeaders.isEmpty()) {
            OkHttpClient.Builder builder = XHttp.getOkHttpClientBuilder();
            for (Interceptor interceptor : builder.interceptors()) {
                if (!(interceptor instanceof BaseDynamicInterceptor)) continue;
                ((BaseDynamicInterceptor)((BaseDynamicInterceptor)((BaseDynamicInterceptor)interceptor).sign(this.mSign)).timeStamp(this.mTimeStamp)).accessToken(this.mAccessToken);
            }
            return builder;
        }
        OkHttpClient.Builder newClientBuilder = XHttp.getOkHttpClient().newBuilder();
        if (this.mReadTimeOut > 0L) {
            newClientBuilder.readTimeout(this.mReadTimeOut, TimeUnit.MILLISECONDS);
        }
        if (this.mWriteTimeOut > 0L) {
            newClientBuilder.writeTimeout(this.mWriteTimeOut, TimeUnit.MILLISECONDS);
        }
        if (this.mConnectTimeout > 0L) {
            newClientBuilder.connectTimeout(this.mConnectTimeout, TimeUnit.MILLISECONDS);
        }
        if (this.mHostnameVerifier != null) {
            newClientBuilder.hostnameVerifier(this.mHostnameVerifier);
        }
        if (this.mSSLParams != null) {
            newClientBuilder.sslSocketFactory(this.mSSLParams.sSLSocketFactory, this.mSSLParams.trustManager);
        }
        if (this.mProxy != null) {
            newClientBuilder.proxy(this.mProxy);
        }
        if (this.mCookies.size() > 0) {
            XHttp.getCookieJar().addCookies(this.mCookies);
        }
        for (Interceptor interceptor : this.mInterceptors) {
            if (interceptor instanceof BaseDynamicInterceptor) {
                ((BaseDynamicInterceptor)((BaseDynamicInterceptor)((BaseDynamicInterceptor)interceptor).sign(this.mSign)).timeStamp(this.mTimeStamp)).accessToken(this.mAccessToken);
            }
            newClientBuilder.addInterceptor(interceptor);
        }
        for (Interceptor interceptor : newClientBuilder.interceptors()) {
            if (!(interceptor instanceof BaseDynamicInterceptor)) continue;
            ((BaseDynamicInterceptor)((BaseDynamicInterceptor)((BaseDynamicInterceptor)interceptor).sign(this.mSign)).timeStamp(this.mTimeStamp)).accessToken(this.mAccessToken);
        }
        if (this.mNetworkInterceptors.size() > 0) {
            for (Interceptor interceptor : this.mNetworkInterceptors) {
                newClientBuilder.addNetworkInterceptor(interceptor);
            }
        }
        newClientBuilder.addInterceptor((Interceptor)new HeadersInterceptor(this.mHeaders));
        return newClientBuilder;
    }

    private Retrofit.Builder generateRetrofit() {
        if (this.mConverterFactories.isEmpty() && this.mAdapterFactories.isEmpty()) {
            return XHttp.getRetrofitBuilder().baseUrl(this.mBaseUrl);
        }
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder();
        if (!this.mConverterFactories.isEmpty()) {
            for (Converter.Factory converterFactory : this.mConverterFactories) {
                retrofitBuilder.addConverterFactory(converterFactory);
            }
        } else {
            Converter.Factory converterFactory;
            List listConverterFactory = XHttp.getRetrofitBuilder().converterFactories();
            converterFactory = listConverterFactory.iterator();
            while (converterFactory.hasNext()) {
                Converter.Factory factory = (Converter.Factory)converterFactory.next();
                retrofitBuilder.addConverterFactory(factory);
            }
        }
        if (!this.mAdapterFactories.isEmpty()) {
            for (CallAdapter.Factory adapterFactory : this.mAdapterFactories) {
                retrofitBuilder.addCallAdapterFactory(adapterFactory);
            }
        } else {
            List listAdapterFactory = XHttp.getRetrofitBuilder().callAdapterFactories();
            for (Converter.Factory factory : listAdapterFactory) {
                retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)factory);
            }
        }
        return retrofitBuilder.baseUrl(this.mBaseUrl);
    }

    private RxCache.Builder generateRxCache() {
        RxCache.Builder rxCacheBuilder = XHttp.getRxCacheBuilder();
        switch (this.mCacheMode) {
            case NO_CACHE: {
                NoCacheInterceptor NOCACHEINTERCEPTOR = new NoCacheInterceptor();
                this.mInterceptors.add(NOCACHEINTERCEPTOR);
                this.mNetworkInterceptors.add(NOCACHEINTERCEPTOR);
                break;
            }
            case DEFAULT: {
                if (this.mCache == null) {
                    File cacheDirectory = XHttp.getCacheDirectory();
                    if (cacheDirectory == null) {
                        cacheDirectory = new File(XHttp.getContext().getCacheDir(), "okhttp-cache");
                    } else if (cacheDirectory.isDirectory() && !cacheDirectory.exists()) {
                        cacheDirectory.mkdirs();
                    }
                    this.mCache = new Cache(cacheDirectory, Math.max(0x500000L, XHttp.getCacheMaxSize()));
                }
                String cacheControlValue = String.format("max-age=%d", Math.max(-1L, this.mCacheTime));
                CacheInterceptor REWRITE_CACHE_CONTROL_INTERCEPTOR = new CacheInterceptor(XHttp.getContext(), cacheControlValue);
                CacheInterceptorOffline REWRITE_CACHE_CONTROL_INTERCEPTOR_OFFLINE = new CacheInterceptorOffline(XHttp.getContext(), cacheControlValue);
                this.mNetworkInterceptors.add(REWRITE_CACHE_CONTROL_INTERCEPTOR);
                this.mNetworkInterceptors.add(REWRITE_CACHE_CONTROL_INTERCEPTOR_OFFLINE);
                this.mInterceptors.add(REWRITE_CACHE_CONTROL_INTERCEPTOR_OFFLINE);
                break;
            }
            case FIRST_REMOTE: 
            case FIRST_CACHE: 
            case ONLY_REMOTE: 
            case ONLY_CACHE: 
            case CACHE_REMOTE: 
            case CACHE_REMOTE_DISTINCT: {
                this.mInterceptors.add(new NoCacheInterceptor());
                if (this.mDiskConverter == null) {
                    RxCache.Builder tempRxCacheBuilder = rxCacheBuilder;
                    tempRxCacheBuilder.cacheKey(Utils.checkNotNull(this.mCacheKey, "mCacheKey == null")).cacheTime(this.mCacheTime);
                    return tempRxCacheBuilder;
                }
                RxCache.Builder cacheBuilder = XHttp.getRxCache().newBuilder();
                cacheBuilder.diskConverter(this.mDiskConverter).cacheKey(Utils.checkNotNull(this.mCacheKey, "mCacheKey == null")).cacheTime(this.mCacheTime);
                return cacheBuilder;
            }
        }
        return rxCacheBuilder;
    }

    protected R build() {
        RxCache.Builder rxCacheBuilder = this.generateRxCache();
        OkHttpClient.Builder okHttpClientBuilder = this.generateOkClient();
        if (this.mCacheMode == CacheMode.DEFAULT) {
            okHttpClientBuilder.cache(this.mCache);
        }
        Retrofit.Builder retrofitBuilder = this.generateRetrofit();
        retrofitBuilder.addCallAdapterFactory((CallAdapter.Factory)RxJava2CallAdapterFactory.create());
        this.mOkHttpClient = okHttpClientBuilder.build();
        retrofitBuilder.client(this.mOkHttpClient);
        this.mRetrofit = retrofitBuilder.build();
        this.mRxCache = rxCacheBuilder.build();
        this.mApiManager = (ApiService)this.mRetrofit.create(ApiService.class);
        return (R)this;
    }

    public <T> Observable<T> execute(Class<T> clazz) {
        return this.execute(new CallClazzProxy<ApiResult<T>, T>(clazz){});
    }

    public <T> Observable<T> execute(Type type) {
        return this.execute(new CallClazzProxy<ApiResult<T>, T>(type){});
    }

    public <T> Disposable execute(CallBack<T> callBack) {
        return this.execute(new CallBackProxy<ApiResult<T>, T>(callBack){});
    }

    protected <T> Observable<CacheResult<T>> toObservable(Observable observable, CallBackProxy<? extends ApiResult<T>, T> proxy) {
        return observable.map(new ApiResultFunc(proxy != null ? proxy.getType() : new TypeToken<ResponseBody>(){}.getType(), this.mKeepJson)).compose(new HttpResultTransformer()).compose(new HttpSchedulersTransformer(this.mIsSyncRequest, this.mIsOnMainThread)).compose(this.mRxCache.transformer(this.mCacheMode, proxy.getCallBack().getType())).retryWhen((Function)new RetryExceptionFunc(this.mRetryCount, this.mRetryDelay, this.mRetryIncreaseDelay));
    }

    public <T> Disposable execute(CallBackProxy<? extends ApiResult<T>, T> proxy) {
        Observable<CacheResult<T>> observable = ((BaseRequest)this.build()).toObservable(this.generateRequest(), proxy);
        if (CacheResult.class != proxy.getRawType()) {
            return (Disposable)observable.compose(new ObservableTransformer<CacheResult<T>, T>(){

                public ObservableSource<T> apply(@NonNull Observable<CacheResult<T>> upstream) {
                    return upstream.map(new CacheResultFunc());
                }
            }).subscribeWith(new CallBackSubscriber(proxy.getCallBack()));
        }
        return (Disposable)observable.subscribeWith(new CallBackSubscriber(proxy.getCallBack()));
    }

    public <T> Observable<T> execute(CallClazzProxy<? extends ApiResult<T>, T> proxy) {
        return ((BaseRequest)this.build()).generateRequest().map(new ApiResultFunc(proxy.getType(), this.mKeepJson)).compose(new HttpResultTransformer()).compose(new HttpSchedulersTransformer(this.mIsSyncRequest, this.mIsOnMainThread)).compose(this.mRxCache.transformer(this.mCacheMode, proxy.getCallType())).retryWhen((Function)new RetryExceptionFunc(this.mRetryCount, this.mRetryDelay, this.mRetryIncreaseDelay)).compose(new ObservableTransformer(){

            public ObservableSource apply(@NonNull Observable upstream) {
                return upstream.map(new CacheResultFunc());
            }
        });
    }
}

