/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.cookie;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.xuexiang.xhttp2.cookie.SerializableOkHttpCookies;
import com.xuexiang.xhttp2.logs.HttpLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.Cookie;
import okhttp3.HttpUrl;

public class PersistentCookieStore {
    private static final String COOKIE_PREFS = "Cookies_Prefs";
    private final Map<String, ConcurrentHashMap<String, Cookie>> cookies;
    private final SharedPreferences cookiePrefs;

    public PersistentCookieStore(Context context) {
        this.cookiePrefs = context.getSharedPreferences(COOKIE_PREFS, 0);
        this.cookies = new HashMap<String, ConcurrentHashMap<String, Cookie>>();
        Map prefsMap = this.cookiePrefs.getAll();
        for (Map.Entry entry : prefsMap.entrySet()) {
            String[] cookieNames;
            for (String name : cookieNames = TextUtils.split((String)((String)entry.getValue()), (String)",")) {
                Cookie decodedCookie;
                String encodedCookie = this.cookiePrefs.getString(name, null);
                if (encodedCookie == null || (decodedCookie = this.decodeCookie(encodedCookie)) == null) continue;
                if (!this.cookies.containsKey(entry.getKey())) {
                    this.cookies.put((String)entry.getKey(), new ConcurrentHashMap());
                }
                this.cookies.get(entry.getKey()).put(name, decodedCookie);
            }
        }
    }

    private String getCookieToken(Cookie cookie) {
        return cookie.name() + "@" + cookie.domain();
    }

    public void add(HttpUrl url, Cookie cookie) {
        String name = this.getCookieToken(cookie);
        if (!this.cookies.containsKey(url.host())) {
            this.cookies.put(url.host(), new ConcurrentHashMap());
        }
        if (this.cookies.containsKey(url.host())) {
            this.cookies.get(url.host()).remove(name);
        }
        this.cookies.get(url.host()).put(name, cookie);
        if (cookie.persistent()) {
            SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
            prefsWriter.putString(url.host(), TextUtils.join((CharSequence)",", (Iterable)this.cookies.get(url.host()).keySet()));
            prefsWriter.putString(name, this.encodeCookie(new SerializableOkHttpCookies(cookie)));
            prefsWriter.apply();
        } else {
            SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
            prefsWriter.remove(url.host());
            prefsWriter.remove(name);
            prefsWriter.apply();
        }
    }

    public void addCookies(List<Cookie> cookies) {
        for (Cookie cookie : cookies) {
            String domain = cookie.domain();
            ConcurrentHashMap<String, Object> domainCookies = this.cookies.get(domain);
            if (domainCookies == null) {
                domainCookies = new ConcurrentHashMap();
                this.cookies.put(domain, domainCookies);
            }
            cookies.add(cookie);
        }
    }

    public List<Cookie> get(HttpUrl url) {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        if (this.cookies.containsKey(url.host())) {
            ret.addAll(this.cookies.get(url.host()).values());
        }
        return ret;
    }

    public boolean removeAll() {
        SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
        prefsWriter.clear();
        prefsWriter.apply();
        this.cookies.clear();
        return true;
    }

    public boolean remove(HttpUrl url, Cookie cookie) {
        String name = this.getCookieToken(cookie);
        if (this.cookies.containsKey(url.host()) && this.cookies.get(url.host()).containsKey(name)) {
            this.cookies.get(url.host()).remove(name);
            SharedPreferences.Editor prefsWriter = this.cookiePrefs.edit();
            if (this.cookiePrefs.contains(name)) {
                prefsWriter.remove(name);
            }
            prefsWriter.putString(url.host(), TextUtils.join((CharSequence)",", (Iterable)this.cookies.get(url.host()).keySet()));
            prefsWriter.apply();
            return true;
        }
        return false;
    }

    public List<Cookie> getCookies() {
        ArrayList<Cookie> ret = new ArrayList<Cookie>();
        for (String key : this.cookies.keySet()) {
            ret.addAll(this.cookies.get(key).values());
        }
        return ret;
    }

    protected String encodeCookie(SerializableOkHttpCookies cookie) {
        if (cookie == null) {
            return null;
        }
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            ObjectOutputStream outputStream = new ObjectOutputStream(os);
            outputStream.writeObject(cookie);
        }
        catch (IOException e) {
            HttpLog.d("IOException in encodeCookie" + e.getMessage());
            return null;
        }
        return this.byteArrayToHexString(os.toByteArray());
    }

    private Cookie decodeCookie(String cookieString) {
        byte[] bytes = this.hexStringToByteArray(cookieString);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        Cookie cookie = null;
        try {
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            cookie = ((SerializableOkHttpCookies)objectInputStream.readObject()).getCookies();
        }
        catch (IOException e) {
            HttpLog.d("IOException in decodeCookie" + e.getMessage());
        }
        catch (ClassNotFoundException e) {
            HttpLog.d("ClassNotFoundException in decodeCookie" + e.getMessage());
        }
        return cookie;
    }

    private String byteArrayToHexString(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte element : bytes) {
            int v = element & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString().toUpperCase(Locale.US);
    }

    private byte[] hexStringToByteArray(String hexString) {
        int len = hexString.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(hexString.charAt(i), 16) << 4) + Character.digit(hexString.charAt(i + 1), 16));
        }
        return data;
    }
}

