/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.callback;

import com.xuexiang.xhttp2.callback.CallBack;
import com.xuexiang.xhttp2.exception.ApiException;
import com.xuexiang.xhttp2.subsciber.impl.IProgressLoader;
import com.xuexiang.xhttp2.subsciber.impl.OnProgressCancelListener;
import io.reactivex.disposables.Disposable;

public abstract class ProgressLoadingCallBack<T>
extends CallBack<T>
implements OnProgressCancelListener {
    private IProgressLoader mIProgressLoader;
    private boolean mIsShowProgress = true;
    private Disposable mDisposable;

    public ProgressLoadingCallBack(IProgressLoader iProgressLoader) {
        this.mIProgressLoader = iProgressLoader;
        this.init(false);
    }

    public ProgressLoadingCallBack(IProgressLoader iProgressLoader, boolean isShowProgress, boolean isCancel) {
        this.mIProgressLoader = iProgressLoader;
        this.mIsShowProgress = isShowProgress;
        this.init(isCancel);
    }

    private void init(boolean isCancel) {
        if (this.mIProgressLoader == null) {
            return;
        }
        this.mIProgressLoader.setCancelable(isCancel);
        if (isCancel) {
            this.mIProgressLoader.setOnProgressCancelListener(this);
        }
    }

    private void showProgress() {
        if (!this.mIsShowProgress) {
            return;
        }
        if (this.mIProgressLoader != null && !this.mIProgressLoader.isLoading()) {
            this.mIProgressLoader.showLoading();
        }
    }

    private void dismissProgress() {
        if (!this.mIsShowProgress) {
            return;
        }
        if (this.mIProgressLoader != null && this.mIProgressLoader.isLoading()) {
            this.mIProgressLoader.dismissLoading();
        }
    }

    @Override
    public void onStart() {
        this.showProgress();
    }

    @Override
    public void onCompleted() {
        this.dismissProgress();
    }

    @Override
    public void onError(ApiException e) {
        this.dismissProgress();
    }

    @Override
    public void onCancelProgress() {
        if (this.mDisposable != null && !this.mDisposable.isDisposed()) {
            this.mDisposable.dispose();
        }
    }

    public void subscription(Disposable disposable) {
        this.mDisposable = disposable;
    }
}

