/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.cache.core;

import com.xuexiang.xhttp2.cache.core.ICache;
import com.xuexiang.xhttp2.utils.Utils;
import java.lang.reflect.Type;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public abstract class BaseDiskCache
implements ICache {
    private final ReadWriteLock mLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final <T> T load(Type type, String key, long existTime) {
        Utils.checkNotNull(key, "key == null");
        if (!this.containsKey(key)) {
            return null;
        }
        if (this.isExpiry(key, existTime)) {
            this.remove(key);
            return null;
        }
        this.mLock.readLock().lock();
        try {
            T t = this.doLoad(type, key);
            return t;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> boolean save(String key, T value) {
        Utils.checkNotNull(key, "key == null");
        if (value == null) {
            return this.remove(key);
        }
        boolean status = false;
        this.mLock.writeLock().lock();
        try {
            status = this.doSave(key, value);
        }
        finally {
            this.mLock.writeLock().unlock();
        }
        return status;
    }

    @Override
    public final boolean remove(String key) {
        this.mLock.writeLock().lock();
        try {
            boolean bl = this.doRemove(key);
            return bl;
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    @Override
    public final boolean clear() {
        this.mLock.writeLock().lock();
        try {
            boolean bl = this.doClear();
            return bl;
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    @Override
    public final boolean containsKey(String key) {
        this.mLock.readLock().lock();
        try {
            boolean bl = this.doContainsKey(key);
            return bl;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    protected abstract boolean doContainsKey(String var1);

    protected abstract boolean isExpiry(String var1, long var2);

    protected abstract <T> T doLoad(Type var1, String var2);

    protected abstract <T> boolean doSave(String var1, T var2);

    protected abstract boolean doRemove(String var1);

    protected abstract boolean doClear();
}

