/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2;

import android.support.annotation.NonNull;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class XHttpRequestPool {
    private static XHttpRequestPool sInstance;
    private ConcurrentHashMap<Object, CompositeDisposable> maps = new ConcurrentHashMap();

    private XHttpRequestPool() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static XHttpRequestPool get() {
        if (sInstance != null) return sInstance;
        Class<XHttpRequestPool> clazz = XHttpRequestPool.class;
        synchronized (XHttpRequestPool.class) {
            if (sInstance != null) return sInstance;
            sInstance = new XHttpRequestPool();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public Disposable add(@NonNull Object tagName, Disposable disposable) {
        CompositeDisposable compositeDisposable = this.maps.get(tagName);
        if (compositeDisposable == null) {
            compositeDisposable = new CompositeDisposable();
            this.maps.put(tagName, compositeDisposable);
        }
        compositeDisposable.add(disposable);
        return disposable;
    }

    public Disposable add(Disposable disposable, @NonNull Object tagName) {
        CompositeDisposable compositeDisposable = this.maps.get(tagName);
        if (compositeDisposable == null) {
            compositeDisposable = new CompositeDisposable();
            this.maps.put(tagName, compositeDisposable);
        }
        compositeDisposable.add(disposable);
        return disposable;
    }

    public void remove(@NonNull Object tagName) {
        CompositeDisposable compositeDisposable = this.maps.get(tagName);
        if (compositeDisposable != null) {
            compositeDisposable.dispose();
            this.maps.remove(tagName);
        }
    }

    public void remove(@NonNull Object tagName, Disposable disposable) {
        CompositeDisposable compositeDisposable = this.maps.get(tagName);
        if (compositeDisposable != null) {
            compositeDisposable.remove(disposable);
            if (compositeDisposable.size() == 0) {
                this.maps.remove(tagName);
            }
        }
    }

    public void removeAll() {
        Iterator<Map.Entry<Object, CompositeDisposable>> it = this.maps.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, CompositeDisposable> entry = it.next();
            CompositeDisposable compositeDisposable = entry.getValue();
            if (compositeDisposable == null) continue;
            compositeDisposable.dispose();
            it.remove();
        }
        this.maps.clear();
    }

    public static void dispose(Disposable disposable) {
        if (disposable != null && !disposable.isDisposed()) {
            disposable.dispose();
        }
    }
}

