/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.subsciber;

import com.xuexiang.xhttp2.exception.ApiException;
import com.xuexiang.xhttp2.logs.HttpLog;
import com.xuexiang.xhttp2.subsciber.BaseSubscriber;
import com.xuexiang.xhttp2.subsciber.impl.IProgressLoader;
import com.xuexiang.xhttp2.subsciber.impl.OnProgressCancelListener;

public abstract class ProgressLoadingSubscriber<T>
extends BaseSubscriber<T>
implements OnProgressCancelListener {
    private IProgressLoader mIProgressLoader;
    private boolean mIsShowProgress = true;

    public ProgressLoadingSubscriber() {
        this.init(false);
    }

    public ProgressLoadingSubscriber(IProgressLoader iProgressLoader) {
        this.mIProgressLoader = iProgressLoader;
        this.init(false);
    }

    public ProgressLoadingSubscriber(IProgressLoader iProgressLoader, boolean isShowProgress, boolean isCancel) {
        this.mIProgressLoader = iProgressLoader;
        this.mIsShowProgress = isShowProgress;
        this.init(isCancel);
    }

    private void init(boolean isCancel) {
        if (this.mIProgressLoader == null) {
            return;
        }
        this.mIProgressLoader.setCancelable(isCancel);
        if (isCancel) {
            this.mIProgressLoader.setOnProgressCancelListener(this);
        }
    }

    private void showProgress() {
        if (!this.mIsShowProgress) {
            return;
        }
        if (this.mIProgressLoader != null && !this.mIProgressLoader.isLoading()) {
            this.mIProgressLoader.showLoading();
        }
    }

    private void dismissProgress() {
        if (!this.mIsShowProgress) {
            return;
        }
        if (this.mIProgressLoader != null && this.mIProgressLoader.isLoading()) {
            this.mIProgressLoader.dismissLoading();
        }
    }

    @Override
    public void onStart() {
        this.showProgress();
    }

    @Override
    public void onComplete() {
        this.dismissProgress();
    }

    @Override
    public void onError(ApiException e) {
        HttpLog.e(e);
        this.dismissProgress();
    }

    @Override
    public void onCancelProgress() {
        if (!this.isDisposed()) {
            this.dispose();
        }
    }
}

