/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.subsciber;

import android.annotation.SuppressLint;
import android.text.TextUtils;
import com.xuexiang.xhttp2.callback.CallBack;
import com.xuexiang.xhttp2.callback.DownloadProgressCallBack;
import com.xuexiang.xhttp2.exception.ApiException;
import com.xuexiang.xhttp2.logs.HttpLog;
import com.xuexiang.xhttp2.subsciber.BaseSubscriber;
import com.xuexiang.xhttp2.utils.Utils;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.annotations.NonNull;
import io.reactivex.functions.Consumer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import okhttp3.ResponseBody;

public class DownloadSubscriber<ResponseBody extends ResponseBody>
extends BaseSubscriber<ResponseBody> {
    private String path;
    private String name;
    private CallBack mCallBack;
    private static String APK_CONTENT_TYPE = "application/vnd.android.package-archive";
    private static String PNG_CONTENT_TYPE = "image/png";
    private static String JPG_CONTENT_TYPE = "image/jpg";
    private static String MP4_CONTENT_TYPE = "video/mp4";
    private long lastRefreshUiTime;

    public DownloadSubscriber(String path, String name, CallBack callBack) {
        this.path = path;
        this.name = name;
        this.mCallBack = callBack;
        this.lastRefreshUiTime = System.currentTimeMillis();
    }

    @Override
    public void onStart() {
        super.onStart();
        if (this.mCallBack != null) {
            this.mCallBack.onStart();
        }
    }

    @Override
    public final void onComplete() {
    }

    @Override
    public void onError(ApiException e) {
        this.finalOnError(e);
    }

    @Override
    protected void onSuccess(ResponseBody responseBody) {
        this.writeResponseBodyToDisk(this.path, this.name, (ResponseBody)responseBody);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeResponseBodyToDisk(String path, String name, ResponseBody body) {
        name = this.checkFileName(name, body);
        path = this.checkFilePath(path, name);
        HttpLog.i("path:-->" + path);
        File downLoadFile = new File(path);
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int read;
            byte[] bytes = new byte[131072];
            long fileSize = body.contentLength();
            long downloadSize = 0L;
            HttpLog.i("file length: " + fileSize);
            inputStream = body.byteStream();
            outputStream = new FileOutputStream(downLoadFile);
            CallBack callBack = this.mCallBack;
            while ((read = inputStream.read(bytes)) != -1) {
                outputStream.write(bytes, 0, read);
                this.updateDownLoadProgress(fileSize, downloadSize += (long)read, callBack);
            }
            outputStream.flush();
            HttpLog.i("file downloaded: " + downloadSize + " of " + fileSize);
            this.handleDownLoadFinished(path, callBack);
        }
        catch (Throwable e) {
            try {
                this.onError(e);
            }
            catch (Throwable throwable) {
                Utils.closeIO(outputStream, inputStream);
                throw throwable;
            }
            Utils.closeIO(outputStream, inputStream);
        }
        Utils.closeIO(outputStream, inputStream);
    }

    @SuppressLint(value={"CheckResult"})
    private void updateDownLoadProgress(final long fileSize, long downloadSize, final CallBack callBack) {
        HttpLog.d("file download: " + downloadSize + " of " + fileSize);
        float progress = (float)downloadSize * 1.0f / (float)fileSize;
        long curTime = System.currentTimeMillis();
        if (curTime - this.lastRefreshUiTime >= 200L || progress == 1.0f) {
            if (callBack != null) {
                final long finalFileSizeDownloaded = downloadSize;
                Observable.just((Object)finalFileSizeDownloaded).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                    public void accept(@NonNull Long aLong) throws Exception {
                        if (callBack instanceof DownloadProgressCallBack) {
                            ((DownloadProgressCallBack)callBack).update(finalFileSizeDownloaded, fileSize, finalFileSizeDownloaded == fileSize);
                        }
                    }
                }, (Consumer)new Consumer<Throwable>(){

                    public void accept(@NonNull Throwable throwable) throws Exception {
                    }
                });
            }
            this.lastRefreshUiTime = System.currentTimeMillis();
        }
    }

    @SuppressLint(value={"CheckResult"})
    private void handleDownLoadFinished(String path, final CallBack callBack) {
        if (callBack != null) {
            final String finalPath = path;
            Observable.just((Object)finalPath).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<String>(){

                public void accept(@NonNull String s) throws Exception {
                    if (callBack instanceof DownloadProgressCallBack) {
                        ((DownloadProgressCallBack)callBack).onComplete(finalPath);
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(@NonNull Throwable throwable) throws Exception {
                }
            });
            HttpLog.i("file downloaded: is success");
        }
    }

    private String checkFileName(String name, ResponseBody body) {
        HttpLog.d("contentType:>>>>" + body.contentType().toString());
        if (!TextUtils.isEmpty((CharSequence)name)) {
            if (!name.contains(".")) {
                name = name + this.getFileSuffix(body);
            }
        } else {
            name = System.currentTimeMillis() + this.getFileSuffix(body);
        }
        return name;
    }

    private String checkFilePath(String path, String name) {
        if (path == null) {
            path = Utils.getDiskFilesDir(name);
        } else {
            File file = new File(path);
            if (!file.exists()) {
                file.mkdirs();
            }
            path = path + File.separator + name;
            path = path.replaceAll("//", "/");
        }
        return path;
    }

    private String getFileSuffix(ResponseBody body) {
        String type = body.contentType().toString();
        String fileSuffix = type.equals(APK_CONTENT_TYPE) ? ".apk" : (type.equals(PNG_CONTENT_TYPE) ? ".png" : (type.equals(JPG_CONTENT_TYPE) ? ".jpg" : (type.equals(MP4_CONTENT_TYPE) ? ".mp4" : "." + body.contentType().subtype())));
        return fileSuffix;
    }

    @SuppressLint(value={"CheckResult"})
    private void finalOnError(Throwable e) {
        if (this.mCallBack == null) {
            return;
        }
        Observable.just((Object)new ApiException(e, 5012)).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<ApiException>(){

            public void accept(@NonNull ApiException e) throws Exception {
                if (DownloadSubscriber.this.mCallBack != null) {
                    DownloadSubscriber.this.mCallBack.onError(e);
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(@NonNull Throwable throwable) throws Exception {
            }
        });
    }
}

