/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.request;

import com.xuexiang.xhttp2.XHttp;
import com.xuexiang.xhttp2.callback.CallBack;
import com.xuexiang.xhttp2.request.BaseRequest;
import com.xuexiang.xhttp2.subsciber.DownloadSubscriber;
import com.xuexiang.xhttp2.transform.HandleErrTransformer;
import com.xuexiang.xhttp2.transform.func.RetryExceptionFunc;
import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Function;
import io.reactivex.schedulers.Schedulers;
import okhttp3.ResponseBody;

public class DownloadRequest
extends BaseRequest<DownloadRequest> {
    private String mSavePath;
    private String mSaveName;
    private boolean mIsUseBaseUrl;

    public DownloadRequest(String url) {
        super(url);
    }

    public DownloadRequest savePath(String savePath) {
        this.mSavePath = savePath;
        return this;
    }

    public DownloadRequest saveName(String saveName) {
        this.mSaveName = saveName;
        return this;
    }

    public DownloadRequest isUseBaseUrl(boolean isUseBaseUrl) {
        this.mIsUseBaseUrl = isUseBaseUrl;
        return this;
    }

    @Override
    public <T> Disposable execute(CallBack<T> callBack) {
        return (Disposable)((DownloadRequest)this.build()).generateRequest().compose((ObservableTransformer)new ObservableTransformer<ResponseBody, ResponseBody>(){

            public ObservableSource<ResponseBody> apply(@NonNull Observable<ResponseBody> upstream) {
                if (DownloadRequest.this.mIsSyncRequest) {
                    return upstream;
                }
                return upstream.subscribeOn(Schedulers.io()).unsubscribeOn(Schedulers.io()).observeOn(Schedulers.computation());
            }
        }).compose(new HandleErrTransformer()).retryWhen((Function)new RetryExceptionFunc(this.mRetryCount, this.mRetryDelay, this.mRetryIncreaseDelay)).subscribeWith(new DownloadSubscriber(this.mSavePath, this.mSaveName, callBack));
    }

    @Override
    protected Observable<ResponseBody> generateRequest() {
        if (this.mIsUseBaseUrl) {
            return this.mApiManager.downloadFile(XHttp.getBaseUrl() + this.getUrl());
        }
        return this.mApiManager.downloadFile(this.mUrl);
    }
}

