/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xhttp2.cache;

import android.content.Context;
import android.os.StatFs;
import com.xuexiang.xhttp2.cache.converter.IDiskConverter;
import com.xuexiang.xhttp2.cache.converter.SerializableDiskConverter;
import com.xuexiang.xhttp2.cache.core.CacheCore;
import com.xuexiang.xhttp2.cache.core.LruDiskCache;
import com.xuexiang.xhttp2.cache.core.LruMemoryCache;
import com.xuexiang.xhttp2.cache.model.CacheMode;
import com.xuexiang.xhttp2.cache.model.CacheResult;
import com.xuexiang.xhttp2.cache.stategy.IStrategy;
import com.xuexiang.xhttp2.logs.HttpLog;
import com.xuexiang.xhttp2.utils.TypeUtils;
import com.xuexiang.xhttp2.utils.Utils;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.ObservableSource;
import io.reactivex.ObservableTransformer;
import io.reactivex.annotations.NonNull;
import io.reactivex.exceptions.Exceptions;
import java.io.File;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public final class RxCache {
    public static final long CACHE_NEVER_EXPIRE = -1L;
    private boolean isDiskCache;
    private int memoryMaxSize;
    private final Context context;
    private final CacheCore cacheCore;
    private final String cacheKey;
    private final long cacheTime;
    private final IDiskConverter diskConverter;
    private final File diskDir;
    private final int appVersion;
    private final long diskMaxSize;

    public RxCache() {
        this(new Builder());
    }

    private RxCache(Builder builder) {
        this.context = builder.context;
        this.isDiskCache = builder.isDiskCache;
        this.memoryMaxSize = builder.memoryMaxSize;
        this.cacheKey = builder.cacheKey;
        this.cacheTime = builder.cacheTime;
        this.diskDir = builder.diskDir;
        this.appVersion = builder.appVersion;
        this.diskMaxSize = builder.diskMaxSize;
        this.diskConverter = builder.diskConverter;
        this.cacheCore = this.isDiskCache ? new CacheCore(new LruDiskCache(this.diskConverter, this.diskDir, this.appVersion, this.diskMaxSize)) : new CacheCore(new LruMemoryCache(builder.memoryMaxSize));
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public <T> ObservableTransformer<T, CacheResult<T>> transformer(final CacheMode cacheMode, final Type type) {
        final IStrategy strategy = this.loadStrategy(cacheMode);
        return new ObservableTransformer<T, CacheResult<T>>(){

            public ObservableSource<CacheResult<T>> apply(@NonNull Observable<T> upstream) {
                Class cls;
                HttpLog.i("cacheMode=" + (Object)((Object)cacheMode) + ", cacheKey=" + RxCache.this.cacheKey);
                Type tempType = type;
                if (type instanceof ParameterizedType && CacheResult.class.isAssignableFrom(cls = (Class)((ParameterizedType)type).getRawType())) {
                    tempType = TypeUtils.getParameterizedType(type, 0);
                }
                return strategy.execute(RxCache.this, RxCache.this.cacheKey, RxCache.this.cacheTime, upstream, tempType);
            }
        };
    }

    public <T> Observable<T> load(Type type, String key) {
        return this.load(type, key, -1L);
    }

    public <T> Observable<T> load(final Type type, final String key, final long time) {
        return Observable.create((ObservableOnSubscribe)new SimpleSubscribe<T>(){

            @Override
            T execute() {
                return RxCache.this.cacheCore.load(type, key, time);
            }
        });
    }

    public <T> Observable<Boolean> save(final String key, final T value) {
        return Observable.create((ObservableOnSubscribe)new SimpleSubscribe<Boolean>(){

            @Override
            Boolean execute() throws Throwable {
                RxCache.this.cacheCore.save(key, value);
                return true;
            }
        });
    }

    public Observable<Boolean> containsKey(final String key) {
        return Observable.create((ObservableOnSubscribe)new SimpleSubscribe<Boolean>(){

            @Override
            Boolean execute() throws Throwable {
                return RxCache.this.cacheCore.containsKey(key);
            }
        });
    }

    public Observable<Boolean> remove(final String key) {
        return Observable.create((ObservableOnSubscribe)new SimpleSubscribe<Boolean>(){

            @Override
            Boolean execute() throws Throwable {
                return RxCache.this.cacheCore.remove(key);
            }
        });
    }

    public Observable<Boolean> clear() {
        return Observable.create((ObservableOnSubscribe)new SimpleSubscribe<Boolean>(){

            @Override
            Boolean execute() throws Throwable {
                return RxCache.this.cacheCore.clear();
            }
        });
    }

    private IStrategy loadStrategy(CacheMode cacheMode) {
        try {
            String pkName = IStrategy.class.getPackage().getName();
            return (IStrategy)Class.forName(pkName + "." + cacheMode.getClassName()).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("loadStrategy(" + (Object)((Object)cacheMode) + ") err!!" + e.getMessage());
        }
    }

    public long getCacheTime() {
        return this.cacheTime;
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public Context getContext() {
        return this.context;
    }

    public CacheCore getCacheCore() {
        return this.cacheCore;
    }

    public IDiskConverter getDiskConverter() {
        return this.diskConverter;
    }

    public File getDiskDir() {
        return this.diskDir;
    }

    public int getAppVersion() {
        return this.appVersion;
    }

    public long getDiskMaxSize() {
        return this.diskMaxSize;
    }

    public static final class Builder {
        private static final int MIN_DISK_CACHE_SIZE = 0x500000;
        private static final int MAX_DISK_CACHE_SIZE = 0x3200000;
        private Context context;
        private boolean isDiskCache;
        private int memoryMaxSize;
        private int appVersion;
        private long diskMaxSize;
        private File diskDir;
        private IDiskConverter diskConverter;
        private String cacheKey;
        private long cacheTime;

        public Builder() {
            this.isDiskCache = true;
            this.diskConverter = new SerializableDiskConverter();
            this.cacheTime = -1L;
            this.appVersion = 1;
        }

        public Builder(RxCache rxCache) {
            this.context = rxCache.context;
            this.isDiskCache = rxCache.isDiskCache;
            this.memoryMaxSize = rxCache.memoryMaxSize;
            this.appVersion = rxCache.appVersion;
            this.diskMaxSize = rxCache.diskMaxSize;
            this.diskDir = rxCache.diskDir;
            this.diskConverter = rxCache.diskConverter;
            this.cacheKey = rxCache.cacheKey;
            this.cacheTime = rxCache.cacheTime;
        }

        public Builder init(Context context) {
            this.context = context;
            return this;
        }

        public Builder isDiskCache(boolean isDiskCache) {
            this.isDiskCache = isDiskCache;
            return this;
        }

        public Builder memoryMaxSize(int memoryMaxSize) {
            this.memoryMaxSize = memoryMaxSize;
            return this;
        }

        public Builder appVersion(int appVersion) {
            this.appVersion = appVersion;
            return this;
        }

        public Builder diskDir(File directory) {
            this.diskDir = directory;
            return this;
        }

        public Builder diskConverter(IDiskConverter converter) {
            this.diskConverter = converter;
            return this;
        }

        public Builder diskMax(long maxSize) {
            this.diskMaxSize = maxSize;
            return this;
        }

        public Builder cacheKey(String cacheKey) {
            this.cacheKey = cacheKey;
            return this;
        }

        public Builder cacheTime(long cacheTime) {
            this.cacheTime = cacheTime;
            return this;
        }

        public RxCache build() {
            if (this.isDiskCache) {
                if (this.diskDir == null && this.context != null) {
                    this.diskDir = Utils.getDiskCacheDir(this.context, "data-cache");
                }
                Utils.checkNotNull(this.diskDir, "diskDir == null");
                if (!this.diskDir.exists()) {
                    this.diskDir.mkdirs();
                }
                if (this.diskConverter == null) {
                    this.diskConverter = new SerializableDiskConverter();
                }
                if (this.diskMaxSize <= 0L) {
                    this.diskMaxSize = Builder.calculateDiskCacheSize(this.diskDir);
                }
                this.appVersion = Math.max(1, this.appVersion);
            } else if (this.memoryMaxSize <= 0) {
                this.memoryMaxSize = (int)(Runtime.getRuntime().maxMemory() / 1024L) / 8;
            }
            this.cacheTime = Math.max(-1L, this.cacheTime);
            return new RxCache(this);
        }

        private static long calculateDiskCacheSize(File dir) {
            long size = 0L;
            try {
                StatFs statFs = new StatFs(dir.getAbsolutePath());
                long available = (long)statFs.getBlockCount() * (long)statFs.getBlockSize();
                size = available / 50L;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            return Math.max(Math.min(size, 0x3200000L), 0x500000L);
        }
    }

    private static abstract class SimpleSubscribe<T>
    implements ObservableOnSubscribe<T> {
        private SimpleSubscribe() {
        }

        public void subscribe(@NonNull ObservableEmitter<T> subscriber) throws Exception {
            try {
                T data = this.execute();
                if (!subscriber.isDisposed()) {
                    subscriber.onNext(data);
                }
            }
            catch (Throwable e) {
                HttpLog.e(e);
                if (!subscriber.isDisposed()) {
                    subscriber.onError(e);
                }
                Exceptions.throwIfFatal((Throwable)e);
                return;
            }
            if (!subscriber.isDisposed()) {
                subscriber.onComplete();
            }
        }

        abstract T execute() throws Throwable;
    }
}

