/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xaop.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Environment;
import android.support.annotation.NonNull;
import com.xuexiang.xaop.XAOP;
import com.xuexiang.xaop.logger.XLogger;
import com.xuexiang.xaop.util.Strings;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.reflect.CodeSignature;
import org.aspectj.lang.reflect.MethodSignature;

public final class Utils {
    private Utils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    public static String listToString(List<String> list, String separator) {
        if (list == null || list.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i)).append(separator);
        }
        return sb.toString().substring(0, sb.toString().length() - 1);
    }

    public static String listToString(List<String> list) {
        return Utils.listToString(list, ",");
    }

    public static String getClassName(Class<?> cls) {
        if (cls == null) {
            return "<UnKnow Class>";
        }
        if (cls.isAnonymousClass()) {
            return Utils.getClassName(cls.getEnclosingClass());
        }
        return cls.getSimpleName();
    }

    public static String toString(Object object) {
        if (XLogger.getISerializer() != null) {
            return XLogger.getISerializer().toString(object);
        }
        return Strings.toString(object);
    }

    public static String getMethodDescribeInfo(ProceedingJoinPoint joinPoint) {
        CodeSignature codeSignature = (CodeSignature)joinPoint.getSignature();
        Class cls = codeSignature.getDeclaringType();
        String methodName = codeSignature.getName();
        return Utils.getClassName(cls) + "->" + methodName;
    }

    public static String getMethodName(ProceedingJoinPoint joinPoint) {
        CodeSignature codeSignature = (CodeSignature)joinPoint.getSignature();
        Class cls = codeSignature.getDeclaringType();
        String methodName = codeSignature.getName();
        return Utils.getClassName(cls) + "." + methodName;
    }

    public static <T> T checkNotNull(T t, String message) {
        if (t == null) {
            throw new NullPointerException(message);
        }
        return t;
    }

    public static void closeIO(Closeable ... closeables) {
        if (closeables == null) {
            return;
        }
        for (Closeable closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static File getDiskCacheDir(Context context, String uniqueName) {
        String cachePath = Utils.isSDCardEnable() && context.getExternalCacheDir() != null ? context.getExternalCacheDir().getPath() : context.getCacheDir().getPath();
        return new File(cachePath + File.separator + uniqueName);
    }

    private static boolean isSDCardEnable() {
        return "mounted".equals(Environment.getExternalStorageState()) || !Environment.isExternalStorageRemovable();
    }

    public static int getAppVersionCode(Context context) {
        PackageManager pm;
        if (context != null && (pm = context.getPackageManager()) != null) {
            try {
                PackageInfo pi = pm.getPackageInfo(context.getPackageName(), 0);
                if (pi != null) {
                    return pi.versionCode;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                e.printStackTrace();
            }
        }
        return -1;
    }

    @NonNull
    public static String getCacheKey(ProceedingJoinPoint joinPoint) {
        return XAOP.getICacheKeyCreator().getCacheKey(joinPoint);
    }

    public static boolean isHasReturnType(Signature signature) {
        return signature instanceof MethodSignature && ((MethodSignature)signature).getReturnType() != Void.TYPE;
    }
}

