/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xaop.aspectj;

import android.text.TextUtils;
import com.xuexiang.xaop.annotation.DiskCache;
import com.xuexiang.xaop.cache.XDiskCache;
import com.xuexiang.xaop.logger.XLogger;
import com.xuexiang.xaop.util.Utils;
import java.util.Collection;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;

@Aspect
public class DiskCacheAspectJ {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ DiskCacheAspectJ ajc$perSingletonInstance;

    @Pointcut(value="within(@com.xuexiang.xaop.annotation.DiskCache *)")
    public void withinAnnotatedClass() {
    }

    @Pointcut(value="execution(!synthetic * *(..)) && withinAnnotatedClass()")
    public void methodInsideAnnotatedType() {
    }

    @Pointcut(value="execution(@com.xuexiang.xaop.annotation.DiskCache * *(..)) || methodInsideAnnotatedType()")
    public void method() {
    }

    @Around(value="method() && @annotation(diskCache)")
    public Object aroundJoinPoint(ProceedingJoinPoint joinPoint, DiskCache diskCache) throws Throwable {
        if (!Utils.isHasReturnType(joinPoint.getSignature())) {
            return joinPoint.proceed();
        }
        String key = diskCache.value();
        if (TextUtils.isEmpty((CharSequence)key)) {
            key = Utils.getCacheKey(joinPoint);
        }
        Object result = XDiskCache.getInstance().load(((MethodSignature)joinPoint.getSignature()).getReturnType(), key, diskCache.cacheTime());
        XLogger.dTag("DiskCache", this.getCacheMsg(joinPoint, key, result));
        if (result != null) {
            return result;
        }
        result = joinPoint.proceed();
        if (result != null) {
            if (result instanceof Collection && !((Collection)result).isEmpty() || result instanceof String && !TextUtils.isEmpty((CharSequence)((String)result))) {
                this.saveResult(key, result);
            } else {
                this.saveResult(key, result);
            }
        }
        return result;
    }

    private void saveResult(String key, Object result) {
        XDiskCache.getInstance().save(key, result);
        XLogger.dTag("DiskCache", "key\uff1a" + key + "--->save ");
    }

    private String getCacheMsg(ProceedingJoinPoint joinPoint, String key, Object value) {
        return "key\uff1a" + key + "--->" + (value != null ? "not null, do not need to proceed method " + joinPoint.getSignature().getName() : "null, need to proceed method " + joinPoint.getSignature().getName());
    }

    public static DiskCacheAspectJ aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.xuexiang.xaop.aspectj.DiskCacheAspectJ", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            DiskCacheAspectJ.ajc$perSingletonInstance = new DiskCacheAspectJ();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

