/*
 * Decompiled with CFR 0.152.
 */
package com.xuexiang.xaop.aspectj;

import android.os.Build;
import android.os.Looper;
import android.os.Trace;
import android.support.annotation.NonNull;
import com.xuexiang.xaop.annotation.DebugLog;
import com.xuexiang.xaop.logger.XLogger;
import com.xuexiang.xaop.util.Utils;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.NoAspectBoundException;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.CodeSignature;

@Aspect
public class DebugLogAspectJ {
    private static /* synthetic */ Throwable ajc$initFailureCause;
    public static final /* synthetic */ DebugLogAspectJ ajc$perSingletonInstance;

    @Pointcut(value="within(@com.xuexiang.xaop.annotation.DebugLog *)")
    public void withinAnnotatedClass() {
    }

    @Pointcut(value="execution(!synthetic * *(..)) && withinAnnotatedClass()")
    public void methodInsideAnnotatedType() {
    }

    @Pointcut(value="execution(!synthetic *.new(..)) && withinAnnotatedClass()")
    public void constructorInsideAnnotatedType() {
    }

    @Pointcut(value="execution(@com.xuexiang.xaop.annotation.DebugLog * *(..)) || methodInsideAnnotatedType()")
    public void method() {
    }

    @Pointcut(value="execution(@com.xuexiang.xaop.annotation.DebugLog *.new(..)) || constructorInsideAnnotatedType()")
    public void constructor() {
    }

    @Around(value="(method() || constructor()) && @annotation(debugLog)")
    public Object logAndExecute(ProceedingJoinPoint joinPoint, DebugLog debugLog) throws Throwable {
        this.enterMethod(joinPoint, debugLog);
        long startNanos = System.nanoTime();
        Object result = joinPoint.proceed();
        long stopNanos = System.nanoTime();
        long lengthMillis = TimeUnit.NANOSECONDS.toMillis(stopNanos - startNanos);
        this.exitMethod(joinPoint, debugLog, result, lengthMillis);
        return result;
    }

    private void enterMethod(ProceedingJoinPoint joinPoint, DebugLog debugLog) {
        if (!XLogger.isDebug()) {
            return;
        }
        CodeSignature codeSignature = (CodeSignature)joinPoint.getSignature();
        Class cls = codeSignature.getDeclaringType();
        String methodName = codeSignature.getName();
        String[] parameterNames = codeSignature.getParameterNames();
        Object[] parameterValues = joinPoint.getArgs();
        StringBuilder builder = this.getMethodLogInfo(methodName, parameterNames, parameterValues);
        XLogger.log(debugLog.priority(), Utils.getClassName(cls), builder.toString());
        if (Build.VERSION.SDK_INT >= 18) {
            String section = builder.toString().substring(2);
            Trace.beginSection((String)section);
        }
    }

    @NonNull
    private StringBuilder getMethodLogInfo(String methodName, String[] parameterNames, Object[] parameterValues) {
        StringBuilder builder = new StringBuilder("\u21e2 ");
        builder.append(methodName).append('(');
        for (int i = 0; i < parameterValues.length; ++i) {
            if (i > 0) {
                builder.append(", ");
            }
            builder.append(parameterNames[i]).append('=');
            builder.append(Utils.toString(parameterValues[i]));
        }
        builder.append(')');
        if (Looper.myLooper() != Looper.getMainLooper()) {
            builder.append(" [Thread:\"").append(Thread.currentThread().getName()).append("\"]");
        }
        return builder;
    }

    private void exitMethod(ProceedingJoinPoint joinPoint, DebugLog debugLog, Object result, long lengthMillis) {
        if (!XLogger.isDebug()) {
            return;
        }
        if (Build.VERSION.SDK_INT >= 18) {
            Trace.endSection();
        }
        Signature signature = joinPoint.getSignature();
        Class cls = signature.getDeclaringType();
        String methodName = signature.getName();
        boolean hasReturnType = Utils.isHasReturnType(signature);
        StringBuilder builder = new StringBuilder("\u21e0 ").append(methodName).append(" [").append(lengthMillis).append("ms]");
        if (hasReturnType) {
            builder.append(" = ");
            builder.append(Utils.toString(result));
        }
        XLogger.log(debugLog.priority(), Utils.getClassName(cls), builder.toString());
    }

    public static DebugLogAspectJ aspectOf() {
        if (ajc$perSingletonInstance == null) {
            throw new NoAspectBoundException("com.xuexiang.xaop.aspectj.DebugLogAspectJ", ajc$initFailureCause);
        }
        return ajc$perSingletonInstance;
    }

    public static boolean hasAspect() {
        return ajc$perSingletonInstance != null;
    }

    static {
        try {
            DebugLogAspectJ.ajc$perSingletonInstance = new DebugLogAspectJ();
        }
        catch (Throwable throwable) {
            ajc$initFailureCause = throwable;
        }
    }
}

