/*
 * Decompiled with CFR 0.152.
 */
package com.ark.dict;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import com.ark.dict.Utils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SharedPrefUtils {
    private static List<Class<?>> CLASSES = new ArrayList();
    private static SharedPreferences prefs;

    private SharedPrefUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SharedPreferences getPrefs() {
        SharedPreferences result = prefs;
        if (result != null) return result;
        Class<SharedPrefUtils> clazz = SharedPrefUtils.class;
        synchronized (SharedPrefUtils.class) {
            result = prefs;
            if (result != null) return result;
            prefs = PreferenceManager.getDefaultSharedPreferences((Context)Utils.getContext());
            return prefs;
        }
    }

    @TargetApi(value=9)
    public static <T> void put(String key, T value) {
        SharedPreferences.Editor ed = SharedPrefUtils._put(key, value);
        ed.apply();
    }

    public static <T> boolean commit(String key, T value) {
        return SharedPrefUtils._put(key, value).commit();
    }

    @SuppressLint(value={"CommitPrefEdits"})
    @TargetApi(value=11)
    private static <T> SharedPreferences.Editor _put(String key, T value) {
        if (key == null) {
            throw new NullPointerException("Null keys are not permitted");
        }
        SharedPreferences.Editor ed = SharedPrefUtils.getPrefs().edit();
        if (value == null) {
            ed.putString(key, null);
        } else if (value instanceof String) {
            ed.putString(key, (String)value);
        } else if (value instanceof Boolean) {
            ed.putBoolean(key, ((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            ed.putInt(key, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            ed.putLong(key, ((Long)value).longValue());
        } else if (value instanceof Float) {
            ed.putFloat(key, ((Float)value).floatValue());
        } else if (value instanceof Set) {
            SharedPreferences.Editor editor = ed.putStringSet(key, (Set)value);
        } else {
            throw new IllegalArgumentException("The given value : " + value + " cannot be persisted");
        }
        return ed;
    }

    @TargetApi(value=11)
    public static <T> T get(String key) {
        return SharedPrefUtils.get(key, null);
    }

    @TargetApi(value=11)
    public static <T> T get(String key, T defaultValue) {
        if (key == null) {
            throw new NullPointerException("Null keys are not permitted");
        }
        SharedPreferences preferences = SharedPrefUtils.getPrefs();
        if (defaultValue == null) {
            if (!preferences.contains(key)) {
                return null;
            }
            Object value = preferences.getAll().get(key);
            if (value == null) {
                return null;
            }
            Class<?> valueClass = value.getClass();
            for (Class<?> cls : CLASSES) {
                if (!valueClass.isAssignableFrom(cls)) continue;
                return (T)valueClass.cast(value);
            }
            throw new IllegalStateException("Unknown class for value :\n\t" + value + "\nstored in preferences");
        }
        if (defaultValue instanceof String) {
            return (T)preferences.getString(key, (String)defaultValue);
        }
        if (defaultValue instanceof Boolean) {
            return (T)Boolean.valueOf(preferences.getBoolean(key, ((Boolean)defaultValue).booleanValue()));
        }
        if (defaultValue instanceof Integer) {
            return (T)Integer.valueOf(preferences.getInt(key, ((Integer)defaultValue).intValue()));
        }
        if (defaultValue instanceof Long) {
            return (T)Long.valueOf(preferences.getLong(key, ((Long)defaultValue).longValue()));
        }
        if (defaultValue instanceof Float) {
            return (T)Float.valueOf(preferences.getFloat(key, ((Float)defaultValue).floatValue()));
        }
        if (defaultValue instanceof Set) {
            return (T)preferences.getStringSet(key, (Set)defaultValue);
        }
        throw new IllegalArgumentException(defaultValue + " cannot be persisted in SharedPreferences");
    }

    public static boolean contains(String key) {
        if (key == null) {
            throw new NullPointerException("Null keys are not permitted");
        }
        return SharedPrefUtils.getPrefs().contains(key);
    }

    public static Map<String, ?> getAll() {
        return Collections.unmodifiableMap(SharedPrefUtils.getPrefs().getAll());
    }

    public static boolean clear() {
        return SharedPrefUtils.getPrefs().edit().clear().commit();
    }

    public static boolean remove(String key) {
        if (key == null) {
            throw new NullPointerException("Null keys are not permitted");
        }
        return SharedPrefUtils.getPrefs().edit().remove(key).commit();
    }

    public static void registerListener(SharedPreferences.OnSharedPreferenceChangeListener lis) {
        if (lis == null) {
            throw new NullPointerException("Null listener");
        }
        SharedPrefUtils.getPrefs().registerOnSharedPreferenceChangeListener(lis);
    }

    public static void unregisterListener(SharedPreferences.OnSharedPreferenceChangeListener lis) {
        if (lis == null) {
            throw new NullPointerException("Null listener");
        }
        SharedPrefUtils.getPrefs().unregisterOnSharedPreferenceChangeListener(lis);
    }

    public static void callListener(SharedPreferences.OnSharedPreferenceChangeListener lis, String key) {
        if (lis == null) {
            throw new NullPointerException("Null listener");
        }
        if (key == null) {
            throw new NullPointerException("Null keys are not permitted");
        }
        lis.onSharedPreferenceChanged(SharedPrefUtils.getPrefs(), key);
    }

    private static Set<String> checkSetContainsStrings(Set<?> set) {
        if (!set.isEmpty()) {
            for (String string : set) {
                if (string instanceof String) continue;
                throw new IllegalArgumentException("The given set does not contain strings only");
            }
        }
        Set<String> stringSet = set;
        return stringSet;
    }

    public static <T> void setDataList(String tag, List<T> dataList) {
        if (null == dataList || dataList.size() <= 0) {
            return;
        }
        Gson gson = new Gson();
        String strJson = gson.toJson(dataList);
        SharedPrefUtils.put(tag, strJson);
    }

    public static <T> List<T> getDataList(String tag) {
        List dataList = new ArrayList();
        String strJson = prefs.getString(tag, null);
        if (null == strJson) {
            return dataList;
        }
        Gson gson = new Gson();
        dataList = (List)gson.fromJson(strJson, new TypeToken<List<T>>(){}.getType());
        return dataList;
    }

    static {
        CLASSES.add(String.class);
        CLASSES.add(Boolean.class);
        CLASSES.add(Integer.class);
        CLASSES.add(Long.class);
        CLASSES.add(Float.class);
        CLASSES.add(Set.class);
    }
}

