package com.ark.dict;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.support.annotation.Nullable;
import android.util.Log;

public final class Utils {

    @SuppressLint("StaticFieldLeak")
    private static Context sContext;

    private Utils() {
        throw new UnsupportedOperationException("u can't instantiate me...");
    }

    /**
     * 初始化工具类
     *
     * @param context context
     */
    static void init(@Nullable final Context context) {
        Utils.sContext = context;
    }

    /**
     * 获取 context
     *
     * @return context
     */
    @SuppressLint("PrivateApi")
    public static Context getContext() {
        if (sContext != null) {
            return sContext;
        }
        try {
            Application application = (Application) Class.forName("android.app.ActivityThread")
                    .getMethod("currentApplication").invoke(null, (Object[]) null);
            if (application != null) {
                return application;
            }
        } catch (Exception e) {
            Log.e("logger", "get currentApplication exception");
        }
        try {
            Application application = (Application) Class.forName("android.app.AppGlobals")
                    .getMethod("getInitialApplication").invoke(null, (Object[]) null);
            if (application != null) {
                return application;
            }
        } catch (Exception e) {
            Log.e("logger", "getInitialApplication exception");
        }
        throw new NullPointerException("u should init first");
    }
}


