/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.holiday;

import com.xkzhangsan.time.LunarDate;
import com.xkzhangsan.time.holiday.Holiday;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum ChineseHolidayEnum implements Holiday
{
    CHUNJIE("\u6625\u8282", "0101"),
    YUANXIAOJIE("\u5143\u5bb5\u8282", "0115"),
    LONGTAITOU("\u9f99\u62ac\u5934", "0202"),
    DUANWUJIE("\u7aef\u5348\u8282", "0505"),
    QIXIJIE("\u4e03\u5915\u8282", "0707"),
    ZHONGQIUJIE("\u4e2d\u79cb\u8282", "0815"),
    CHONGYANGJIE("\u91cd\u9633\u8282", "0909"),
    LABAJIE(" \u814a\u516b\u8282", "1208"),
    XIAONIANNORTH("\u5317\u65b9\u5c0f\u5e74", "1223"),
    XIAONIANSOUTH("\u5357\u65b9\u5c0f\u5e74", "1224"),
    CHUXI("\u9664\u5915", "CHUXI"),
    DEFAULT_HOLIDAY("", "");

    private final String name;
    private final String pattern;

    private ChineseHolidayEnum(String name, String pattern) {
        this.name = name;
        this.pattern = pattern;
    }

    public String getName() {
        return this.name;
    }

    public String getPattern() {
        return this.pattern;
    }

    @Deprecated
    public static ChineseHolidayEnum getHoliday(Temporal temporal) {
        Objects.requireNonNull(temporal, "temporal");
        LunarDate lunarDate = LunarDate.from(temporal);
        String monthDayStr = lunarDate.formatShort();
        for (ChineseHolidayEnum chineseHolidayEnum : ChineseHolidayEnum.values()) {
            if (chineseHolidayEnum.getPattern().equals(monthDayStr)) {
                return chineseHolidayEnum;
            }
            if (!chineseHolidayEnum.getPattern().equals(CHUXI.getPattern())) continue;
            LocalDate tempLocalDate = lunarDate.getLocalDate();
            LocalDate targetLocalDate = tempLocalDate.plus(1L, ChronoUnit.DAYS);
            LunarDate targetLunarDate = LunarDate.from(targetLocalDate);
            String targetMonthDayStr = targetLunarDate.formatShort();
            if (!CHUNJIE.getPattern().equals(targetMonthDayStr)) continue;
            return CHUXI;
        }
        return DEFAULT_HOLIDAY;
    }

    public static String getHolidayName(Temporal temporal) {
        return Holiday.getChineseHoliday(temporal, ChineseHolidayEnum.convertToMap());
    }

    public static boolean compareLunarMonthDay(Temporal temporal, String monthDay) {
        Objects.requireNonNull(temporal, "temporal");
        Objects.requireNonNull(monthDay, "monthDay");
        LunarDate lunarDate = LunarDate.from(temporal);
        String monthDayStr = lunarDate.formatShort();
        return monthDayStr.equals(monthDay);
    }

    public static Map<String, String> convertToMap() {
        HashMap<String, String> chineseHolidayMap = new HashMap<String, String>();
        for (ChineseHolidayEnum chineseHolidayEnum : ChineseHolidayEnum.values()) {
            chineseHolidayMap.put(chineseHolidayEnum.getPattern(), chineseHolidayEnum.getName());
        }
        return chineseHolidayMap;
    }
}

