/*
 * Decompiled with CFR 0.152.
 */
package com.xkzhangsan.time.cost;

import com.xkzhangsan.time.cost.Cost;
import java.math.BigDecimal;
import java.util.concurrent.TimeUnit;

public final class MillisecondCost
implements Cost {
    private final String name;
    private final long nanosecond;

    public MillisecondCost() {
        this.name = "";
        this.nanosecond = System.nanoTime();
    }

    public MillisecondCost(String name) {
        this.name = name;
        this.nanosecond = System.nanoTime();
    }

    @Override
    public long stop() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.nanosecond);
    }

    @Override
    public void stopAndPrint() {
        System.out.println(this.stopAndFormat());
    }

    @Override
    public String stopAndFormat() {
        return this.name + " cost: " + this.stop() + " ms";
    }

    @Override
    public String stopAccurate() {
        double result = (double)(System.nanoTime() - this.nanosecond) / 1000000.0;
        return new BigDecimal(result).setScale(3, 1).toString();
    }

    @Override
    public void stopAccurateAndPrint() {
        System.out.println(this.stopAccurateAndFormat());
    }

    @Override
    public String stopAccurateAndFormat() {
        return this.name + " cost: " + this.stopAccurate() + " ms";
    }
}

