/*
 * Decompiled with CFR 0.152.
 */
package pub.devrel.easypermissions;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import android.support.annotation.RestrictTo;
import android.support.annotation.StringRes;
import android.support.annotation.StyleRes;
import android.support.v7.app.AlertDialog;
import android.text.TextUtils;
import pub.devrel.easypermissions.AppSettingsDialogHolderActivity;
import pub.devrel.easypermissions.R;

public class AppSettingsDialog
implements Parcelable,
DialogInterface.OnClickListener {
    public static final int DEFAULT_SETTINGS_REQ_CODE = 16061;
    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public static final Parcelable.Creator<AppSettingsDialog> CREATOR = new Parcelable.Creator<AppSettingsDialog>(){

        public AppSettingsDialog createFromParcel(Parcel in) {
            return new AppSettingsDialog(in);
        }

        public AppSettingsDialog[] newArray(int size) {
            return new AppSettingsDialog[size];
        }
    };
    static final String EXTRA_APP_SETTINGS = "extra_app_settings";
    @StyleRes
    private final int mThemeResId;
    private final String mRationale;
    private final String mTitle;
    private final String mPositiveButtonText;
    private final String mNegativeButtonText;
    private final int mRequestCode;
    private Context mContext;
    private Object mActivityOrFragment;
    private DialogInterface.OnClickListener mNegativeListener;

    private AppSettingsDialog(Parcel in) {
        this.mThemeResId = in.readInt();
        this.mRationale = in.readString();
        this.mTitle = in.readString();
        this.mPositiveButtonText = in.readString();
        this.mNegativeButtonText = in.readString();
        this.mRequestCode = in.readInt();
    }

    private AppSettingsDialog(@NonNull Object activityOrFragment, @NonNull Context context, @StyleRes int themeResId, @Nullable String rationale, @Nullable String title, @Nullable String positiveButtonText, @Nullable String negativeButtonText, @Nullable DialogInterface.OnClickListener negativeListener, int requestCode) {
        this.mActivityOrFragment = activityOrFragment;
        this.mContext = context;
        this.mThemeResId = themeResId;
        this.mRationale = rationale;
        this.mTitle = title;
        this.mPositiveButtonText = positiveButtonText;
        this.mNegativeButtonText = negativeButtonText;
        this.mNegativeListener = negativeListener;
        this.mRequestCode = requestCode;
    }

    void setActivityOrFragment(Object activityOrFragment) {
        this.mActivityOrFragment = activityOrFragment;
    }

    void setContext(Context context) {
        this.mContext = context;
    }

    void setNegativeListener(DialogInterface.OnClickListener negativeListener) {
        this.mNegativeListener = negativeListener;
    }

    @RequiresApi(api=11)
    private void startForResult(Intent intent) {
        if (this.mActivityOrFragment instanceof Activity) {
            ((Activity)this.mActivityOrFragment).startActivityForResult(intent, this.mRequestCode);
        } else if (this.mActivityOrFragment instanceof android.support.v4.app.Fragment) {
            ((android.support.v4.app.Fragment)this.mActivityOrFragment).startActivityForResult(intent, this.mRequestCode);
        } else if (this.mActivityOrFragment instanceof Fragment) {
            ((Fragment)this.mActivityOrFragment).startActivityForResult(intent, this.mRequestCode);
        }
    }

    public void show() {
        if (this.mNegativeListener == null) {
            this.startForResult(AppSettingsDialogHolderActivity.createShowDialogIntent(this.mContext, this));
        } else {
            this.showDialog();
        }
    }

    AlertDialog showDialog() {
        AlertDialog.Builder builder = this.mThemeResId > 0 ? new AlertDialog.Builder(this.mContext, this.mThemeResId) : new AlertDialog.Builder(this.mContext);
        return builder.setCancelable(false).setTitle((CharSequence)this.mTitle).setMessage((CharSequence)this.mRationale).setPositiveButton((CharSequence)this.mPositiveButtonText, (DialogInterface.OnClickListener)this).setNegativeButton((CharSequence)this.mNegativeButtonText, this.mNegativeListener).show();
    }

    public void onClick(DialogInterface dialog, int which) {
        Intent intent = new Intent("android.settings.APPLICATION_DETAILS_SETTINGS");
        Uri uri = Uri.fromParts((String)"package", (String)this.mContext.getPackageName(), null);
        intent.setData(uri);
        this.startForResult(intent);
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeInt(this.mThemeResId);
        dest.writeString(this.mRationale);
        dest.writeString(this.mTitle);
        dest.writeString(this.mPositiveButtonText);
        dest.writeString(this.mNegativeButtonText);
        dest.writeInt(this.mRequestCode);
    }

    public static class Builder {
        private Object mActivityOrFragment;
        private Context mContext;
        @StyleRes
        private int mThemeResId = -1;
        private String mRationale;
        private String mTitle;
        private String mPositiveButton;
        private String mNegativeButton;
        private DialogInterface.OnClickListener mNegativeListener;
        private int mRequestCode = -1;

        @Deprecated
        public Builder(@NonNull Activity activity, @NonNull String rationale) {
            this.mActivityOrFragment = activity;
            this.mContext = activity;
            this.mRationale = rationale;
        }

        @Deprecated
        public Builder(@NonNull android.support.v4.app.Fragment fragment, @NonNull String rationale) {
            this.mActivityOrFragment = fragment;
            this.mContext = fragment.getContext();
            this.mRationale = rationale;
        }

        @Deprecated
        @RequiresApi(api=11)
        public Builder(@NonNull Fragment fragment, @NonNull String rationale) {
            this.mActivityOrFragment = fragment;
            this.mContext = fragment.getActivity();
            this.mRationale = rationale;
        }

        public Builder(@NonNull Activity activity) {
            this.mActivityOrFragment = activity;
            this.mContext = activity;
        }

        public Builder(@NonNull android.support.v4.app.Fragment fragment) {
            this.mActivityOrFragment = fragment;
            this.mContext = fragment.getContext();
        }

        @RequiresApi(api=11)
        public Builder(@NonNull Fragment fragment) {
            this.mActivityOrFragment = fragment;
            this.mContext = fragment.getActivity();
        }

        public Builder setThemeResId(@StyleRes int themeResId) {
            this.mThemeResId = themeResId;
            return this;
        }

        public Builder setTitle(String title) {
            this.mTitle = title;
            return this;
        }

        public Builder setTitle(@StringRes int title) {
            this.mTitle = this.mContext.getString(title);
            return this;
        }

        public Builder setRationale(String rationale) {
            this.mRationale = rationale;
            return this;
        }

        public Builder setRationale(@StringRes int rationale) {
            this.mRationale = this.mContext.getString(rationale);
            return this;
        }

        public Builder setPositiveButton(String positiveButton) {
            this.mPositiveButton = positiveButton;
            return this;
        }

        public Builder setPositiveButton(@StringRes int positiveButton) {
            this.mPositiveButton = this.mContext.getString(positiveButton);
            return this;
        }

        @Deprecated
        public Builder setNegativeButton(String negativeButton, DialogInterface.OnClickListener negativeListener) {
            this.mNegativeButton = negativeButton;
            this.mNegativeListener = negativeListener;
            return this;
        }

        public Builder setNegativeButton(String negativeButton) {
            this.mNegativeButton = negativeButton;
            return this;
        }

        public Builder setNegativeButton(@StringRes int negativeButton) {
            this.mNegativeButton = this.mContext.getString(negativeButton);
            return this;
        }

        public Builder setRequestCode(int requestCode) {
            this.mRequestCode = requestCode;
            return this;
        }

        public AppSettingsDialog build() {
            this.mRationale = TextUtils.isEmpty((CharSequence)this.mRationale) ? this.mContext.getString(R.string.rationale_ask_again) : this.mRationale;
            this.mTitle = TextUtils.isEmpty((CharSequence)this.mTitle) ? this.mContext.getString(R.string.title_settings_dialog) : this.mTitle;
            this.mPositiveButton = TextUtils.isEmpty((CharSequence)this.mPositiveButton) ? this.mContext.getString(17039370) : this.mPositiveButton;
            this.mNegativeButton = TextUtils.isEmpty((CharSequence)this.mNegativeButton) ? this.mContext.getString(0x1040000) : this.mNegativeButton;
            this.mRequestCode = this.mRequestCode > 0 ? this.mRequestCode : 16061;
            return new AppSettingsDialog(this.mActivityOrFragment, this.mContext, this.mThemeResId, this.mRationale, this.mTitle, this.mPositiveButton, this.mNegativeButton, this.mNegativeListener, this.mRequestCode);
        }
    }
}

