/*
 * Decompiled with CFR 0.152.
 */
package com.bilibili.boxing_impl.view;

import android.content.Context;
import android.support.annotation.DrawableRes;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.bilibili.boxing.BoxingMediaLoader;
import com.bilibili.boxing.model.BoxingManager;
import com.bilibili.boxing.model.entity.BaseMedia;
import com.bilibili.boxing.model.entity.impl.ImageMedia;
import com.bilibili.boxing.model.entity.impl.VideoMedia;
import com.bilibili.boxing_impl.BoxingResHelper;
import com.bilibili.boxing_impl.R;
import com.bilibili.boxing_impl.WindowManagerHelper;

public class MediaItemLayout
extends FrameLayout {
    private static final int BIG_IMG_SIZE = 0x500000;
    private ImageView mCheckImg;
    private View mVideoLayout;
    private View mFontLayout;
    private ImageView mCoverImg;
    private ScreenType mScreenType;

    public MediaItemLayout(Context context) {
        this(context, null, 0);
    }

    public MediaItemLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public MediaItemLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        View view = LayoutInflater.from((Context)context).inflate(R.layout.layout_boxing_media_item, (ViewGroup)this, true);
        this.mCoverImg = (ImageView)view.findViewById(R.id.media_item);
        this.mCheckImg = (ImageView)view.findViewById(R.id.media_item_check);
        this.mVideoLayout = view.findViewById(R.id.video_layout);
        this.mFontLayout = view.findViewById(R.id.media_font_layout);
        this.mScreenType = this.getScreenType(context);
        this.setImageRect(context);
    }

    private void setImageRect(Context context) {
        int screenHeight = WindowManagerHelper.getScreenHeight(context);
        int screenWidth = WindowManagerHelper.getScreenWidth(context);
        int width = 100;
        if (screenHeight != 0 && screenWidth != 0) {
            width = (screenWidth - this.getResources().getDimensionPixelOffset(R.dimen.boxing_media_margin) * 4) / 3;
        }
        this.mCoverImg.getLayoutParams().width = width;
        this.mCoverImg.getLayoutParams().height = width;
        this.mFontLayout.getLayoutParams().width = width;
        this.mFontLayout.getLayoutParams().height = width;
    }

    private ScreenType getScreenType(Context context) {
        ScreenType result;
        int type = context.getResources().getConfiguration().screenLayout & 0xF;
        switch (type) {
            case 1: {
                result = ScreenType.SMALL;
                break;
            }
            case 2: {
                result = ScreenType.NORMAL;
                break;
            }
            case 3: {
                result = ScreenType.LARGE;
                break;
            }
            default: {
                result = ScreenType.NORMAL;
            }
        }
        return result;
    }

    public void setImageRes(@DrawableRes int imageRes) {
        if (this.mCoverImg != null) {
            this.mCoverImg.setImageResource(imageRes);
        }
    }

    public void setMedia(BaseMedia media) {
        if (media instanceof ImageMedia) {
            this.mVideoLayout.setVisibility(8);
            this.setCover(((ImageMedia)media).getThumbnailPath());
        } else if (media instanceof VideoMedia) {
            this.mVideoLayout.setVisibility(0);
            VideoMedia videoMedia = (VideoMedia)media;
            TextView durationTxt = (TextView)this.mVideoLayout.findViewById(R.id.video_duration_txt);
            durationTxt.setText((CharSequence)videoMedia.getDuration());
            durationTxt.setCompoundDrawablesWithIntrinsicBounds(BoxingManager.getInstance().getBoxingConfig().getVideoDurationRes(), 0, 0, 0);
            ((TextView)this.mVideoLayout.findViewById(R.id.video_size_txt)).setText((CharSequence)videoMedia.getSizeByUnit());
            this.setCover(videoMedia.getPath());
        }
    }

    private void setCover(@NonNull String path) {
        if (this.mCoverImg == null || TextUtils.isEmpty((CharSequence)path)) {
            return;
        }
        this.mCoverImg.setTag(R.string.boxing_app_name, (Object)path);
        BoxingMediaLoader.getInstance().displayThumbnail(this.mCoverImg, path, this.mScreenType.getValue(), this.mScreenType.getValue());
    }

    public void setChecked(boolean isChecked) {
        if (isChecked) {
            this.mFontLayout.setVisibility(0);
            this.mCheckImg.setImageDrawable(this.getResources().getDrawable(BoxingResHelper.getMediaCheckedRes()));
        } else {
            this.mFontLayout.setVisibility(8);
            this.mCheckImg.setImageDrawable(this.getResources().getDrawable(BoxingResHelper.getMediaUncheckedRes()));
        }
    }

    private static enum ScreenType {
        SMALL(100),
        NORMAL(180),
        LARGE(320);

        int value;

        private ScreenType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

