/*
 * Decompiled with CFR 0.152.
 */
package com.bilibili.boxing_impl.ui;

import android.graphics.Point;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.FragmentActivity;
import android.util.DisplayMetrics;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import com.bilibili.boxing.AbsBoxingViewActivity;
import com.bilibili.boxing.loader.IBoxingCallback;
import com.bilibili.boxing.model.entity.impl.ImageMedia;
import com.bilibili.boxing.utils.BoxingLog;
import com.bilibili.boxing_impl.R;
import com.bilibili.boxing_impl.ui.BoxingBaseFragment;
import com.bilibili.boxing_impl.ui.BoxingViewActivity;
import java.lang.ref.WeakReference;
import uk.co.senab.photoview.PhotoView;
import uk.co.senab.photoview.PhotoViewAttacher;

public class BoxingRawImageFragment
extends BoxingBaseFragment {
    private static final String BUNDLE_IMAGE = "com.bilibili.boxing_impl.ui.BoxingRawImageFragment.image";
    private static final int MAX_SCALE = 15;
    private static final long MAX_IMAGE1 = 0x100000L;
    private static final long MAX_IMAGE2 = 0x400000L;
    private PhotoView mImageView;
    private ProgressBar mProgress;
    private ImageMedia mMedia;
    private PhotoViewAttacher mAttacher;

    public static BoxingRawImageFragment newInstance(@NonNull ImageMedia image) {
        BoxingRawImageFragment fragment = new BoxingRawImageFragment();
        Bundle args = new Bundle();
        args.putParcelable(BUNDLE_IMAGE, (Parcelable)image);
        fragment.setArguments(args);
        return fragment;
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.mMedia = (ImageMedia)this.getArguments().getParcelable(BUNDLE_IMAGE);
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_boxing_raw_image, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mProgress = (ProgressBar)view.findViewById(R.id.loading);
        this.mImageView = (PhotoView)view.findViewById(R.id.photo_view);
        this.mAttacher = new PhotoViewAttacher((ImageView)this.mImageView);
        this.mAttacher.setRotatable(true);
        this.mAttacher.setToRightAngle(true);
    }

    @Override
    void setUserVisibleCompat(boolean isVisibleToUser) {
        if (isVisibleToUser) {
            Point point = this.getResizePointer(this.mMedia.getSize());
            ((AbsBoxingViewActivity)this.getActivity()).loadRawImage((ImageView)this.mImageView, this.mMedia.getPath(), point.x, point.y, (IBoxingCallback)new BoxingCallback(this));
        }
    }

    private Point getResizePointer(long size) {
        DisplayMetrics metrics = this.getResources().getDisplayMetrics();
        Point point = new Point(metrics.widthPixels, metrics.heightPixels);
        if (size >= 0x400000L) {
            point.x >>= 2;
            point.y >>= 2;
        } else if (size >= 0x100000L) {
            point.x >>= 1;
            point.y >>= 1;
        } else if (size > 0L) {
            point.x = 0;
            point.y = 0;
        }
        return point;
    }

    private void dismissProgressDialog() {
        BoxingViewActivity activity;
        if (this.mProgress != null) {
            this.mProgress.setVisibility(8);
        }
        if ((activity = this.getThisActivity()) != null && activity.mProgressBar != null) {
            activity.mProgressBar.setVisibility(8);
        }
    }

    private BoxingViewActivity getThisActivity() {
        FragmentActivity activity = this.getActivity();
        if (activity instanceof BoxingViewActivity) {
            return (BoxingViewActivity)activity;
        }
        return null;
    }

    public void onDestroyView() {
        super.onDestroyView();
        if (this.mAttacher != null) {
            this.mAttacher.cleanup();
            this.mAttacher = null;
            this.mImageView = null;
        }
    }

    private static class BoxingCallback
    implements IBoxingCallback {
        private WeakReference<BoxingRawImageFragment> mWr;

        BoxingCallback(BoxingRawImageFragment fragment) {
            this.mWr = new WeakReference<BoxingRawImageFragment>(fragment);
        }

        public void onSuccess() {
            BoxingViewActivity activity;
            if (this.mWr.get() == null || ((BoxingRawImageFragment)((Object)this.mWr.get())).mImageView == null) {
                return;
            }
            ((BoxingRawImageFragment)((Object)this.mWr.get())).dismissProgressDialog();
            Drawable drawable2 = ((BoxingRawImageFragment)((Object)this.mWr.get())).mImageView.getDrawable();
            PhotoViewAttacher attacher = ((BoxingRawImageFragment)((Object)this.mWr.get())).mAttacher;
            if (attacher != null) {
                if (drawable2.getIntrinsicHeight() > drawable2.getIntrinsicWidth() << 2) {
                    int scale = drawable2.getIntrinsicHeight() / drawable2.getIntrinsicWidth();
                    scale = Math.min(15, scale);
                    attacher.setMaximumScale((float)scale);
                    attacher.setScale((float)scale, true);
                }
                attacher.update();
            }
            if ((activity = ((BoxingRawImageFragment)((Object)this.mWr.get())).getThisActivity()) != null && activity.mGallery != null) {
                activity.mGallery.setVisibility(0);
            }
        }

        public void onFail(Throwable t) {
            if (this.mWr.get() == null) {
                return;
            }
            BoxingLog.d((String)(t != null ? t.getMessage() : "load raw image error."));
            ((BoxingRawImageFragment)((Object)this.mWr.get())).dismissProgressDialog();
            ((BoxingRawImageFragment)((Object)this.mWr.get())).mImageView.setImageResource(R.drawable.ic_boxing_broken_image);
            if (((BoxingRawImageFragment)((Object)this.mWr.get())).mAttacher != null) {
                ((BoxingRawImageFragment)((Object)this.mWr.get())).mAttacher.update();
            }
        }
    }
}

