/*
 * Decompiled with CFR 0.152.
 */
package com.bilibili.boxing_impl.ui;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.content.ContextCompat;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.PopupWindow;
import android.widget.ProgressBar;
import android.widget.TextView;
import android.widget.Toast;
import com.bilibili.boxing.AbsBoxingViewFragment;
import com.bilibili.boxing.Boxing;
import com.bilibili.boxing.model.BoxingManager;
import com.bilibili.boxing.model.config.BoxingConfig;
import com.bilibili.boxing.model.entity.AlbumEntity;
import com.bilibili.boxing.model.entity.BaseMedia;
import com.bilibili.boxing.model.entity.impl.ImageMedia;
import com.bilibili.boxing_impl.R;
import com.bilibili.boxing_impl.WindowManagerHelper;
import com.bilibili.boxing_impl.adapter.BoxingAlbumAdapter;
import com.bilibili.boxing_impl.adapter.BoxingMediaAdapter;
import com.bilibili.boxing_impl.ui.BoxingViewActivity;
import com.bilibili.boxing_impl.view.HackyGridLayoutManager;
import com.bilibili.boxing_impl.view.MediaItemLayout;
import com.bilibili.boxing_impl.view.SpacesItemDecoration;
import java.util.ArrayList;
import java.util.List;

public class BoxingViewFragment
extends AbsBoxingViewFragment
implements View.OnClickListener {
    public static final String TAG = "com.bilibili.boxing_impl.ui.BoxingViewFragment";
    private static final int IMAGE_PREVIEW_REQUEST_CODE = 9086;
    private static final int IMAGE_CROP_REQUEST_CODE = 9087;
    private static final int GRID_COUNT = 3;
    private boolean mIsPreview;
    private boolean mIsCamera;
    private Button mPreBtn;
    private Button mOkBtn;
    private RecyclerView mRecycleView;
    private BoxingMediaAdapter mMediaAdapter;
    private BoxingAlbumAdapter mAlbumWindowAdapter;
    private ProgressDialog mDialog;
    private TextView mEmptyTxt;
    private TextView mTitleTxt;
    private PopupWindow mAlbumPopWindow;
    private ProgressBar mLoadingView;
    private int mMaxCount;

    public static BoxingViewFragment newInstance() {
        return new BoxingViewFragment();
    }

    public void onCreateWithSelectedMedias(Bundle savedInstanceState, @Nullable List<BaseMedia> selectedMedias) {
        this.mAlbumWindowAdapter = new BoxingAlbumAdapter(this.getContext());
        this.mMediaAdapter = new BoxingMediaAdapter(this.getContext());
        this.mMediaAdapter.setSelectedMedias(selectedMedias);
        this.mMaxCount = this.getMaxCount();
    }

    public void startLoading() {
        this.loadMedias();
        this.loadAlbum();
    }

    public void onRequestPermissionError(String[] permissions, Exception e) {
        if (permissions.length > 0) {
            if (permissions[0].equals("android.permission.WRITE_EXTERNAL_STORAGE")) {
                Toast.makeText((Context)this.getContext(), (int)R.string.boxing_storage_permission_deny, (int)0).show();
                this.showEmptyData();
            } else if (permissions[0].equals("android.permission.CAMERA")) {
                Toast.makeText((Context)this.getContext(), (int)R.string.boxing_camera_permission_deny, (int)0).show();
            }
        }
    }

    public void onRequestPermissionSuc(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        if (permissions[0].equals(STORAGE_PERMISSIONS[0])) {
            this.startLoading();
        } else if (permissions[0].equals(CAMERA_PERMISSIONS[0])) {
            this.startCamera((Activity)this.getActivity(), (Fragment)this, null);
        }
    }

    @Nullable
    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragmant_boxing_view, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        this.initViews(view);
        super.onViewCreated(view, savedInstanceState);
    }

    private void initViews(View view) {
        this.mEmptyTxt = (TextView)view.findViewById(R.id.empty_txt);
        this.mRecycleView = (RecyclerView)view.findViewById(R.id.media_recycleview);
        this.mRecycleView.setHasFixedSize(true);
        this.mLoadingView = (ProgressBar)view.findViewById(R.id.loading);
        this.initRecycleView();
        boolean isMultiImageMode = BoxingManager.getInstance().getBoxingConfig().isMultiImageMode();
        View multiImageLayout = view.findViewById(R.id.multi_picker_layout);
        multiImageLayout.setVisibility(isMultiImageMode ? 0 : 8);
        if (isMultiImageMode) {
            this.mPreBtn = (Button)view.findViewById(R.id.choose_preview_btn);
            this.mOkBtn = (Button)view.findViewById(R.id.choose_ok_btn);
            this.mPreBtn.setOnClickListener((View.OnClickListener)this);
            this.mOkBtn.setOnClickListener((View.OnClickListener)this);
            this.updateMultiPickerLayoutState(this.mMediaAdapter.getSelectedMedias());
        }
    }

    private void initRecycleView() {
        HackyGridLayoutManager gridLayoutManager = new HackyGridLayoutManager((Context)this.getActivity(), 3);
        gridLayoutManager.setSmoothScrollbarEnabled(true);
        this.mRecycleView.setLayoutManager((RecyclerView.LayoutManager)gridLayoutManager);
        this.mRecycleView.addItemDecoration((RecyclerView.ItemDecoration)new SpacesItemDecoration(this.getResources().getDimensionPixelOffset(R.dimen.boxing_media_margin), 3));
        this.mMediaAdapter.setOnCameraClickListener(new OnCameraClickListener());
        this.mMediaAdapter.setOnCheckedListener(new OnMediaCheckedListener());
        this.mMediaAdapter.setOnMediaClickListener(new OnMediaClickListener());
        this.mRecycleView.setAdapter((RecyclerView.Adapter)this.mMediaAdapter);
        this.mRecycleView.addOnScrollListener((RecyclerView.OnScrollListener)new ScrollListener());
    }

    public void showMedia(@Nullable List<BaseMedia> medias, int allCount) {
        if (medias == null || this.isEmptyData(medias) && this.isEmptyData(this.mMediaAdapter.getAllMedias())) {
            this.showEmptyData();
            return;
        }
        this.showData();
        this.mMediaAdapter.addAllData(medias);
        this.checkSelectedMedia(medias, this.mMediaAdapter.getSelectedMedias());
    }

    private boolean isEmptyData(List<BaseMedia> medias) {
        return medias.isEmpty() && !BoxingManager.getInstance().getBoxingConfig().isNeedCamera();
    }

    private void showEmptyData() {
        this.mLoadingView.setVisibility(8);
        this.mEmptyTxt.setVisibility(0);
        this.mRecycleView.setVisibility(8);
    }

    private void showData() {
        this.mLoadingView.setVisibility(8);
        this.mEmptyTxt.setVisibility(8);
        this.mRecycleView.setVisibility(0);
    }

    public void showAlbum(@Nullable List<AlbumEntity> albums) {
        if ((albums == null || albums.isEmpty()) && this.mTitleTxt != null) {
            this.mTitleTxt.setCompoundDrawables(null, null, null, null);
            this.mTitleTxt.setOnClickListener(null);
            return;
        }
        this.mAlbumWindowAdapter.addAllData(albums);
    }

    public BoxingMediaAdapter getMediaAdapter() {
        return this.mMediaAdapter;
    }

    public void clearMedia() {
        this.mMediaAdapter.clearData();
    }

    private void updateMultiPickerLayoutState(List<BaseMedia> medias) {
        this.updateOkBtnState(medias);
        this.updatePreviewBtnState(medias);
    }

    private void updatePreviewBtnState(List<BaseMedia> medias) {
        if (this.mPreBtn == null || medias == null) {
            return;
        }
        boolean enabled = medias.size() > 0 && medias.size() <= this.mMaxCount;
        this.mPreBtn.setEnabled(enabled);
    }

    private void updateOkBtnState(List<BaseMedia> medias) {
        if (this.mOkBtn == null || medias == null) {
            return;
        }
        boolean enabled = medias.size() > 0 && medias.size() <= this.mMaxCount;
        this.mOkBtn.setEnabled(enabled);
        this.mOkBtn.setText((CharSequence)(enabled ? this.getString(R.string.boxing_image_select_ok_fmt, new Object[]{String.valueOf(medias.size()), String.valueOf(this.mMaxCount)}) : this.getString(R.string.boxing_ok)));
    }

    public void onCameraFinish(BaseMedia media) {
        this.dismissProgressDialog();
        this.mIsCamera = false;
        if (media == null) {
            return;
        }
        if (this.hasCropBehavior()) {
            this.startCrop(media, 9087);
        } else if (this.mMediaAdapter != null && this.mMediaAdapter.getSelectedMedias() != null) {
            List<BaseMedia> selectedMedias = this.mMediaAdapter.getSelectedMedias();
            selectedMedias.add(media);
            this.onFinish(selectedMedias);
        }
    }

    public void onCameraError() {
        this.mIsCamera = false;
        this.dismissProgressDialog();
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.choose_ok_btn) {
            this.onFinish(this.mMediaAdapter.getSelectedMedias());
        } else if (id2 == R.id.choose_preview_btn && !this.mIsPreview) {
            this.mIsPreview = true;
            ArrayList medias = (ArrayList)this.mMediaAdapter.getSelectedMedias();
            Boxing.get().withIntent((Context)this.getActivity(), BoxingViewActivity.class, medias).start((Fragment)this, 9086, BoxingConfig.ViewMode.PRE_EDIT);
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (data == null) {
            return;
        }
        if (resultCode == -1 && requestCode == 9086) {
            this.mIsPreview = false;
            boolean isBackClick = data.getBooleanExtra("com.bilibili.boxing_impl.ui.BoxingViewActivity.type_back", false);
            ArrayList selectedMedias = data.getParcelableArrayListExtra("com.bilibili.boxing.Boxing.selected_media");
            this.onViewActivityRequest(selectedMedias, this.mMediaAdapter.getAllMedias(), isBackClick);
            if (isBackClick) {
                this.mMediaAdapter.setSelectedMedias(selectedMedias);
            }
            this.updateMultiPickerLayoutState(selectedMedias);
        }
    }

    private void onViewActivityRequest(List<BaseMedia> selectedMedias, List<BaseMedia> allMedias, boolean isBackClick) {
        if (isBackClick) {
            this.checkSelectedMedia(allMedias, selectedMedias);
        } else {
            this.onFinish(selectedMedias);
        }
    }

    public void onCameraActivityResult(int requestCode, int resultCode) {
        this.showProgressDialog();
        super.onCameraActivityResult(requestCode, resultCode);
    }

    private void showProgressDialog() {
        if (this.mDialog == null) {
            this.mDialog = new ProgressDialog((Context)this.getActivity());
            this.mDialog.setIndeterminate(true);
            this.mDialog.setMessage((CharSequence)this.getString(R.string.boxing_handling));
        }
        if (!this.mDialog.isShowing()) {
            this.mDialog.show();
        }
    }

    private void dismissProgressDialog() {
        if (this.mDialog != null && this.mDialog.isShowing()) {
            this.mDialog.hide();
            this.mDialog.dismiss();
        }
    }

    public void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        ArrayList medias = (ArrayList)this.getMediaAdapter().getSelectedMedias();
        this.onSaveMedias(outState, medias);
    }

    public void setTitleTxt(TextView titleTxt) {
        this.mTitleTxt = titleTxt;
        this.mTitleTxt.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (BoxingViewFragment.this.mAlbumPopWindow == null) {
                    int height = WindowManagerHelper.getScreenHeight(v.getContext()) - (WindowManagerHelper.getToolbarHeight(v.getContext()) + WindowManagerHelper.getStatusBarHeight(v.getContext()));
                    View windowView = this.createWindowView();
                    BoxingViewFragment.this.mAlbumPopWindow = new PopupWindow(windowView, -1, height, true);
                    BoxingViewFragment.this.mAlbumPopWindow.setAnimationStyle(R.style.Boxing_PopupAnimation);
                    BoxingViewFragment.this.mAlbumPopWindow.setOutsideTouchable(true);
                    BoxingViewFragment.this.mAlbumPopWindow.setBackgroundDrawable((Drawable)new ColorDrawable(ContextCompat.getColor((Context)v.getContext(), (int)R.color.boxing_colorPrimaryAlpha)));
                    BoxingViewFragment.this.mAlbumPopWindow.setContentView(windowView);
                }
                BoxingViewFragment.this.mAlbumPopWindow.showAsDropDown(v, 0, 0);
            }

            @NonNull
            private View createWindowView() {
                View view = LayoutInflater.from((Context)BoxingViewFragment.this.getActivity()).inflate(R.layout.layout_boxing_album, null);
                RecyclerView recyclerView = (RecyclerView)view.findViewById(R.id.album_recycleview);
                recyclerView.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(view.getContext(), 1, false));
                recyclerView.addItemDecoration((RecyclerView.ItemDecoration)new SpacesItemDecoration(2, 1));
                View albumShadowLayout = view.findViewById(R.id.album_shadow);
                albumShadowLayout.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        BoxingViewFragment.this.dismissAlbumWindow();
                    }
                });
                BoxingViewFragment.this.mAlbumWindowAdapter.setAlbumOnClickListener(new OnAlbumItemOnClickListener());
                recyclerView.setAdapter((RecyclerView.Adapter)BoxingViewFragment.this.mAlbumWindowAdapter);
                return view;
            }
        });
    }

    private void dismissAlbumWindow() {
        if (this.mAlbumPopWindow != null && this.mAlbumPopWindow.isShowing()) {
            this.mAlbumPopWindow.dismiss();
        }
    }

    private class OnAlbumItemOnClickListener
    implements BoxingAlbumAdapter.OnAlbumClickListener {
        private OnAlbumItemOnClickListener() {
        }

        @Override
        public void onClick(View view, int pos) {
            BoxingAlbumAdapter adapter = BoxingViewFragment.this.mAlbumWindowAdapter;
            if (adapter != null && adapter.getCurrentAlbumPos() != pos) {
                List<AlbumEntity> albums = adapter.getAlums();
                adapter.setCurrentAlbumPos(pos);
                AlbumEntity albumMedia = albums.get(pos);
                BoxingViewFragment.this.loadMedias(0, albumMedia.mBucketId);
                BoxingViewFragment.this.mTitleTxt.setText((CharSequence)(albumMedia.mBucketName == null ? BoxingViewFragment.this.getString(R.string.boxing_default_album_name) : albumMedia.mBucketName));
                for (AlbumEntity album : albums) {
                    album.mIsSelected = false;
                }
                albumMedia.mIsSelected = true;
                adapter.notifyDataSetChanged();
            }
            BoxingViewFragment.this.dismissAlbumWindow();
        }
    }

    private class OnMediaCheckedListener
    implements BoxingMediaAdapter.OnMediaCheckedListener {
        private OnMediaCheckedListener() {
        }

        @Override
        public void onChecked(View view, BaseMedia iMedia) {
            if (!(iMedia instanceof ImageMedia)) {
                return;
            }
            ImageMedia photoMedia = (ImageMedia)iMedia;
            boolean isSelected = !photoMedia.isSelected();
            MediaItemLayout layout2 = (MediaItemLayout)view;
            List<BaseMedia> selectedMedias = BoxingViewFragment.this.mMediaAdapter.getSelectedMedias();
            if (isSelected) {
                if (selectedMedias.size() >= BoxingViewFragment.this.mMaxCount) {
                    String warning = BoxingViewFragment.this.getString(R.string.boxing_too_many_picture_fmt, new Object[]{BoxingViewFragment.this.mMaxCount});
                    Toast.makeText((Context)BoxingViewFragment.this.getActivity(), (CharSequence)warning, (int)0).show();
                    return;
                }
                if (!selectedMedias.contains(photoMedia)) {
                    if (photoMedia.isGifOverSize()) {
                        Toast.makeText((Context)BoxingViewFragment.this.getActivity(), (int)R.string.boxing_gif_too_big, (int)0).show();
                        return;
                    }
                    selectedMedias.add((BaseMedia)photoMedia);
                }
            } else if (selectedMedias.size() >= 1 && selectedMedias.contains(photoMedia)) {
                selectedMedias.remove(photoMedia);
            }
            photoMedia.setSelected(isSelected);
            layout2.setChecked(isSelected);
            BoxingViewFragment.this.updateMultiPickerLayoutState(selectedMedias);
        }
    }

    private class OnCameraClickListener
    implements View.OnClickListener {
        private OnCameraClickListener() {
        }

        public void onClick(View v) {
            if (!BoxingViewFragment.this.mIsCamera) {
                BoxingViewFragment.this.mIsCamera = true;
                BoxingViewFragment.this.startCamera((Activity)BoxingViewFragment.this.getActivity(), (Fragment)BoxingViewFragment.this, "/bili/boxing");
            }
        }
    }

    private class OnMediaClickListener
    implements View.OnClickListener {
        private OnMediaClickListener() {
        }

        public void onClick(View v) {
            BaseMedia media = (BaseMedia)v.getTag();
            int pos = (Integer)v.getTag(R.id.media_item_check);
            BoxingConfig.Mode mode = BoxingManager.getInstance().getBoxingConfig().getMode();
            if (mode == BoxingConfig.Mode.SINGLE_IMG) {
                this.singleImageClick(media);
            } else if (mode == BoxingConfig.Mode.MULTI_IMG) {
                this.multiImageClick(pos);
            } else if (mode == BoxingConfig.Mode.VIDEO) {
                this.videoClick(media);
            }
        }

        private void videoClick(BaseMedia media) {
            ArrayList<BaseMedia> iMedias = new ArrayList<BaseMedia>();
            iMedias.add(media);
            BoxingViewFragment.this.onFinish(iMedias);
        }

        private void multiImageClick(int pos) {
            if (!BoxingViewFragment.this.mIsPreview) {
                AlbumEntity albumMedia = BoxingViewFragment.this.mAlbumWindowAdapter.getCurrentAlbum();
                String albumId = albumMedia != null ? albumMedia.mBucketId : "";
                BoxingViewFragment.this.mIsPreview = true;
                ArrayList medias = (ArrayList)BoxingViewFragment.this.mMediaAdapter.getSelectedMedias();
                Boxing.get().withIntent(BoxingViewFragment.this.getContext(), BoxingViewActivity.class, medias, pos, albumId).start((Fragment)BoxingViewFragment.this, 9086, BoxingConfig.ViewMode.EDIT);
            }
        }

        private void singleImageClick(BaseMedia media) {
            ArrayList<BaseMedia> iMedias = new ArrayList<BaseMedia>();
            iMedias.add(media);
            if (BoxingViewFragment.this.hasCropBehavior()) {
                BoxingViewFragment.this.startCrop(media, 9087);
            } else {
                BoxingViewFragment.this.onFinish(iMedias);
            }
        }
    }

    private class ScrollListener
    extends RecyclerView.OnScrollListener {
        private ScrollListener() {
        }

        public void onScrolled(RecyclerView recyclerView, int dx, int dy) {
            int childCount = recyclerView.getChildCount();
            if (childCount > 0) {
                View lastChild = recyclerView.getChildAt(childCount - 1);
                RecyclerView.Adapter outerAdapter = recyclerView.getAdapter();
                int lastVisible = recyclerView.getChildAdapterPosition(lastChild);
                if (lastVisible == outerAdapter.getItemCount() - 1 && BoxingViewFragment.this.hasNextPage() && BoxingViewFragment.this.canLoadNextPage()) {
                    BoxingViewFragment.this.onLoadNextPage();
                }
            }
        }
    }
}

