/*
 * Decompiled with CFR 0.152.
 */
package com.bilibili.boxing_impl.view;

import android.graphics.Rect;
import android.support.v7.widget.GridLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.View;

public class SpacesItemDecoration
extends RecyclerView.ItemDecoration {
    private int mSpace;
    private int mSpanCount;
    private int mRadixX;
    private int mItemCountInLastLine;
    private int mOldItemCount = -1;

    public SpacesItemDecoration(int space) {
        this(space, 1);
    }

    public SpacesItemDecoration(int space, int spanCount) {
        this.mSpace = space;
        this.mSpanCount = spanCount;
        this.mRadixX = space / spanCount;
    }

    public void getItemOffsets(Rect outRect, View view, final RecyclerView parent, RecyclerView.State state) {
        int index;
        int spanSize;
        RecyclerView.LayoutParams params = (RecyclerView.LayoutParams)view.getLayoutParams();
        int sumCount = state.getItemCount();
        int position = params.getViewLayoutPosition();
        if (params instanceof GridLayoutManager.LayoutParams) {
            GridLayoutManager.LayoutParams gridParams = (GridLayoutManager.LayoutParams)params;
            spanSize = gridParams.getSpanSize();
            index = gridParams.getSpanIndex();
            if ((position == 0 || this.mOldItemCount != sumCount) && this.mSpanCount > 1) {
                int countInLine = 0;
                for (int tempPosition = sumCount - this.mSpanCount; tempPosition < sumCount; ++tempPosition) {
                    int spanIndex = ((GridLayoutManager)parent.getLayoutManager()).getSpanSizeLookup().getSpanIndex(tempPosition, this.mSpanCount);
                    countInLine = spanIndex == 0 ? 1 : countInLine + 1;
                }
                this.mItemCountInLastLine = countInLine;
                if (this.mOldItemCount != sumCount) {
                    this.mOldItemCount = sumCount;
                    if (position != 0) {
                        parent.post(new Runnable(){

                            @Override
                            public void run() {
                                parent.invalidateItemDecorations();
                            }
                        });
                    }
                }
            }
        } else if (params instanceof StaggeredGridLayoutManager.LayoutParams) {
            spanSize = ((StaggeredGridLayoutManager.LayoutParams)params).isFullSpan() ? this.mSpanCount : 1;
            index = ((StaggeredGridLayoutManager.LayoutParams)params).getSpanIndex();
        } else {
            spanSize = 1;
            index = 0;
        }
        if (spanSize < 1 || index < 0 || spanSize > this.mSpanCount) {
            return;
        }
        outRect.left = this.mSpace - this.mRadixX * index;
        outRect.right = this.mRadixX + this.mRadixX * (index + spanSize - 1);
        if (this.mSpanCount == 1 && position == sumCount - 1) {
            outRect.bottom = this.mSpace;
        } else if (position >= sumCount - this.mItemCountInLastLine && position < sumCount) {
            outRect.bottom = this.mSpace;
        }
        outRect.top = this.mSpace;
    }
}

