/*
 * Decompiled with CFR 0.152.
 */
package com.bilibili.boxing_impl.adapter;

import android.content.Context;
import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.bilibili.boxing.BoxingMediaLoader;
import com.bilibili.boxing.model.entity.AlbumEntity;
import com.bilibili.boxing.model.entity.impl.ImageMedia;
import com.bilibili.boxing_impl.R;
import java.util.ArrayList;
import java.util.List;

public class BoxingAlbumAdapter
extends RecyclerView.Adapter
implements View.OnClickListener {
    private static final String UNKNOW_ALBUM_NAME = "?";
    private int mCurrentAlbumPos;
    private List<AlbumEntity> mAlums = new ArrayList<AlbumEntity>();
    private LayoutInflater mInflater;
    private OnAlbumClickListener mAlbumOnClickListener;

    public BoxingAlbumAdapter(Context context) {
        this.mAlums.add(AlbumEntity.createDefaultAlbum());
        this.mInflater = LayoutInflater.from((Context)context);
    }

    public void setAlbumOnClickListener(OnAlbumClickListener albumOnClickListener) {
        this.mAlbumOnClickListener = albumOnClickListener;
    }

    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        return new AlbumViewHolder(this.mInflater.inflate(R.layout.layout_album_item, parent, false));
    }

    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {
        AlbumViewHolder albumViewHolder = (AlbumViewHolder)holder;
        albumViewHolder.mCoverImg.setImageResource(R.drawable.ic_default_image);
        int adapterPos = holder.getAdapterPosition();
        AlbumEntity album = this.mAlums.get(adapterPos);
        if (album != null && album.hasImages()) {
            albumViewHolder.mNameTxt.setText((CharSequence)album.mBucketName);
            ImageMedia media = (ImageMedia)album.mImageList.get(0);
            if (media != null) {
                BoxingMediaLoader.getInstance().displayThumbnail(albumViewHolder.mCoverImg, media.getPath(), 50, 50);
            }
            albumViewHolder.mLayout.setTag((Object)adapterPos);
            albumViewHolder.mLayout.setOnClickListener((View.OnClickListener)this);
            albumViewHolder.mCheckedImg.setVisibility(album.mIsSelected ? 0 : 8);
            albumViewHolder.mSizeTxt.setText((CharSequence)albumViewHolder.mSizeTxt.getResources().getString(R.string.album_images_fmt, new Object[]{album.mCount}));
        } else {
            albumViewHolder.mNameTxt.setText((CharSequence)UNKNOW_ALBUM_NAME);
            albumViewHolder.mSizeTxt.setVisibility(8);
        }
    }

    public void addAllData(List<AlbumEntity> alums) {
        this.mAlums.clear();
        this.mAlums.addAll(alums);
        this.notifyDataSetChanged();
    }

    public List<AlbumEntity> getAlums() {
        return this.mAlums;
    }

    public int getCurrentAlbumPos() {
        return this.mCurrentAlbumPos;
    }

    public void setCurrentAlbumPos(int currentAlbumPos) {
        this.mCurrentAlbumPos = currentAlbumPos;
    }

    public AlbumEntity getCurrentAlbum() {
        if (this.mAlums == null || this.mAlums.size() <= 0) {
            return null;
        }
        return this.mAlums.get(this.mCurrentAlbumPos);
    }

    public int getItemCount() {
        return this.mAlums != null ? this.mAlums.size() : 0;
    }

    public void onClick(View v) {
        int id2 = v.getId();
        if (id2 == R.id.album_layout && this.mAlbumOnClickListener != null) {
            this.mAlbumOnClickListener.onClick(v, (Integer)v.getTag());
        }
    }

    public static interface OnAlbumClickListener {
        public void onClick(View var1, int var2);
    }

    private static class AlbumViewHolder
    extends RecyclerView.ViewHolder {
        ImageView mCoverImg;
        TextView mNameTxt;
        TextView mSizeTxt;
        View mLayout;
        ImageView mCheckedImg;

        AlbumViewHolder(View itemView) {
            super(itemView);
            this.mCoverImg = (ImageView)itemView.findViewById(R.id.album_thumbnail);
            this.mNameTxt = (TextView)itemView.findViewById(R.id.album_name);
            this.mSizeTxt = (TextView)itemView.findViewById(R.id.album_size);
            this.mLayout = itemView.findViewById(R.id.album_layout);
            this.mCheckedImg = (ImageView)itemView.findViewById(R.id.album_checked);
        }
    }
}

