/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.swaggerbootstrapui.plugin;

import com.fasterxml.classmate.ResolvedType;
import com.fasterxml.classmate.TypeResolver;
import com.github.xiaoymin.swaggerbootstrapui.util.CommonUtils;
import com.google.common.base.Optional;
import io.swagger.annotations.ApiOperationSupport;
import io.swagger.annotations.DynamicParameter;
import io.swagger.annotations.DynamicResponseParameters;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.spi.DocumentationType;
import springfox.documentation.spi.service.OperationModelsProviderPlugin;
import springfox.documentation.spi.service.contexts.RequestMappingContext;

@Component
@Order(value=-2147483636)
public class OperationDynamicResponseModelProvider
implements OperationModelsProviderPlugin {
    @Autowired
    private TypeResolver typeResolver;
    private final Map<String, String> cacheGenModelMaps = new HashMap<String, String>();

    public void apply(RequestMappingContext context) {
        Optional supportOptional = context.findAnnotation(ApiOperationSupport.class);
        if (supportOptional.isPresent()) {
            this.collectDynamicParameter(((ApiOperationSupport)supportOptional.get()).responses(), context);
        } else {
            Optional dynamicParametersOptional = context.findAnnotation(DynamicResponseParameters.class);
            if (dynamicParametersOptional.isPresent()) {
                this.collectDynamicParameter((DynamicResponseParameters)dynamicParametersOptional.get(), context);
            }
        }
    }

    public boolean supports(DocumentationType delimiter) {
        return true;
    }

    private void collectDynamicParameter(DynamicResponseParameters dynamicParameters, RequestMappingContext context) {
        if (dynamicParameters != null) {
            DynamicParameter[] dynamics;
            String name = dynamicParameters.name();
            if (name == null || "".equals(name)) {
                name = this.genClassName(context);
            }
            if (this.cacheGenModelMaps.containsKey(name)) {
                name = this.genClassName(context);
            }
            if ((dynamics = dynamicParameters.properties()) != null && dynamics.length > 0) {
                this.cacheGenModelMaps.put(name, name);
                name = context.getGroupName().replaceAll("[_-]", "") + "." + name;
                Class<?> clazz = CommonUtils.createDynamicModelClass(name, dynamics);
                if (clazz != null) {
                    ResolvedType modelType = context.alternateFor(this.typeResolver.resolve(clazz, new Type[0]));
                    context.operationModelsBuilder().addReturn((Type)modelType);
                }
            }
        }
    }

    public String genClassName(RequestMappingContext context) {
        String name = context.getName();
        if (name != null && !"".equals(name)) {
            name = (name = name.replaceAll("[_-]", "")).length() == 1 ? name.toUpperCase() : name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        return name;
    }
}

