/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.swaggerbootstrapui.web;

import com.github.xiaoymin.swaggerbootstrapui.common.SwaggerBootstrapUiHostNameProvider;
import com.github.xiaoymin.swaggerbootstrapui.model.RestHandlerMapping;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiOperationSort;
import io.swagger.annotations.ApiSort;
import io.swagger.models.MarkdownFiles;
import io.swagger.models.Swagger;
import io.swagger.models.SwaggerBootstrapUi;
import io.swagger.models.SwaggerBootstrapUiPath;
import io.swagger.models.SwaggerBootstrapUiTag;
import io.swagger.models.SwaggerExt;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.mvc.condition.PatternsRequestCondition;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;
import org.springframework.web.util.UriComponents;
import springfox.documentation.RequestHandler;
import springfox.documentation.annotations.ApiIgnore;
import springfox.documentation.service.Documentation;
import springfox.documentation.service.Tag;
import springfox.documentation.spi.service.RequestHandlerProvider;
import springfox.documentation.spring.web.DocumentationCache;
import springfox.documentation.spring.web.WebMvcRequestHandler;
import springfox.documentation.spring.web.json.Json;
import springfox.documentation.spring.web.json.JsonSerializer;
import springfox.documentation.swagger.common.HostNameProvider;
import springfox.documentation.swagger2.mappers.ServiceModelToSwagger2Mapper;

@Controller
@ApiIgnore
public class SwaggerBootstrapUiController {
    public static final String DEFAULT_SORT_URL = "/v2/api-docs-ext";
    private static final String HAL_MEDIA_TYPE = "application/hal+json";
    private static final Logger LOGGER = LoggerFactory.getLogger(SwaggerBootstrapUiController.class);
    private final ServiceModelToSwagger2Mapper mapper;
    private final DocumentationCache documentationCache;
    private final JsonSerializer jsonSerializer;
    private final String hostNameOverride;
    private final List<RequestHandlerProvider> handlerProviders;
    private final MarkdownFiles markdownFiles;
    private List<RestHandlerMapping> globalHandlerMappings = new ArrayList<RestHandlerMapping>();
    private final RequestMethod[] globalRequestMethods = new RequestMethod[]{RequestMethod.POST, RequestMethod.GET, RequestMethod.PUT, RequestMethod.DELETE, RequestMethod.PATCH, RequestMethod.OPTIONS, RequestMethod.HEAD};

    @Autowired
    public SwaggerBootstrapUiController(Environment environment, ServiceModelToSwagger2Mapper mapper, DocumentationCache documentationCache, JsonSerializer jsonSerializer, List<RequestHandlerProvider> handlerProviders, ObjectProvider<MarkdownFiles> markdownFilesObjectProvider) {
        this.mapper = mapper;
        this.documentationCache = documentationCache;
        this.jsonSerializer = jsonSerializer;
        this.hostNameOverride = environment.getProperty("springfox.documentation.swagger.v2.host", "DEFAULT");
        this.handlerProviders = handlerProviders;
        this.markdownFiles = (MarkdownFiles)markdownFilesObjectProvider.getIfAvailable();
    }

    private Function<RequestHandlerProvider, ? extends Iterable<RequestHandler>> handlers() {
        return new Function<RequestHandlerProvider, Iterable<RequestHandler>>(){

            public Iterable<RequestHandler> apply(RequestHandlerProvider input) {
                return input.requestHandlers();
            }
        };
    }

    @RequestMapping(value={"/v2/api-docs-ext"}, method={RequestMethod.GET}, produces={"application/json", "application/hal+json"})
    @ResponseBody
    public ResponseEntity<Json> apiSorts(@RequestParam(value="group", required=false) String swaggerGroup, HttpServletRequest request) {
        UriComponents uriComponents;
        Swagger swagger;
        Documentation documentation;
        block5: {
            String groupName = (String)Optional.fromNullable((Object)swaggerGroup).or((Object)"default");
            documentation = this.documentationCache.documentationByGroup(groupName);
            if (documentation == null) {
                LOGGER.warn("Unable to find specification for group {},use default", (Object)groupName);
                documentation = this.documentationCache.documentationByGroup("default");
                if (documentation == null) {
                    LOGGER.warn("Unable to find specification for group default");
                    return new ResponseEntity(HttpStatus.NOT_FOUND);
                }
            }
            swagger = this.mapper.mapDocumentation(documentation);
            uriComponents = null;
            try {
                uriComponents = HostNameProvider.componentsFrom((HttpServletRequest)request, (String)swagger.getBasePath());
            }
            catch (Throwable e) {
                String msg;
                LOGGER.error(e.getClass().getName() + ":" + e.getMessage());
                if (!(e instanceof ClassNotFoundException) && !(e instanceof NoClassDefFoundError) || (msg = e.getMessage()) == null || "".equals(msg) || !msg.endsWith("HostNameProvider")) break block5;
                uriComponents = SwaggerBootstrapUiHostNameProvider.componentsFrom(request, swagger.getBasePath());
            }
        }
        swagger.basePath(Strings.isNullOrEmpty((String)uriComponents.getPath()) ? "/" : uriComponents.getPath());
        if (Strings.isNullOrEmpty((String)swagger.getHost())) {
            swagger.host(this.hostName(uriComponents));
        }
        SwaggerExt swaggerExt = new SwaggerExt(swagger);
        swaggerExt.setSwaggerBootstrapUi(this.initSwaggerBootstrapUi(request, documentation, swaggerExt));
        return new ResponseEntity((Object)this.jsonSerializer.toJson((Object)swaggerExt), HttpStatus.OK);
    }

    private SwaggerBootstrapUi initSwaggerBootstrapUi(HttpServletRequest request, Documentation documentation, SwaggerExt swaggerExt) {
        SwaggerBootstrapUi swaggerBootstrapUi = new SwaggerBootstrapUi();
        WebApplicationContext wc = WebApplicationContextUtils.getWebApplicationContext((ServletContext)request.getServletContext());
        if (wc == null) {
            String msg = "WebApplicationContext is Empty~!,Enable SwaggerBootstrapUi fun fail~!";
            LOGGER.warn(msg);
            swaggerBootstrapUi.setErrorMsg(msg);
            return swaggerBootstrapUi;
        }
        Iterator tags = documentation.getTags().iterator();
        this.initGlobalRequestMappingArray(swaggerExt);
        ArrayList targetTagLists = Lists.newArrayList();
        ArrayList targetPathLists = Lists.newArrayList();
        while (tags.hasNext()) {
            Tag sourceTag = (Tag)tags.next();
            String tagName = sourceTag.getName();
            int order = Integer.MAX_VALUE;
            SwaggerBootstrapUiTag tag = new SwaggerBootstrapUiTag(order);
            tag.name(tagName).description(sourceTag.getDescription());
            Api tagApi = null;
            RestHandlerMapping tagMapping = null;
            for (RestHandlerMapping rhm : this.globalHandlerMappings) {
                Api api = rhm.getBeanType().getAnnotation(Api.class);
                if (api == null) continue;
                if (api.tags() != null && api.tags().length > 0) {
                    if (Lists.newArrayList((Object[])api.tags()).contains(tagName)) {
                        tagApi = api;
                        tagMapping = rhm;
                        this.createPathInstance(rhm, targetPathLists);
                        continue;
                    }
                    String firstTag = api.tags()[0];
                    if (!StringUtils.isEmpty((Object)firstTag) || !this.checkExists(tagName, rhm.getBeanType())) continue;
                    tagApi = api;
                    tagMapping = rhm;
                    this.createPathInstance(rhm, targetPathLists);
                    continue;
                }
                if (!this.checkExists(tagName, rhm.getBeanType())) continue;
                if (!StringUtils.isEmpty((Object)api.value())) {
                    tag.name(api.value());
                }
                tagApi = api;
                tagMapping = rhm;
                this.createPathInstance(rhm, targetPathLists);
            }
            if (tagMapping != null) {
                tag.setOrder(this.getRestTagOrder(tagMapping.getBeanType(), tagApi));
            }
            targetTagLists.add(tag);
        }
        Collections.sort(targetTagLists, new Comparator<SwaggerBootstrapUiTag>(){

            @Override
            public int compare(SwaggerBootstrapUiTag o1, SwaggerBootstrapUiTag o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        });
        Collections.sort(targetPathLists, new Comparator<SwaggerBootstrapUiPath>(){

            @Override
            public int compare(SwaggerBootstrapUiPath o1, SwaggerBootstrapUiPath o2) {
                return o1.getOrder().compareTo(o2.getOrder());
            }
        });
        swaggerBootstrapUi.setTagSortLists(targetTagLists);
        swaggerBootstrapUi.setPathSortLists(targetPathLists);
        if (this.markdownFiles != null) {
            swaggerBootstrapUi.setMarkdownFiles(this.markdownFiles.getMarkdownFiles());
        }
        return swaggerBootstrapUi;
    }

    private void initGlobalRequestMappingArray(SwaggerExt swaggerExt) {
        if (this.globalHandlerMappings.size() == 0) {
            String parentPath = "";
            if (!StringUtils.isEmpty((Object)swaggerExt.getBasePath()) && !"/".equals(swaggerExt.getBasePath())) {
                parentPath = parentPath + swaggerExt.getBasePath();
            }
            try {
                ImmutableList requestHandlers = FluentIterable.from(this.handlerProviders).transformAndConcat(this.handlers()).toList();
                for (RequestHandler requestHandler : requestHandlers) {
                    if (!(requestHandler instanceof WebMvcRequestHandler)) continue;
                    WebMvcRequestHandler webMvcRequestHandler = (WebMvcRequestHandler)requestHandler;
                    Set patterns = webMvcRequestHandler.getRequestMapping().getPatternsCondition().getPatterns();
                    Set restMethods = webMvcRequestHandler.getRequestMapping().getMethodsCondition().getMethods();
                    HandlerMethod handlerMethod = webMvcRequestHandler.getHandlerMethod();
                    Class controllerClazz = ClassUtils.getUserClass((Class)handlerMethod.getBeanType());
                    Method method = ClassUtils.getMostSpecificMethod((Method)handlerMethod.getMethod(), (Class)controllerClazz);
                    for (String url : patterns) {
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("url:" + url + "\r\nclass:" + controllerClazz.toString() + "\r\nmethod:" + method.toString());
                        }
                        this.globalHandlerMappings.add(new RestHandlerMapping(parentPath + url, controllerClazz, method, restMethods));
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Deprecated
    private void initGlobalRequestMappingArray(WebApplicationContext wc, SwaggerExt swaggerExt) {
        if (this.globalHandlerMappings.size() == 0) {
            Map requestMappings;
            String parentPath = "";
            if (!StringUtils.isEmpty((Object)swaggerExt.getBasePath()) && !"/".equals(swaggerExt.getBasePath())) {
                parentPath = parentPath + swaggerExt.getBasePath();
            }
            if ((requestMappings = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)wc, HandlerMapping.class, (boolean)true, (boolean)false)) != null) {
                for (HandlerMapping handlerMapping : requestMappings.values()) {
                    if (!(handlerMapping instanceof RequestMappingHandlerMapping)) continue;
                    RequestMappingHandlerMapping rmhMapping = (RequestMappingHandlerMapping)handlerMapping;
                    Map handlerMethods = rmhMapping.getHandlerMethods();
                    for (RequestMappingInfo rmi : handlerMethods.keySet()) {
                        PatternsRequestCondition prc = rmi.getPatternsCondition();
                        Set restMethods = rmi.getMethodsCondition().getMethods();
                        Set patterns = prc.getPatterns();
                        HandlerMethod handlerMethod = (HandlerMethod)handlerMethods.get(rmi);
                        for (String url : patterns) {
                            Class clazz = ClassUtils.getUserClass((Class)handlerMethod.getBeanType());
                            Method method = ClassUtils.getMostSpecificMethod((Method)handlerMethod.getMethod(), (Class)clazz);
                            if (LOGGER.isDebugEnabled()) {
                                LOGGER.debug("url:" + url + "\r\nclass:" + clazz.toString() + "\r\nmethod:" + method.toString());
                            }
                            this.globalHandlerMappings.add(new RestHandlerMapping(parentPath + url, clazz, method, restMethods));
                        }
                    }
                }
            }
        }
    }

    private void createPathInstance(RestHandlerMapping rhm, List<SwaggerBootstrapUiPath> targetPathLists) {
        if (rhm.getRequestMethods() == null || rhm.getRequestMethods().size() == 0) {
            for (RequestMethod requestMethod : this.globalRequestMethods) {
                targetPathLists.add(new SwaggerBootstrapUiPath(rhm.getUrl(), requestMethod.name().toUpperCase(), this.getRestMethodOrder(rhm.getBeanOfMethod())));
            }
        } else {
            for (RequestMethod requestMethod : rhm.getRequestMethods()) {
                targetPathLists.add(new SwaggerBootstrapUiPath(rhm.getUrl(), requestMethod.name().toUpperCase(), this.getRestMethodOrder(rhm.getBeanOfMethod())));
            }
        }
    }

    private int getRestTagOrder(Class<?> aClass, Api api) {
        int order = Integer.MAX_VALUE;
        if (api != null) {
            int post = api.position();
            if (post == 0) {
                ApiSort annotation;
                if (aClass != null && (annotation = ClassUtils.getUserClass(aClass).getAnnotation(ApiSort.class)) != null) {
                    order = annotation.value();
                }
            } else {
                order = post;
            }
        }
        return order;
    }

    private int getRestMethodOrder(Method target) {
        int pathOrder = Integer.MAX_VALUE;
        ApiOperation apiOperation = target.getAnnotation(ApiOperation.class);
        if (apiOperation != null) {
            if (apiOperation.position() != 0) {
                pathOrder = apiOperation.position();
            } else {
                ApiOperationSort apiOperationSort = target.getAnnotation(ApiOperationSort.class);
                if (apiOperationSort != null) {
                    pathOrder = apiOperationSort.value();
                }
            }
        } else {
            ApiOperationSort apiOperationSort = target.getAnnotation(ApiOperationSort.class);
            if (apiOperationSort != null) {
                pathOrder = apiOperationSort.value();
            }
        }
        return pathOrder;
    }

    private boolean checkExists(String tagName, Class<?> aClass) {
        String regexStr;
        Pattern pattern;
        boolean flag = false;
        if (!StringUtils.isEmpty((Object)tagName) && (pattern = Pattern.compile(regexStr = tagName.replaceAll("\\-", ".*?"), 2)).matcher(aClass.getSimpleName()).matches()) {
            flag = true;
        }
        return flag;
    }

    private String hostName(UriComponents uriComponents) {
        if ("DEFAULT".equals(this.hostNameOverride)) {
            String host = uriComponents.getHost();
            int port = uriComponents.getPort();
            if (port > -1) {
                return String.format("%s:%d", host, port);
            }
            return host;
        }
        return this.hostNameOverride;
    }
}

