/*
 * Decompiled with CFR 0.152.
 */
package com.xiao.nicevideoplayer;

import android.content.Context;
import android.view.TextureView;
import android.view.View;

public class NiceTextureView
extends TextureView {
    private int videoHeight;
    private int videoWidth;

    public NiceTextureView(Context context) {
        super(context);
    }

    public void adaptVideoSize(int videoWidth, int videoHeight) {
        if (this.videoWidth != videoWidth && this.videoHeight != videoHeight) {
            this.videoWidth = videoWidth;
            this.videoHeight = videoHeight;
            this.requestLayout();
        }
    }

    public void setRotation(float rotation) {
        if (rotation != this.getRotation()) {
            super.setRotation(rotation);
            this.requestLayout();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float viewRotation = this.getRotation();
        if (viewRotation == 90.0f || viewRotation == 270.0f) {
            int tempMeasureSpec = widthMeasureSpec;
            widthMeasureSpec = heightMeasureSpec;
            heightMeasureSpec = tempMeasureSpec;
        }
        int width = NiceTextureView.getDefaultSize((int)this.videoWidth, (int)widthMeasureSpec);
        int height = NiceTextureView.getDefaultSize((int)this.videoHeight, (int)heightMeasureSpec);
        if (this.videoWidth > 0 && this.videoHeight > 0) {
            int widthSpecMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int widthSpecSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSpecMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int heightSpecSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthSpecMode == 0x40000000 && heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = widthSpecSize;
                if (this.videoWidth * height < width * this.videoHeight) {
                    width = height * this.videoWidth / this.videoHeight;
                } else if (this.videoWidth * height > width * this.videoHeight) {
                    height = width * this.videoHeight / this.videoWidth;
                }
            } else if (widthSpecMode == 0x40000000) {
                width = widthSpecSize;
                height = width * this.videoHeight / this.videoWidth;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * this.videoWidth / this.videoHeight;
                }
            } else if (heightSpecMode == 0x40000000) {
                height = heightSpecSize;
                width = height * this.videoWidth / this.videoHeight;
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * this.videoHeight / this.videoWidth;
                }
            } else {
                width = this.videoWidth;
                height = this.videoHeight;
                if (heightSpecMode == Integer.MIN_VALUE && height > heightSpecSize) {
                    height = heightSpecSize;
                    width = height * this.videoWidth / this.videoHeight;
                }
                if (widthSpecMode == Integer.MIN_VALUE && width > widthSpecSize) {
                    width = widthSpecSize;
                    height = width * this.videoHeight / this.videoWidth;
                }
            }
        }
        this.setMeasuredDimension(width, height);
    }
}

