/*
 * Decompiled with CFR 0.152.
 */
package com.xiao.nicevideoplayer;

import android.app.Dialog;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.xiao.nicevideoplayer.NiceUtil;
import com.xiao.nicevideoplayer.R;
import java.util.List;

public class ChangeClarityDialog
extends Dialog {
    private LinearLayout mLinearLayout;
    private int mCurrentCheckedIndex;
    private OnClarityChangedListener mListener;

    public ChangeClarityDialog(Context context) {
        super(context, R.style.dialog_change_clarity);
        this.init(context);
    }

    private void init(Context context) {
        this.mLinearLayout = new LinearLayout(context);
        this.mLinearLayout.setGravity(17);
        this.mLinearLayout.setOrientation(1);
        this.mLinearLayout.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (ChangeClarityDialog.this.mListener != null) {
                    ChangeClarityDialog.this.mListener.onClarityNotChanged();
                }
                ChangeClarityDialog.this.dismiss();
            }
        });
        ViewGroup.LayoutParams params = new ViewGroup.LayoutParams(-1, -1);
        this.setContentView((View)this.mLinearLayout, params);
        WindowManager.LayoutParams windowParams = this.getWindow().getAttributes();
        windowParams.width = NiceUtil.getScreenHeight(context);
        windowParams.height = NiceUtil.getScreenWidth(context);
        this.getWindow().setAttributes(windowParams);
    }

    public void setClarityGrade(List<String> items, int defaultChecked) {
        this.mCurrentCheckedIndex = defaultChecked;
        for (int i = 0; i < items.size(); ++i) {
            TextView itemView = (TextView)LayoutInflater.from((Context)this.getContext()).inflate(R.layout.item_change_clarity, (ViewGroup)this.mLinearLayout, false);
            itemView.setTag((Object)i);
            itemView.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (ChangeClarityDialog.this.mListener != null) {
                        int checkIndex = (Integer)v.getTag();
                        if (checkIndex != ChangeClarityDialog.this.mCurrentCheckedIndex) {
                            for (int j = 0; j < ChangeClarityDialog.this.mLinearLayout.getChildCount(); ++j) {
                                ChangeClarityDialog.this.mLinearLayout.getChildAt(j).setSelected(checkIndex == j);
                            }
                            ChangeClarityDialog.this.mListener.onClarityChanged(checkIndex);
                            ChangeClarityDialog.this.mCurrentCheckedIndex = checkIndex;
                        } else {
                            ChangeClarityDialog.this.mListener.onClarityNotChanged();
                        }
                    }
                    ChangeClarityDialog.this.dismiss();
                }
            });
            itemView.setText((CharSequence)items.get(i));
            itemView.setSelected(i == defaultChecked);
            ViewGroup.MarginLayoutParams params = (ViewGroup.MarginLayoutParams)itemView.getLayoutParams();
            params.topMargin = i == 0 ? 0 : NiceUtil.dp2px(this.getContext(), 16.0f);
            this.mLinearLayout.addView((View)itemView, (ViewGroup.LayoutParams)params);
        }
    }

    public void setOnClarityCheckedListener(OnClarityChangedListener listener) {
        this.mListener = listener;
    }

    public void onBackPressed() {
        if (this.mListener != null) {
            this.mListener.onClarityNotChanged();
        }
        super.onBackPressed();
    }

    public static interface OnClarityChangedListener {
        public void onClarityChanged(int var1);

        public void onClarityNotChanged();
    }
}

