/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.support;

import android.support.annotation.AnyThread;
import android.support.annotation.CallSuper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.xiaojinzi.component.impl.RouterRequest;

public interface NavigationDisposable {
    @Nullable
    @AnyThread
    public RouterRequest originalRequest();

    @AnyThread
    public void cancel();

    @AnyThread
    public boolean isCanceled();

    public static final class ProxyNavigationDisposableImpl
    implements NavigationDisposable {
        @Nullable
        private NavigationDisposable proxyNavigationDisposable;
        private boolean isDisposabled = false;

        @Override
        @Nullable
        public synchronized RouterRequest originalRequest() {
            if (this.proxyNavigationDisposable != null) {
                return this.proxyNavigationDisposable.originalRequest();
            }
            return null;
        }

        @Override
        @CallSuper
        public synchronized void cancel() {
            if (this.proxyNavigationDisposable != null) {
                this.proxyNavigationDisposable.cancel();
            }
            this.isDisposabled = true;
        }

        public synchronized void setProxy(@NonNull NavigationDisposable navigationDisposable) {
            this.proxyNavigationDisposable = navigationDisposable;
        }

        @Override
        public final synchronized boolean isCanceled() {
            if (this.proxyNavigationDisposable != null) {
                return this.proxyNavigationDisposable.isCanceled();
            }
            return this.isDisposabled;
        }
    }

    public static interface Cancellable {
        public void cancel();
    }
}

