/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl.service;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.xiaojinzi.component.Component;
import com.xiaojinzi.component.ComponentUtil;
import com.xiaojinzi.component.service.IComponentCenterService;
import com.xiaojinzi.component.service.IComponentHostService;
import com.xiaojinzi.component.support.ASMUtil;
import com.xiaojinzi.component.support.Utils;
import java.util.HashMap;
import java.util.Map;

public class ServiceCenter
implements IComponentCenterService {
    private Map<String, IComponentHostService> moduleServiceMap = new HashMap<String, IComponentHostService>();
    private static volatile ServiceCenter instance;

    private ServiceCenter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ServiceCenter getInstance() {
        if (instance != null) return instance;
        Class<ServiceCenter> clazz = ServiceCenter.class;
        synchronized (ServiceCenter.class) {
            if (instance != null) return instance;
            instance = new ServiceCenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    public void register(@NonNull IComponentHostService service) {
        Utils.checkNullPointer(service);
        if (!this.moduleServiceMap.containsKey(service.getHost())) {
            this.moduleServiceMap.put(service.getHost(), service);
            service.onCreate(Component.getApplication());
        }
    }

    @Override
    public void register(@NonNull String host) {
        IComponentHostService moduleService;
        Utils.checkStringNullPointer(host, "host");
        if (!this.moduleServiceMap.containsKey(host) && (moduleService = this.findModuleService(host)) != null) {
            this.register(moduleService);
        }
    }

    @Override
    public void unregister(@NonNull IComponentHostService moduleService) {
        Utils.checkNullPointer(moduleService);
        this.moduleServiceMap.remove(moduleService.getHost());
        moduleService.onDestroy();
    }

    @Override
    public void unregister(@NonNull String host) {
        Utils.checkStringNullPointer(host, "host");
        IComponentHostService moduleService = this.moduleServiceMap.get(host);
        if (moduleService != null) {
            this.unregister(moduleService);
        }
    }

    @Nullable
    public IComponentHostService findModuleService(@NonNull String host) {
        try {
            if (Component.getConfig().isOptimizeInit()) {
                return ASMUtil.findModuleServiceAsmImpl(ComponentUtil.transformHostForClass((String)host));
            }
            Class<?> clazz = null;
            String className = ComponentUtil.genHostServiceClassName((String)host);
            clazz = Class.forName(className);
            return (IComponentHostService)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

