/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl.interceptor;

import android.net.Uri;
import com.xiaojinzi.component.Component;
import com.xiaojinzi.component.error.ignore.NavigationFailException;
import com.xiaojinzi.component.impl.RouterInterceptor;

public class OpenOnceInterceptorBackUp
implements RouterInterceptor {
    private String preHost;
    private String prePath;
    private long preTargetTime;

    private OpenOnceInterceptorBackUp() {
    }

    public static OpenOnceInterceptorBackUp getInstance() {
        return SingletonInstance.INSTANCE;
    }

    @Override
    public void intercept(RouterInterceptor.Chain chain) throws Exception {
        Uri uri = chain.request().uri;
        String currentHost = uri.getHost();
        String currentPath = uri.getPath();
        long currentTime = System.currentTimeMillis();
        if (currentHost.equals(this.preHost) && currentPath.equals(this.prePath) && currentTime - this.preTargetTime < Component.getConfig().getRouteRepeatCheckDuration()) {
            chain.callback().onError(new NavigationFailException("same request can't launch twice in a second, target uri is\uff1a" + uri.toString()));
        } else {
            this.preHost = currentHost;
            this.prePath = currentPath;
            this.preTargetTime = currentTime;
            chain.proceed(chain.request());
        }
    }

    private static class SingletonInstance {
        private static final OpenOnceInterceptorBackUp INSTANCE = new OpenOnceInterceptorBackUp();

        private SingletonInstance() {
        }
    }
}

