/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl.interceptor;

import android.support.annotation.AnyThread;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.xiaojinzi.component.Component;
import com.xiaojinzi.component.ComponentUtil;
import com.xiaojinzi.component.error.InterceptorNameExistException;
import com.xiaojinzi.component.impl.RouterInterceptor;
import com.xiaojinzi.component.impl.interceptor.InterceptorBean;
import com.xiaojinzi.component.interceptor.IComponentCenterInterceptor;
import com.xiaojinzi.component.interceptor.IComponentHostInterceptor;
import com.xiaojinzi.component.support.ASMUtil;
import com.xiaojinzi.component.support.RouterInterceptorCache;
import com.xiaojinzi.component.support.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InterceptorCenter
implements IComponentCenterInterceptor {
    private static volatile InterceptorCenter instance;
    private Map<String, IComponentHostInterceptor> moduleInterceptorMap = new HashMap<String, IComponentHostInterceptor>();
    private List<RouterInterceptor> mGlobalInterceptorList = new ArrayList<RouterInterceptor>();
    private Map<String, Class<? extends RouterInterceptor>> mInterceptorMap = new HashMap<String, Class<? extends RouterInterceptor>>();
    private boolean isInterceptorListHaveChange = false;

    private InterceptorCenter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static InterceptorCenter getInstance() {
        if (instance != null) return instance;
        Class<InterceptorCenter> clazz = InterceptorCenter.class;
        synchronized (InterceptorCenter.class) {
            if (instance != null) return instance;
            instance = new InterceptorCenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    @UiThread
    public List<RouterInterceptor> getGlobalInterceptorList() {
        if (this.isInterceptorListHaveChange) {
            this.loadAllGlobalInterceptor();
            this.isInterceptorListHaveChange = false;
        }
        return this.mGlobalInterceptorList;
    }

    @Override
    public void register(@NonNull IComponentHostInterceptor hostInterceptor) {
        Utils.checkNullPointer(hostInterceptor);
        if (!this.moduleInterceptorMap.containsKey(hostInterceptor.getHost())) {
            this.isInterceptorListHaveChange = true;
            this.moduleInterceptorMap.put(hostInterceptor.getHost(), hostInterceptor);
            Map<String, Class<? extends RouterInterceptor>> childInterceptorMap = hostInterceptor.getInterceptorMap();
            this.mInterceptorMap.putAll(childInterceptorMap);
        }
    }

    @Override
    public void register(@NonNull String host) {
        IComponentHostInterceptor moduleInterceptor;
        Utils.checkStringNullPointer(host, "host");
        if (!this.moduleInterceptorMap.containsKey(host) && (moduleInterceptor = this.findModuleInterceptor(host)) != null) {
            this.register(moduleInterceptor);
        }
    }

    @Override
    public void unregister(@NonNull IComponentHostInterceptor hostInterceptor) {
        Utils.checkNullPointer(hostInterceptor);
        this.moduleInterceptorMap.remove(hostInterceptor.getHost());
        this.isInterceptorListHaveChange = true;
        Map<String, Class<? extends RouterInterceptor>> childInterceptorMap = hostInterceptor.getInterceptorMap();
        for (Map.Entry<String, Class<? extends RouterInterceptor>> entry : childInterceptorMap.entrySet()) {
            this.mInterceptorMap.remove(entry.getKey());
            RouterInterceptorCache.removeCache(entry.getValue());
        }
    }

    @Override
    public void unregister(@NonNull String host) {
        Utils.checkStringNullPointer(host, "host");
        IComponentHostInterceptor moduleInterceptor = this.moduleInterceptorMap.get(host);
        if (moduleInterceptor != null) {
            this.unregister(moduleInterceptor);
        }
    }

    @UiThread
    private void loadAllGlobalInterceptor() {
        this.mGlobalInterceptorList.clear();
        ArrayList<InterceptorBean> totalList = new ArrayList<InterceptorBean>();
        for (Map.Entry<String, IComponentHostInterceptor> entry : this.moduleInterceptorMap.entrySet()) {
            List<InterceptorBean> list = entry.getValue().globalInterceptorList();
            totalList.addAll(list);
        }
        Collections.sort(totalList, new Comparator<InterceptorBean>(){

            @Override
            public int compare(InterceptorBean o1, InterceptorBean o2) {
                if (o1.priority == o2.priority) {
                    return 0;
                }
                if (o1.priority > o2.priority) {
                    return -1;
                }
                return 1;
            }
        });
        for (InterceptorBean interceptorBean : totalList) {
            this.mGlobalInterceptorList.add(interceptorBean.interceptor);
        }
    }

    @Nullable
    @AnyThread
    public IComponentHostInterceptor findModuleInterceptor(String host) {
        try {
            if (Component.getConfig().isOptimizeInit()) {
                return ASMUtil.findModuleInterceptorAsmImpl(ComponentUtil.transformHostForClass((String)host));
            }
            Class<?> clazz = null;
            String className = ComponentUtil.genHostInterceptorClassName((String)host);
            clazz = Class.forName(className);
            return (IComponentHostInterceptor)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    @Nullable
    @UiThread
    public RouterInterceptor getByName(@Nullable String interceptorName) {
        if (interceptorName == null) {
            return null;
        }
        RouterInterceptor result = null;
        Class<? extends RouterInterceptor> interceptorClass = this.mInterceptorMap.get(interceptorName);
        result = interceptorClass == null ? null : RouterInterceptorCache.getInterceptorByClass(interceptorClass);
        return result;
    }

    @UiThread
    public void check() {
        Utils.checkMainThread();
        HashSet<String> set = new HashSet<String>();
        for (Map.Entry<String, IComponentHostInterceptor> entry : this.moduleInterceptorMap.entrySet()) {
            Set<String> childInterceptorNames;
            IComponentHostInterceptor childInterceptor = entry.getValue();
            if (childInterceptor == null || (childInterceptorNames = childInterceptor.getInterceptorNames()).isEmpty()) continue;
            for (String interceptorName : childInterceptorNames) {
                if (set.contains(interceptorName)) {
                    throw new InterceptorNameExistException("the interceptor's name is exist\uff1a" + interceptorName);
                }
                set.add(interceptorName);
            }
        }
    }
}

