/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.xiaojinzi.component.Component;
import com.xiaojinzi.component.ComponentUtil;
import com.xiaojinzi.component.bean.RouterDegradeBean;
import com.xiaojinzi.component.impl.RouterDegrade;
import com.xiaojinzi.component.router.IComponentCenterRouterDegrade;
import com.xiaojinzi.component.router.IComponentHostRouterDegrade;
import com.xiaojinzi.component.support.ASMUtil;
import com.xiaojinzi.component.support.RouterDegradeCache;
import com.xiaojinzi.component.support.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RouterDegradeCenter
implements IComponentCenterRouterDegrade {
    private static volatile RouterDegradeCenter instance;
    private Map<String, IComponentHostRouterDegrade> moduleRouterDegradeMap = new HashMap<String, IComponentHostRouterDegrade>();
    private List<RouterDegradeItem> mGlobalRouterDegradeList = new ArrayList<RouterDegradeItem>();
    private boolean isRouterDegradeListHaveChange = false;

    private RouterDegradeCenter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RouterDegradeCenter getInstance() {
        if (instance != null) return instance;
        Class<RouterDegradeCenter> clazz = RouterDegradeCenter.class;
        synchronized (RouterDegradeCenter.class) {
            if (instance != null) return instance;
            instance = new RouterDegradeCenter();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @Override
    @NonNull
    public List<RouterDegrade> getGlobalRouterDegradeList() {
        if (this.isRouterDegradeListHaveChange) {
            this.loadAllGlobalRouterDegrade();
            this.isRouterDegradeListHaveChange = false;
        }
        ArrayList<RouterDegrade> result = new ArrayList<RouterDegrade>();
        for (RouterDegradeItem item : this.mGlobalRouterDegradeList) {
            result.add(item.routerDegrade);
        }
        return result;
    }

    private void loadAllGlobalRouterDegrade() {
        this.mGlobalRouterDegradeList.clear();
        ArrayList<RouterDegradeBean> totalList = new ArrayList<RouterDegradeBean>();
        for (Map.Entry<String, IComponentHostRouterDegrade> entry : this.moduleRouterDegradeMap.entrySet()) {
            List<RouterDegradeBean> list = entry.getValue().listRouterDegrade();
            totalList.addAll(list);
        }
        for (RouterDegradeBean routerDegradeBean : totalList) {
            this.mGlobalRouterDegradeList.add(new RouterDegradeItem(routerDegradeBean.getPriority(), RouterDegradeCache.getRouterDegradeByClass(routerDegradeBean.getTargetClass())));
        }
        Collections.sort(this.mGlobalRouterDegradeList, new Comparator<RouterDegradeItem>(){

            @Override
            public int compare(RouterDegradeItem o1, RouterDegradeItem o2) {
                if (o1.priority == o2.priority) {
                    return 0;
                }
                if (o1.priority > o2.priority) {
                    return -1;
                }
                return 1;
            }
        });
    }

    @Override
    public void register(@NonNull IComponentHostRouterDegrade routerDegrade) {
        Utils.checkNullPointer(routerDegrade);
        this.isRouterDegradeListHaveChange = true;
        this.moduleRouterDegradeMap.put(routerDegrade.getHost(), routerDegrade);
    }

    @Override
    public void register(@NonNull String host) {
        IComponentHostRouterDegrade moduleRouterDegrade;
        Utils.checkStringNullPointer(host, "host");
        if (!this.moduleRouterDegradeMap.containsKey(host) && (moduleRouterDegrade = this.findModuleRouterDegrade(host)) != null) {
            this.register(moduleRouterDegrade);
        }
    }

    @Override
    public void unregister(@NonNull IComponentHostRouterDegrade routerDegrade) {
        Utils.checkNullPointer(routerDegrade);
        this.moduleRouterDegradeMap.remove(routerDegrade.getHost());
        this.isRouterDegradeListHaveChange = true;
    }

    @Override
    public void unregister(@NonNull String host) {
        Utils.checkStringNullPointer(host, "host");
        IComponentHostRouterDegrade moduleRouterDegrade = this.moduleRouterDegradeMap.get(host);
        if (moduleRouterDegrade != null) {
            this.unregister(moduleRouterDegrade);
        }
    }

    @Nullable
    public IComponentHostRouterDegrade findModuleRouterDegrade(String host) {
        try {
            if (Component.getConfig().isOptimizeInit()) {
                return ASMUtil.findModuleRouterDegradeAsmImpl(ComponentUtil.transformHostForClass((String)host));
            }
            Class<?> clazz = null;
            String className = ComponentUtil.genHostRouterDegradeClassName((String)host);
            clazz = Class.forName(className);
            return (IComponentHostRouterDegrade)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private class RouterDegradeItem {
        public int priority;
        @NonNull
        public RouterDegrade routerDegrade;

        public RouterDegradeItem(@NonNull int priority, RouterDegrade routerDegrade) {
            this.priority = priority;
            this.routerDegrade = routerDegrade;
        }
    }
}

