/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component.impl;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import com.xiaojinzi.component.impl.RouterErrorResult;
import com.xiaojinzi.component.impl.RouterRequest;
import com.xiaojinzi.component.impl.RouterResult;
import com.xiaojinzi.component.support.Function;
import com.xiaojinzi.component.support.OnRouterCancel;
import com.xiaojinzi.component.support.OnRouterError;
import com.xiaojinzi.component.support.Utils;

public interface BiCallback<T>
extends OnRouterCancel,
OnRouterError {
    @UiThread
    public void onSuccess(@NonNull RouterResult var1, @NonNull T var2);

    public static class BiCallbackAdapter<T>
    implements BiCallback<T> {
        @Override
        public void onSuccess(@NonNull RouterResult result, @NonNull T t) {
        }

        @Override
        public void onError(@NonNull RouterErrorResult errorResult) {
        }

        @Override
        public void onCancel(@NonNull RouterRequest originalRequest) {
        }
    }

    public static abstract class Map<T, R>
    implements BiCallback<T>,
    Function<T, R> {
        @NonNull
        private BiCallback targetBiCallback;

        public Map(@NonNull BiCallback targetBiCallback) {
            Utils.checkNullPointer(targetBiCallback, "targetBiCallback");
            this.targetBiCallback = targetBiCallback;
        }

        @Override
        public void onSuccess(@NonNull RouterResult result, @NonNull T t) {
            try {
                this.targetBiCallback.onSuccess(result, Utils.checkNullPointer(this.apply(t), "apply(t)"));
            }
            catch (Exception e) {
                this.targetBiCallback.onError(new RouterErrorResult(e));
            }
        }

        @Override
        public void onCancel(@Nullable RouterRequest originalRequest) {
            this.targetBiCallback.onCancel(originalRequest);
        }

        @Override
        public void onError(@NonNull RouterErrorResult errorResult) {
            this.targetBiCallback.onError(errorResult);
        }
    }
}

