/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.xiaojinzi.component.BaseHostProcessor;
import com.xiaojinzi.component.ComponentUtil;
import com.xiaojinzi.component.Utils;
import com.xiaojinzi.component.anno.ConditionalAnno;
import com.xiaojinzi.component.anno.ServiceAnno;
import com.xiaojinzi.component.anno.ServiceDecoratorAnno;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.collections4.CollectionUtils;

@SupportedOptions(value={"HOST"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"com.xiaojinzi.component.anno.ServiceAnno", "com.xiaojinzi.component.anno.ServiceDecoratorAnno"})
@AutoService(value={Processor.class})
public class ServiceProcessor
extends BaseHostProcessor {
    private static final String NAME_OF_APPLICATION = "application";
    private ClassName classNameServiceContainer;
    private ClassName lazyLoadClassName;
    private ClassName singletonLazyLoadClassName;
    private ClassName decoratorCallableClassName;
    private final AtomicInteger atomicInteger = new AtomicInteger();
    private final List<Element> serviceAnnoElementList = new ArrayList<Element>();
    private final Map<String, Element> serviceDecoratorAnnoElementList = new HashMap<String, Element>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        TypeElement typeElementServiceContainer = this.mElements.getTypeElement("com.xiaojinzi.component.impl.service.ServiceManager");
        this.classNameServiceContainer = ClassName.get((TypeElement)typeElementServiceContainer);
        TypeElement service1TypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.support.Callable");
        TypeElement service2TypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.support.SingletonCallable");
        TypeElement service3TypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.support.DecoratorCallable");
        this.lazyLoadClassName = ClassName.get((TypeElement)service1TypeElement);
        this.singletonLazyLoadClassName = ClassName.get((TypeElement)service2TypeElement);
        this.decoratorCallableClassName = ClassName.get((TypeElement)service3TypeElement);
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (this.componentModuleName == null || this.componentModuleName.isEmpty()) {
            return false;
        }
        if (CollectionUtils.isNotEmpty(set)) {
            Set<? extends Element> serviceAnnoElements = roundEnvironment.getElementsAnnotatedWith(ServiceAnno.class);
            Set<? extends Element> serviceDecoratorAnnoElements = roundEnvironment.getElementsAnnotatedWith(ServiceDecoratorAnno.class);
            this.parseServiceAnnotation(serviceAnnoElements);
            this.parseServiceDecoratorAnnotation(serviceDecoratorAnnoElements);
            this.createImpl();
            return true;
        }
        return false;
    }

    private void parseServiceAnnotation(Set<? extends Element> annoElements) {
        this.serviceAnnoElementList.clear();
        for (Element element : annoElements) {
            ServiceAnno anno = element.getAnnotation(ServiceAnno.class);
            if (anno == null) continue;
            List<String> classNames = this.getInterServiceClassNames(anno);
            if (anno.name().length != 0 && anno.name().length != classNames.size()) {
                throw new RuntimeException(element.getSimpleName() + " @ServiceAnno: The length of name[] must equal to the length of value[] when length > 0");
            }
            this.serviceAnnoElementList.add(element);
        }
    }

    private void parseServiceDecoratorAnnotation(Set<? extends Element> annoElements) {
        this.serviceDecoratorAnnoElementList.clear();
        for (Element element : annoElements) {
            ServiceDecoratorAnno anno = element.getAnnotation(ServiceDecoratorAnno.class);
            if (anno == null) continue;
            this.serviceDecoratorAnnoElementList.put(UUID.randomUUID().toString(), element);
        }
    }

    private void createImpl() {
        String claName = ComponentUtil.genHostServiceClassName((String)this.componentModuleName);
        String pkg = claName.substring(0, claName.lastIndexOf(46));
        String cn = claName.substring(claName.lastIndexOf(46) + 1);
        ClassName superClass = ClassName.get((TypeElement)this.mElements.getTypeElement("com.xiaojinzi.component.impl.service.ModuleServiceImpl"));
        MethodSpec initHostMethod = this.generateInitHostMethod();
        MethodSpec onCreateMethod = this.generateOnCreateMethod();
        MethodSpec onDestroyMethod = this.generateOnDestroyMethod();
        TypeSpec typeSpec = TypeSpec.classBuilder((String)cn).addAnnotation(this.mClassNameKeep).addAnnotation(this.mClassNameComponentGeneratedAnno).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.FINAL}).superclass((TypeName)superClass).addMethod(initHostMethod).addMethod(onCreateMethod).addMethod(onDestroyMethod).build();
        try {
            JavaFile.builder((String)pkg, (TypeSpec)typeSpec).indent("    ").build().writeTo(this.mFiler);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private MethodSpec generateOnCreateMethod() {
        TypeName returnType = TypeName.VOID;
        ClassName applicationName = ClassName.get((TypeElement)this.mElements.getTypeElement("android.app.Application"));
        ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)applicationName, (String)NAME_OF_APPLICATION, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).build();
        final MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"onCreate").returns(returnType).addAnnotation(Override.class).addParameter(parameterSpec).addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodSpecBuilder.addStatement("super.onCreate(application)", new Object[0]);
        for (Map.Entry<String, Element> entry : this.serviceDecoratorAnnoElementList.entrySet()) {
            String serviceImplClassName = entry.getValue().toString();
            TypeMirror serviceDecoratorImplTypeMirror = this.mElements.getTypeElement(serviceImplClassName).asType();
            TypeName serviceDecoratorImplTypeName = TypeName.get((TypeMirror)serviceDecoratorImplTypeMirror);
            ServiceDecoratorAnno anno = entry.getValue().getAnnotation(ServiceDecoratorAnno.class);
            ConditionalAnno conditionalAnno = entry.getValue().getAnnotation(ConditionalAnno.class);
            boolean isHaveConditional = false;
            if (conditionalAnno != null) {
                StringBuffer conditionsSB = new StringBuffer();
                List<String> conditionsImplClassNames = this.getConditionsImplClassName(conditionalAnno);
                ArrayList<Object> conditionsArgs = new ArrayList<Object>(2 * conditionsImplClassNames.size());
                Utils.generateCondition(this.mElements, this.mConditionCacheTypeElement, conditionsSB, conditionsArgs, conditionsImplClassNames);
                methodSpecBuilder.beginControlFlow("if(" + conditionsSB.toString() + ")", conditionsArgs.toArray());
                isHaveConditional = true;
            }
            String implName = "implName" + this.atomicInteger.incrementAndGet();
            String implClassStr = this.getInterServiceClassNames(anno);
            ClassName decoratorInterfaceClassName = ClassName.get((TypeElement)this.mElements.getTypeElement(implClassStr));
            String serviceDecoratorName = "serviceDecorator" + this.atomicInteger.incrementAndGet();
            MethodSpec.Builder priorityMethodBuilder = MethodSpec.methodBuilder((String)"priority").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
            priorityMethodBuilder.addStatement("return $L", new Object[]{anno.priority()}).returns(Integer.TYPE);
            MethodSpec.Builder getMethodBuilder = MethodSpec.methodBuilder((String)"get").addParameter((TypeName)decoratorInterfaceClassName, "target", new Modifier[0]).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
            getMethodBuilder.addStatement("$T $N = new $T(target)", new Object[]{serviceDecoratorImplTypeName, serviceDecoratorName, serviceDecoratorImplTypeName});
            getMethodBuilder.addStatement("return $N", new Object[]{serviceDecoratorName}).returns((TypeName)decoratorInterfaceClassName);
            TypeSpec innerTypeSpec = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)this.decoratorCallableClassName, (TypeName[])new TypeName[]{decoratorInterfaceClassName})).addMethod(getMethodBuilder.build()).addMethod(priorityMethodBuilder.build()).build();
            methodSpecBuilder.addStatement("$T $N = $L", new Object[]{this.decoratorCallableClassName, implName, innerTypeSpec});
            methodSpecBuilder.addStatement("$T.registerDecorator($T.class, $S, $N)", new Object[]{this.classNameServiceContainer, decoratorInterfaceClassName, entry.getKey(), implName});
            if (!isHaveConditional) continue;
            methodSpecBuilder.endControlFlow();
        }
        this.serviceAnnoElementList.forEach(new Consumer<Element>(){

            @Override
            public void accept(Element element) {
                String serviceImplCallPath = null;
                TypeMirror serviceImplTypeMirror = null;
                TypeName serviceImplTypeName = null;
                boolean isMethodParameterEmpty = false;
                if (element instanceof ExecutableElement) {
                    ExecutableElement methodElement = (ExecutableElement)element;
                    serviceImplTypeMirror = methodElement.getReturnType();
                    serviceImplTypeName = TypeName.get((TypeMirror)serviceImplTypeMirror);
                    isMethodParameterEmpty = methodElement.getParameters().size() == 0;
                    TypeElement declareClassType = (TypeElement)methodElement.getEnclosingElement();
                    serviceImplCallPath = declareClassType.toString() + "." + methodElement.getSimpleName();
                } else {
                    String serviceImplClassName = element.toString();
                    serviceImplTypeMirror = ServiceProcessor.this.mElements.getTypeElement(serviceImplClassName).asType();
                    serviceImplTypeName = TypeName.get((TypeMirror)serviceImplTypeMirror);
                }
                ServiceAnno anno = element.getAnnotation(ServiceAnno.class);
                String implName = "implName" + ServiceProcessor.this.atomicInteger.incrementAndGet();
                MethodSpec.Builder getOrRawMethodBuilder = MethodSpec.methodBuilder((String)(anno.singleTon() ? "getRaw" : "get")).addAnnotation(Override.class).addModifiers(new Modifier[]{anno.singleTon() ? Modifier.PROTECTED : Modifier.PUBLIC});
                String serviceName = "service" + ServiceProcessor.this.atomicInteger.incrementAndGet();
                if (serviceImplCallPath == null) {
                    boolean haveDefaultConstructor = ServiceProcessor.this.isHaveDefaultConstructor(element.toString());
                    getOrRawMethodBuilder.addStatement("$T $N = new $T($N)", new Object[]{serviceImplTypeName, serviceName, serviceImplTypeName, haveDefaultConstructor ? "" : ServiceProcessor.NAME_OF_APPLICATION});
                } else {
                    getOrRawMethodBuilder.addStatement("$T $N = $N($N)", new Object[]{serviceImplTypeName, serviceName, serviceImplCallPath, isMethodParameterEmpty ? "" : ServiceProcessor.NAME_OF_APPLICATION});
                }
                getOrRawMethodBuilder.addStatement("return $N", new Object[]{serviceName}).returns(serviceImplTypeName);
                TypeSpec innerTypeSpec = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)(anno.singleTon() ? ServiceProcessor.this.singletonLazyLoadClassName : ServiceProcessor.this.lazyLoadClassName), (TypeName[])new TypeName[]{serviceImplTypeName})).addMethod(getOrRawMethodBuilder.build()).build();
                methodSpecBuilder.addStatement("$T $N = $L", new Object[]{ServiceProcessor.this.lazyLoadClassName, implName, innerTypeSpec});
                List interServiceClassNames = ServiceProcessor.this.getInterServiceClassNames(anno);
                boolean isUseOne = anno.name().length == 0;
                for (int i = 0; i < interServiceClassNames.size(); ++i) {
                    String name = isUseOne ? "" : anno.name()[i];
                    boolean isNameEmpty = name == null || "".equals(name);
                    String interServiceClassName = (String)interServiceClassNames.get(i);
                    ClassName implClassName = ClassName.get((TypeElement)ServiceProcessor.this.mElements.getTypeElement(interServiceClassName));
                    if (anno.autoInit()) {
                        if (isNameEmpty) {
                            methodSpecBuilder.addStatement("$T.registerAutoInit($T.class)", new Object[]{ServiceProcessor.this.classNameServiceContainer, implClassName});
                        } else {
                            methodSpecBuilder.addStatement("$T.registerAutoInit($T.class, $S)", new Object[]{ServiceProcessor.this.classNameServiceContainer, implClassName, name});
                        }
                    }
                    if (isNameEmpty) {
                        methodSpecBuilder.addStatement("$T.register($T.class, $N)", new Object[]{ServiceProcessor.this.classNameServiceContainer, implClassName, implName});
                        continue;
                    }
                    methodSpecBuilder.addStatement("$T.register($T.class, $S, $N)", new Object[]{ServiceProcessor.this.classNameServiceContainer, implClassName, name, implName});
                }
            }
        });
        return methodSpecBuilder.build();
    }

    private MethodSpec generateOnDestroyMethod() {
        TypeName returnType = TypeName.VOID;
        final MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"onDestroy").returns(returnType).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodSpecBuilder.addStatement("super.onDestroy()", new Object[0]);
        for (Map.Entry<String, Element> entry : this.serviceDecoratorAnnoElementList.entrySet()) {
            ServiceDecoratorAnno anno = entry.getValue().getAnnotation(ServiceDecoratorAnno.class);
            ClassName interServiceClassName = ClassName.get((TypeElement)this.mElements.getTypeElement(this.getInterServiceClassNames(anno)));
            methodSpecBuilder.addStatement("$T.unregisterDecorator($T.class, $S)", new Object[]{this.classNameServiceContainer, interServiceClassName, entry.getKey()});
        }
        this.serviceAnnoElementList.forEach(new Consumer<Element>(){

            @Override
            public void accept(Element element) {
                ServiceAnno anno = element.getAnnotation(ServiceAnno.class);
                List interServiceClassNames = ServiceProcessor.this.getInterServiceClassNames(anno);
                boolean isUseOne = anno.name().length == 0;
                for (int i = 0; i < interServiceClassNames.size(); ++i) {
                    String name = isUseOne ? "" : anno.name()[i];
                    boolean isNameEmpty = name == null || "".equals(name);
                    String interServiceClassNameStr = (String)interServiceClassNames.get(i);
                    ClassName interServiceClassName = ClassName.get((TypeElement)ServiceProcessor.this.mElements.getTypeElement(interServiceClassNameStr));
                    if (anno.autoInit()) {
                        methodSpecBuilder.addStatement("$T.unregisterAutoInit($T.class)", new Object[]{ServiceProcessor.this.classNameServiceContainer, interServiceClassName});
                    }
                    if (isNameEmpty) {
                        methodSpecBuilder.addStatement("$T.unregister($T.class)", new Object[]{ServiceProcessor.this.classNameServiceContainer, interServiceClassName});
                        continue;
                    }
                    methodSpecBuilder.addStatement("$T.unregister($T.class, $S)", new Object[]{ServiceProcessor.this.classNameServiceContainer, interServiceClassName, name});
                }
            }
        });
        return methodSpecBuilder.build();
    }

    private MethodSpec generateInitHostMethod() {
        TypeName returnType = TypeName.get((TypeMirror)this.mTypeElementString.asType());
        MethodSpec.Builder openUriMethodSpecBuilder = MethodSpec.methodBuilder((String)"getHost").returns(returnType).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        openUriMethodSpecBuilder.addStatement("return $S", new Object[]{this.componentModuleName});
        return openUriMethodSpecBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getInterServiceClassNames(ServiceAnno anno) {
        ArrayList<String> implClassNames = new ArrayList<String>();
        try {
            void var6_10;
            Class[] classes;
            implClassNames.clear();
            Class[] classArray = classes = anno.value();
            int n = classArray.length;
            boolean bl = false;
            while (var6_10 < n) {
                Class clazz = classArray[var6_10];
                implClassNames.add(clazz.getName());
                ++var6_10;
            }
        }
        catch (MirroredTypesException e) {
            implClassNames.clear();
            List<? extends TypeMirror> typeMirrors = e.getTypeMirrors();
            for (TypeMirror typeMirror : typeMirrors) {
                implClassNames.add(typeMirror.toString());
            }
        }
        return implClassNames;
    }

    private String getInterServiceClassNames(ServiceDecoratorAnno anno) {
        try {
            return anno.value().getName();
        }
        catch (MirroredTypesException e) {
            List<? extends TypeMirror> typeMirrors = e.getTypeMirrors();
            return typeMirrors.get(0).toString();
        }
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getConditionsImplClassName(ConditionalAnno anno) {
        ArrayList<String> implClassNames = new ArrayList<String>();
        try {
            void var6_10;
            Class[] interceptors;
            implClassNames.clear();
            Class[] classArray = interceptors = anno.conditions();
            int n = classArray.length;
            boolean bl = false;
            while (var6_10 < n) {
                Class interceptor = classArray[var6_10];
                implClassNames.add(interceptor.getName());
                ++var6_10;
            }
        }
        catch (MirroredTypesException e) {
            implClassNames.clear();
            List<? extends TypeMirror> typeMirrors = e.getTypeMirrors();
            for (TypeMirror typeMirror : typeMirrors) {
                implClassNames.add(typeMirror.toString());
            }
        }
        return implClassNames;
    }

    private boolean isHaveDefaultConstructor(String className) {
        TypeElement typeElementClassImpl = this.mElements.getTypeElement(className);
        String constructorName = typeElementClassImpl.getSimpleName().toString() + "()";
        List<? extends Element> enclosedElements = typeElementClassImpl.getEnclosedElements();
        for (Element element : enclosedElements) {
            if (!element.toString().equals(constructorName)) continue;
            return true;
        }
        return false;
    }
}

