/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.xiaojinzi.component.BaseProcessor;
import com.xiaojinzi.component.ProcessException;
import com.xiaojinzi.component.anno.ParameterAnno;
import com.xiaojinzi.component.anno.router.AfterActionAnno;
import com.xiaojinzi.component.anno.router.AfterErrorActionAnno;
import com.xiaojinzi.component.anno.router.AfterEventActionAnno;
import com.xiaojinzi.component.anno.router.AfterStartActionAnno;
import com.xiaojinzi.component.anno.router.BeforeActionAnno;
import com.xiaojinzi.component.anno.router.BeforeStartActionAnno;
import com.xiaojinzi.component.anno.router.CategoryAnno;
import com.xiaojinzi.component.anno.router.FlagAnno;
import com.xiaojinzi.component.anno.router.HostAndPathAnno;
import com.xiaojinzi.component.anno.router.HostAnno;
import com.xiaojinzi.component.anno.router.NavigateAnno;
import com.xiaojinzi.component.anno.router.OptionsAnno;
import com.xiaojinzi.component.anno.router.PathAnno;
import com.xiaojinzi.component.anno.router.RequestCodeAnno;
import com.xiaojinzi.component.anno.router.RouterApiAnno;
import com.xiaojinzi.component.anno.router.UseInteceptorAnno;
import com.xiaojinzi.component.anno.router.UserInfoAnno;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypesException;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.collections4.CollectionUtils;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"com.xiaojinzi.component.anno.router.RouterApiAnno"})
@AutoService(value={Processor.class})
public class RouterApiProcessor
extends BaseProcessor {
    @Nullable
    private TypeElement continuationTypeElement;
    private TypeMirror continuationTypeMirror;
    private TypeMirror continuationErasureTypeMirror;
    private TypeElement charsequenceTypeElement;
    private TypeMirror charsequenceTypeMirror;
    private TypeName charsequenceTypeName;
    private TypeElement routerTypeElement;
    private TypeElement navigationDisposableTypeElement;
    private TypeMirror navigationDisposableTypeMirror;
    private TypeElement callBackTypeElement;
    private TypeMirror callBackTypeMirror;
    private TypeElement biCallBackTypeElement;
    private TypeMirror biCallBackTypeMirror;
    private TypeMirror biCallBackErasureTypeMirror;
    private TypeMirror callTypeMirror;
    private TypeElement routerRxTypeElement;
    private TypeMirror completableMirror;
    private TypeMirror singleMirror;
    private TypeMirror singleErasureMirror;
    private TypeMirror navigatorTypeMirror;
    private TypeMirror contextTypeMirror;
    private TypeMirror fragmentTypeMirror;
    private TypeMirror serializableTypeMirror;
    private TypeMirror parcelableTypeMirror;
    private TypeMirror bundleTypeMirror;
    private ParameterizedTypeName intentComsumerParameterizedTypeName;
    private Set<TypeElement> mRouteApiElements = new HashSet<TypeElement>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        TypeElement completableTypeElement = this.mElements.getTypeElement("io.reactivex.Completable");
        TypeElement singleTypeElement = this.mElements.getTypeElement("io.reactivex.Single");
        this.completableMirror = completableTypeElement == null ? null : completableTypeElement.asType();
        this.singleMirror = singleTypeElement == null ? null : singleTypeElement.asType();
        this.singleErasureMirror = this.singleMirror == null ? null : this.processingEnv.getTypeUtils().erasure(this.singleMirror);
        this.continuationTypeElement = this.mElements.getTypeElement("kotlin.coroutines.Continuation");
        if (this.continuationTypeElement != null) {
            this.continuationTypeMirror = this.continuationTypeElement.asType();
        }
        if (this.continuationTypeMirror != null) {
            this.continuationErasureTypeMirror = this.processingEnv.getTypeUtils().erasure(this.continuationTypeMirror);
        }
        this.charsequenceTypeElement = this.mElements.getTypeElement("java.lang.CharSequence");
        this.charsequenceTypeMirror = this.charsequenceTypeElement.asType();
        this.charsequenceTypeName = TypeName.get((TypeMirror)this.charsequenceTypeMirror);
        this.routerTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.impl.Router");
        this.routerRxTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.impl.RxRouter");
        this.navigationDisposableTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.support.NavigationDisposable");
        this.navigationDisposableTypeMirror = this.navigationDisposableTypeElement.asType();
        this.callBackTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.impl.Callback");
        this.callBackTypeMirror = this.callBackTypeElement.asType();
        this.biCallBackTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.impl.BiCallback");
        this.biCallBackTypeMirror = this.biCallBackTypeElement.asType();
        this.biCallBackErasureTypeMirror = this.processingEnv.getTypeUtils().erasure(this.biCallBackTypeMirror);
        this.callTypeMirror = this.mElements.getTypeElement("com.xiaojinzi.component.impl.Call").asType();
        this.navigatorTypeMirror = this.mElements.getTypeElement("com.xiaojinzi.component.impl.Navigator").asType();
        TypeElement contextTypeElement = this.mElements.getTypeElement("android.content.Context");
        this.contextTypeMirror = contextTypeElement.asType();
        TypeElement fragmentTypeElement = this.mElements.getTypeElement("android.support.v4.app.Fragment");
        this.fragmentTypeMirror = fragmentTypeElement.asType();
        TypeElement serializableTypeElement = this.mElements.getTypeElement("java.io.Serializable");
        this.serializableTypeMirror = serializableTypeElement.asType();
        TypeElement parcelableTypeElement = this.mElements.getTypeElement("android.os.Parcelable");
        this.parcelableTypeMirror = parcelableTypeElement.asType();
        TypeElement bundleTypeElement = this.mElements.getTypeElement("android.os.Bundle");
        this.bundleTypeMirror = bundleTypeElement.asType();
        this.intentComsumerParameterizedTypeName = ParameterizedTypeName.get((ClassName)ClassName.get((TypeElement)this.mElements.getTypeElement("com.xiaojinzi.component.support.Consumer")), (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.mElements.getTypeElement("android.content.Intent").asType())});
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (CollectionUtils.isNotEmpty(set)) {
            Set<? extends Element> routeApiElements = roundEnvironment.getElementsAnnotatedWith(RouterApiAnno.class);
            this.parseAnno(routeApiElements);
            this.createRouterApiImpls();
            return true;
        }
        return false;
    }

    private void parseAnno(Set<? extends Element> routeApiElements) {
        for (Element element : routeApiElements) {
            if (!(element instanceof TypeElement)) continue;
            this.mRouteApiElements.add((TypeElement)element);
        }
    }

    private void createRouterApiImpls() {
        for (TypeElement routeApiElement : this.mRouteApiElements) {
            this.createRouterApiImpl(routeApiElement);
        }
    }

    private void createRouterApiImpl(TypeElement typeElement) {
        HostAnno hostAnnotation = typeElement.getAnnotation(HostAnno.class);
        String defaultHost = hostAnnotation == null ? null : hostAnnotation.value();
        String claName = typeElement.getQualifiedName().toString() + "RouterApiGenerated";
        String pkg = claName.substring(0, claName.lastIndexOf(46));
        String cn = claName.substring(claName.lastIndexOf(46) + 1);
        ClassName superClass = ClassName.get((TypeElement)typeElement);
        TypeSpec.Builder typeSpecBuilder = TypeSpec.classBuilder((String)cn).addAnnotation(this.mClassNameKeep).addAnnotation(this.mClassNameComponentGeneratedAnno).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.FINAL}).addSuperinterface((TypeName)superClass);
        this.implementInterfaceMethods(typeSpecBuilder, typeElement, defaultHost);
        try {
            JavaFile.builder((String)pkg, (TypeSpec)typeSpecBuilder.build()).indent("    ").build().writeTo(this.mFiler);
        }
        catch (IOException e) {
            throw new ProcessException(e);
        }
    }

    private void implementInterfaceMethods(TypeSpec.Builder typeSpecBuilder, TypeElement apiTypeElement, String defaultHost) {
        List<? extends Element> enclosedElements = apiTypeElement.getEnclosedElements();
        for (Element element : enclosedElements) {
            if (!(element instanceof ExecutableElement)) continue;
            this.implementInterfaceMethod(typeSpecBuilder, (ExecutableElement)element, defaultHost);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void implementInterfaceMethod(TypeSpec.Builder typeSpecBuilder, ExecutableElement executableElement, String defaultHost) {
        String methodPath = executableElement.getEnclosingElement().getSimpleName() + "#" + executableElement.getSimpleName();
        UserInfoAnno userInfoAnnotation = executableElement.getAnnotation(UserInfoAnno.class);
        HostAnno hostAnnotation = executableElement.getAnnotation(HostAnno.class);
        PathAnno pathAnnotation = executableElement.getAnnotation(PathAnno.class);
        HostAndPathAnno hostAndPathAnnotation = executableElement.getAnnotation(HostAndPathAnno.class);
        NavigateAnno navigateAnnotation = executableElement.getAnnotation(NavigateAnno.class);
        UseInteceptorAnno useInteceptorAnnotation = executableElement.getAnnotation(UseInteceptorAnno.class);
        RequestCodeAnno requestCodeAnnotation = executableElement.getAnnotation(RequestCodeAnno.class);
        FlagAnno flagAnnotation = executableElement.getAnnotation(FlagAnno.class);
        CategoryAnno categoryAnnotation = executableElement.getAnnotation(CategoryAnno.class);
        String userInfo = userInfoAnnotation == null ? null : userInfoAnnotation.value();
        String host = hostAnnotation == null ? defaultHost : hostAnnotation.value();
        String path = pathAnnotation == null ? null : pathAnnotation.value();
        String hostAndPath = hostAndPathAnnotation == null ? null : hostAndPathAnnotation.value();
        boolean isReturnNavigationDisposable = false;
        boolean isReturnCall = false;
        boolean isReturnObservable = false;
        boolean isReturnCompletable = false;
        boolean isReturnSingle = false;
        boolean isReturnCoroutines = false;
        TypeMirror returnType = executableElement.getReturnType();
        isReturnNavigationDisposable = this.navigationDisposableTypeMirror.equals(returnType);
        isReturnCall = this.callTypeMirror.equals(returnType) || this.navigatorTypeMirror.equals(returnType);
        isReturnCompletable = returnType == null ? false : returnType.equals(this.completableMirror);
        isReturnSingle = returnType == null ? false : this.processingEnv.getTypeUtils().erasure(returnType).equals(this.singleErasureMirror);
        isReturnObservable = isReturnCompletable || isReturnSingle;
        Name methodName = executableElement.getSimpleName();
        List<? extends VariableElement> parameters = executableElement.getParameters();
        MethodSpec.Builder methodBuilder = MethodSpec.methodBuilder((String)methodName.toString()).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns(TypeName.get((TypeMirror)returnType));
        VariableElement continuationParameter = null;
        VariableElement contextParameter = null;
        VariableElement fragmentParameter = null;
        VariableElement callBackParameter = null;
        VariableElement biCallBackParameter = null;
        VariableElement requestCodeParameter = null;
        VariableElement activityBundleOptionsParameter = null;
        VariableElement intentConsumerParameter = null;
        VariableElement beforeActionParameter = null;
        VariableElement beforeStartActionParameter = null;
        VariableElement afterStartActionParameter = null;
        VariableElement afterActionParameter = null;
        VariableElement afterErrorActionParameter = null;
        VariableElement afterEventActionParameter = null;
        StringBuffer parameterStatement = new StringBuffer();
        ArrayList<String> parameterArgs = new ArrayList<String>();
        for (VariableElement variableElement : parameters) {
            TypeMirror parameterTypeMirror = variableElement.asType();
            if (this.mTypes.isSubtype(this.processingEnv.getTypeUtils().erasure(parameterTypeMirror), this.continuationErasureTypeMirror)) {
                continuationParameter = variableElement;
                isReturnCoroutines = true;
            } else if (this.mTypes.isSubtype(parameterTypeMirror, this.contextTypeMirror)) {
                contextParameter = variableElement;
            } else if (this.mTypes.isSubtype(parameterTypeMirror, this.fragmentTypeMirror)) {
                fragmentParameter = variableElement;
            } else if (this.mTypes.isSubtype(parameterTypeMirror, this.callBackTypeMirror)) {
                callBackParameter = variableElement;
            } else if (this.mTypes.isSubtype(this.processingEnv.getTypeUtils().erasure(parameterTypeMirror), this.biCallBackErasureTypeMirror)) {
                biCallBackParameter = variableElement;
            } else if (variableElement.getAnnotation(RequestCodeAnno.class) != null) {
                requestCodeParameter = variableElement;
            } else if (variableElement.getAnnotation(OptionsAnno.class) != null) {
                activityBundleOptionsParameter = variableElement;
            } else if (this.intentComsumerParameterizedTypeName.equals((Object)TypeName.get((TypeMirror)parameterTypeMirror))) {
                intentConsumerParameter = variableElement;
            } else if (variableElement.getAnnotation(BeforeActionAnno.class) != null) {
                beforeActionParameter = variableElement;
            } else if (variableElement.getAnnotation(BeforeStartActionAnno.class) != null) {
                beforeStartActionParameter = variableElement;
            } else if (variableElement.getAnnotation(AfterStartActionAnno.class) != null) {
                afterStartActionParameter = variableElement;
            } else if (variableElement.getAnnotation(AfterActionAnno.class) != null) {
                afterActionParameter = variableElement;
            } else if (variableElement.getAnnotation(AfterErrorActionAnno.class) != null) {
                afterErrorActionParameter = variableElement;
            } else if (variableElement.getAnnotation(AfterEventActionAnno.class) != null) {
                afterEventActionParameter = variableElement;
            } else if (parameterTypeMirror.equals(this.bundleTypeMirror)) {
                ParameterAnno parameterAnno = variableElement.getAnnotation(ParameterAnno.class);
                if (parameterAnno == null) {
                    parameterStatement.append("\n.putAll($N)");
                } else {
                    parameterStatement.append("\n.putBundle($S,$N)");
                    parameterArgs.add(parameterAnno.value());
                }
                parameterArgs.add(variableElement.getSimpleName().toString());
            } else {
                ParameterAnno parameterAnno = variableElement.getAnnotation(ParameterAnno.class);
                if (parameterAnno == null) {
                    throw new ProcessException("do you forget to add @ParameterAnno to you parameter(" + methodPath + "#" + variableElement.getSimpleName().toString() + ")?");
                }
                TypeName parameterTypeName = TypeName.get((TypeMirror)parameterTypeMirror);
                if (parameterTypeName.equals((Object)this.mTypeNameString)) {
                    parameterStatement.append("\n.putString($S,$N)");
                } else if (parameterTypeName.equals((Object)this.charsequenceTypeName)) {
                    parameterStatement.append("\n.putCharSequence($S,$N)");
                } else if (parameterTypeName.equals((Object)ClassName.BYTE) || parameterTypeName.equals((Object)ClassName.BYTE.box())) {
                    parameterStatement.append("\n.putByte($S,$N)");
                } else if (parameterTypeName.equals((Object)ClassName.CHAR) || parameterTypeName.equals((Object)ClassName.CHAR.box())) {
                    parameterStatement.append("\n.putChar($S,$N)");
                } else if (parameterTypeName.equals((Object)ClassName.SHORT) || parameterTypeName.equals((Object)ClassName.SHORT.box())) {
                    parameterStatement.append("\n.putShort($S,$N)");
                } else if (parameterTypeName.equals((Object)ClassName.INT) || parameterTypeName.equals((Object)ClassName.INT.box())) {
                    parameterStatement.append("\n.putInt($S,$N)");
                } else if (parameterTypeName.equals((Object)ClassName.LONG) || parameterTypeName.equals((Object)ClassName.LONG.box())) {
                    parameterStatement.append("\n.putLong($S,$N)");
                } else if (parameterTypeName.equals((Object)ClassName.FLOAT) || parameterTypeName.equals((Object)ClassName.FLOAT.box())) {
                    parameterStatement.append("\n.putFloat($S,$N)");
                } else if (parameterTypeName.equals((Object)ClassName.DOUBLE) || parameterTypeName.equals((Object)ClassName.DOUBLE.box())) {
                    parameterStatement.append("\n.putDouble($S,$N)");
                } else if (parameterTypeName.equals((Object)ClassName.BOOLEAN) || parameterTypeName.equals((Object)ClassName.BOOLEAN.box())) {
                    parameterStatement.append("\n.putBoolean($S,$N)");
                } else if (parameterTypeMirror instanceof DeclaredType) {
                    List<? extends TypeMirror> typeArguments;
                    DeclaredType declaredType = (DeclaredType)parameterTypeMirror;
                    if (this.mTypeElementArrayList.asType().equals(declaredType.asElement().asType())) {
                        typeArguments = declaredType.getTypeArguments();
                        if (typeArguments.size() != 1) throw new ProcessException("can't to resolve unknow type parameter(" + methodPath + "#" + variableElement.getSimpleName().toString() + ")");
                        if (this.mTypeElementString.asType().equals(typeArguments.get(0))) {
                            parameterStatement.append("\n.putStringArrayList($S,$N)");
                        } else if (this.mTypeElementInteger.asType().equals(typeArguments.get(0))) {
                            parameterStatement.append("\n.putIntegerArrayList($S,$N)");
                        } else if (this.mTypes.isSubtype(typeArguments.get(0), this.parcelableTypeMirror)) {
                            parameterStatement.append("\n.putParcelableArrayList($S,$N)");
                        } else if (this.mTypes.isSubtype(typeArguments.get(0), this.serializableTypeMirror)) {
                            parameterStatement.append("\n.putSerializable($S,$N)");
                        } else {
                            if (!this.charsequenceTypeMirror.equals(typeArguments.get(0))) throw new ProcessException("can't to resolve unknow type parameter(" + methodPath + "#" + variableElement.getSimpleName().toString() + ")");
                            parameterStatement.append("\n.putCharSequenceArrayList($S,$N)");
                        }
                    } else if (this.mTypeElementSparseArray.asType().equals(declaredType.asElement().asType())) {
                        typeArguments = declaredType.getTypeArguments();
                        if (!this.mTypes.isSubtype(typeArguments.get(0), this.parcelableTypeMirror)) throw new ProcessException("can't to resolve unknow type parameter(" + methodPath + "#" + variableElement.getSimpleName().toString() + ")");
                        parameterStatement.append("\n.putSparseParcelableArray($S,$N)");
                    } else if (this.mTypes.isSubtype(parameterTypeMirror, this.parcelableTypeMirror)) {
                        parameterStatement.append("\n.putParcelable($S,$N)");
                    } else {
                        if (!this.mTypes.isSubtype(parameterTypeMirror, this.serializableTypeMirror)) throw new ProcessException("can't to resolve unknow type parameter(" + methodPath + "#" + variableElement.getSimpleName().toString() + ")");
                        parameterStatement.append("\n.putSerializable($S,$N)");
                    }
                } else {
                    if (!(parameterTypeMirror instanceof ArrayType)) throw new ProcessException("can't to resolve unknow type parameter(" + methodPath + "#" + variableElement.getSimpleName().toString() + ")");
                    ArrayType parameterArrayType = (ArrayType)parameterTypeMirror;
                    TypeName parameterComponentTypeName = ClassName.get((TypeMirror)parameterArrayType.getComponentType());
                    if (parameterArrayType.getComponentType().equals(this.mTypeElementString.asType())) {
                        parameterStatement.append("\n.putStringArray($S,$N)");
                    } else if (parameterArrayType.getComponentType().equals(this.charsequenceTypeElement.asType())) {
                        parameterStatement.append("\n.putCharSequenceArray($S,$N)");
                    } else if (parameterArrayType.getComponentType().equals(this.mTypeElementString.asType())) {
                        parameterStatement.append("\n.putStringArray($S,$N)");
                    } else if (parameterComponentTypeName.equals((Object)ClassName.BYTE) || parameterComponentTypeName.equals((Object)ClassName.BYTE.box())) {
                        parameterStatement.append("\n.putByteArray($S,$N)");
                    } else if (parameterComponentTypeName.equals((Object)ClassName.CHAR) || parameterComponentTypeName.equals((Object)ClassName.CHAR.box())) {
                        parameterStatement.append("\n.putCharArray($S,$N)");
                    } else if (parameterComponentTypeName.equals((Object)ClassName.SHORT) || parameterComponentTypeName.equals((Object)ClassName.SHORT.box())) {
                        parameterStatement.append("\n.putShortArray($S,$N)");
                    } else if (parameterComponentTypeName.equals((Object)ClassName.INT) || parameterComponentTypeName.equals((Object)ClassName.INT.box())) {
                        parameterStatement.append("\n.putIntArray($S,$N)");
                    } else if (parameterComponentTypeName.equals((Object)ClassName.LONG) || parameterComponentTypeName.equals((Object)ClassName.LONG.box())) {
                        parameterStatement.append("\n.putLongArray($S,$N)");
                    } else if (parameterComponentTypeName.equals((Object)ClassName.FLOAT) || parameterComponentTypeName.equals((Object)ClassName.FLOAT.box())) {
                        parameterStatement.append("\n.putFloatArray($S,$N)");
                    } else if (parameterComponentTypeName.equals((Object)ClassName.DOUBLE) || parameterComponentTypeName.equals((Object)ClassName.DOUBLE.box())) {
                        parameterStatement.append("\n.putDoubleArray($S,$N)");
                    } else if (parameterComponentTypeName.equals((Object)ClassName.BOOLEAN) || parameterComponentTypeName.equals((Object)ClassName.BOOLEAN.box())) {
                        parameterStatement.append("\n.putBooleanArray($S,$N)");
                    } else {
                        if (!this.mTypes.isSubtype(parameterArrayType.getComponentType(), this.parcelableTypeMirror)) throw new ProcessException("can't to resolve unknow type parameter(" + methodPath + "#" + variableElement.getSimpleName().toString() + ")");
                        parameterStatement.append("\n.putParcelableArray($S,$N)");
                    }
                }
                parameterArgs.add(parameterAnno.value());
                parameterArgs.add(variableElement.getSimpleName().toString());
            }
            methodBuilder.addParameter(ParameterSpec.builder((TypeName)TypeName.get((TypeMirror)parameterTypeMirror), (String)variableElement.getSimpleName().toString(), (Modifier[])new Modifier[0]).build());
        }
        if (isReturnObservable) {
            if (this.routerRxTypeElement == null) {
                throw new ProcessException("you must use router-rx lib,such as \n 'com.github.xiaojinzi123.Component:component-impl-rx:<version>' \n get more info please view \n https://github.com/xiaojinzi123/Component/wiki/%E4%BE%9D%E8%B5%96%E5%92%8C%E9%85%8D%E7%BD%AE");
            }
            if (biCallBackParameter != null) {
                throw new ProcessException("the parameter " + biCallBackParameter.getSimpleName() + " of method " + methodPath + " is not allow when then returnType is " + "io.reactivex.Completable" + " or " + "io.reactivex.Single");
            }
            if (callBackParameter != null) {
                throw new ProcessException("the parameter " + callBackParameter.getSimpleName() + " of method " + methodPath + " is not allow when then returnType is " + "io.reactivex.Completable" + " or " + "io.reactivex.Single");
            }
            if (navigateAnnotation == null) {
                if (!isReturnCompletable) {
                    throw new ProcessException("the returnType of method (" + methodPath + ") must be " + "io.reactivex.Completable");
                }
            } else if (navigateAnnotation.forResult()) {
                if (!isReturnSingle) {
                    throw new ProcessException("the returnType of method (" + methodPath + ") must be " + "io.reactivex.Single" + "<ActivityResult>");
                }
            } else if (navigateAnnotation.forIntent()) {
                if (!isReturnSingle) {
                    throw new ProcessException("the returnType of method (" + methodPath + ") must be " + "io.reactivex.Single" + "<Intent>");
                }
            } else if (navigateAnnotation.forResultCode()) {
                if (!isReturnSingle) {
                    throw new ProcessException("the returnType of method (" + methodPath + ") must be " + "io.reactivex.Single" + "<Integer>");
                }
            } else if (!isReturnCompletable) {
                throw new ProcessException("the returnType of method (" + methodPath + ") must be " + "io.reactivex.Completable");
            }
        } else if (navigateAnnotation == null) {
            if (biCallBackParameter != null) {
                throw new ProcessException("the parameter " + biCallBackParameter.getSimpleName() + " of method " + methodPath + " is not allow here, do you forget add @NavigateAnno(forResult = true) or @NavigateAnno(forIntent = true) or @NavigateAnno(forResultCode = true) to method");
            }
        } else if (navigateAnnotation.forResult()) {
            if (biCallBackParameter == null && continuationParameter == null) {
                throw new ProcessException("do you forget to add parameter(com.xiaojinzi.component.impl.BiCallback<ActivityResult>) to you method(" + methodPath + ") or \n add suspend modifier  to you method(" + methodPath + ")\nsuch as: suspend fun test(context: Context): ActivityResult");
            }
        } else if (navigateAnnotation.forIntent()) {
            if (biCallBackParameter == null && continuationParameter == null) {
                throw new ProcessException("do you forget to add parameter(com.xiaojinzi.component.impl.BiCallback<Intent>) to you method(" + methodPath + ") or \n add suspend modifier  to you method(" + methodPath + ")\nsuch as: suspend fun test(context: Context): Intent");
            }
        } else if (navigateAnnotation.forResultCode()) {
            if (biCallBackParameter == null && continuationParameter == null) {
                throw new ProcessException("do you forget to add parameter(com.xiaojinzi.component.impl.BiCallback<Integer>) to you method(" + methodPath + ") or \n add suspend modifier  to you method(" + methodPath + ")\nsuch as: suspend fun test(context: Context): Int");
            }
        } else if (navigateAnnotation.resultCodeMatch() != Integer.MIN_VALUE && callBackParameter == null && continuationParameter == null) {
            throw new ProcessException("do you forget to add parameter(com.xiaojinzi.component.impl.Callback) to you method(" + methodPath + ") or \n add suspend modifier  to you method(" + methodPath + ")\nsuch as: suspend fun test(context: Context)");
        }
        StringBuffer routerStatement = new StringBuffer();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        routerStatement.append("$T.with($N)");
        if (isReturnObservable) {
            arrayList.add(this.routerRxTypeElement);
        } else {
            arrayList.add(this.routerTypeElement);
        }
        if (contextParameter != null) {
            arrayList.add(contextParameter.getSimpleName().toString());
        } else if (fragmentParameter != null) {
            arrayList.add(fragmentParameter.getSimpleName().toString());
        } else {
            arrayList.add("");
        }
        if (userInfo != null) {
            routerStatement.append("\n.userInfo($S)");
            arrayList.add(userInfo);
        }
        if (hostAndPath == null) {
            routerStatement.append("\n.host($S)");
            routerStatement.append("\n.path($S)");
            arrayList.add(host);
            arrayList.add(path);
        } else {
            routerStatement.append("\n.hostAndPath($S)");
            arrayList.add(hostAndPath);
        }
        routerStatement.append(parameterStatement.toString());
        arrayList.addAll(parameterArgs);
        if (requestCodeParameter != null) {
            TypeName requestCodeTypeName = TypeName.get((TypeMirror)requestCodeParameter.asType());
            if (!requestCodeTypeName.equals((Object)ClassName.INT) && !requestCodeTypeName.equals((Object)ClassName.INT.box())) throw new ProcessException("the class type of parameter(" + methodPath + "#" + requestCodeParameter.getSimpleName() + ") must be a int or Integer");
            routerStatement.append("\n.requestCode($N)");
            arrayList.add(requestCodeParameter.getSimpleName().toString());
        } else if (requestCodeAnnotation != null) {
            if (requestCodeAnnotation.value() == Integer.MIN_VALUE) {
                routerStatement.append("\n.requestCodeRandom()");
            } else {
                routerStatement.append("\n.requestCode($L)");
                arrayList.add(requestCodeAnnotation.value());
            }
        }
        if (useInteceptorAnnotation != null) {
            StringBuffer interceptorStatement = new StringBuffer();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (useInteceptorAnnotation.names().length > 0) {
                for (int i = 0; i < useInteceptorAnnotation.names().length; ++i) {
                    String interceptorName = useInteceptorAnnotation.names()[i];
                    if (i == 0) {
                        interceptorStatement.append("$S");
                    } else {
                        interceptorStatement.append(",").append("$S");
                    }
                    arrayList2.add(interceptorName);
                }
                routerStatement.append("\n.interceptorNames(" + interceptorStatement.toString() + ")");
                arrayList.addAll(arrayList2);
            }
            interceptorStatement.delete(0, interceptorStatement.length());
            arrayList2.clear();
            List<String> implClassName = this.getImplClassName(useInteceptorAnnotation);
            if (implClassName.size() > 0) {
                for (int i = 0; i < implClassName.size(); ++i) {
                    if (i == 0) {
                        interceptorStatement.append("$T.class");
                    } else {
                        interceptorStatement.append(",").append("$T.class");
                    }
                    arrayList2.add((String)ClassName.get((TypeElement)this.mElements.getTypeElement(implClassName.get(i))));
                }
                routerStatement.append("\n.interceptors(" + interceptorStatement.toString() + ")");
                arrayList.addAll(arrayList2);
            }
        }
        if (flagAnnotation != null) {
            int[] flags;
            for (int flag : flags = flagAnnotation.value()) {
                routerStatement.append("\n.addIntentFlags($L)");
                arrayList.add(flag);
            }
        }
        if (categoryAnnotation != null) {
            String[] categories;
            for (String category : categories = categoryAnnotation.value()) {
                routerStatement.append("\n.addIntentCategories($S)");
                arrayList.add(category);
            }
        }
        if (activityBundleOptionsParameter != null) {
            routerStatement.append("\n.options($N)");
            arrayList.add(activityBundleOptionsParameter.getSimpleName().toString());
        }
        if (intentConsumerParameter != null) {
            routerStatement.append("\n.intentConsumer($N)");
            arrayList.add(intentConsumerParameter.getSimpleName().toString());
        }
        if (beforeActionParameter != null) {
            routerStatement.append("\n.beforeAction($N)");
            arrayList.add(beforeActionParameter.getSimpleName().toString());
        }
        if (beforeStartActionParameter != null) {
            routerStatement.append("\n.beforeStartAction($N)");
            arrayList.add(beforeStartActionParameter.getSimpleName().toString());
        }
        if (afterStartActionParameter != null) {
            routerStatement.append("\n.afterStartAction($N)");
            arrayList.add(afterStartActionParameter.getSimpleName().toString());
        }
        if (afterActionParameter != null) {
            routerStatement.append("\n.afterAction($N)");
            arrayList.add(afterActionParameter.getSimpleName().toString());
        }
        if (afterErrorActionParameter != null) {
            routerStatement.append("\n.afterErrorAction($N)");
            arrayList.add(afterErrorActionParameter.getSimpleName().toString());
        }
        if (afterEventActionParameter != null) {
            routerStatement.append("\n.afterEventAction($N)");
            arrayList.add(afterEventActionParameter.getSimpleName().toString());
        }
        if (navigateAnnotation == null) {
            if (isReturnObservable) {
                routerStatement.append("\n.call()");
            } else if (isReturnCoroutines) {
                routerStatement.insert(0, "$N.await(");
                arrayList.add(0, "com.xiaojinzi.component.RouterExtendsKt");
                routerStatement.append(", $N)");
                arrayList.add(continuationParameter.getSimpleName().toString());
            } else if (!isReturnCall) {
                if (callBackParameter == null) {
                    routerStatement.append("\n.navigate()");
                } else {
                    routerStatement.append("\n.navigate($N)");
                    arrayList.add(callBackParameter.getSimpleName().toString());
                }
            }
        } else if (isReturnObservable) {
            if (navigateAnnotation.forResult()) {
                routerStatement.append("\n.activityResultCall()");
            } else if (navigateAnnotation.forIntent()) {
                if (navigateAnnotation.resultCodeMatch() == Integer.MIN_VALUE) {
                    routerStatement.append("\n.intentCall()");
                } else {
                    routerStatement.append("\n.intentResultCodeMatchCall($L)");
                    arrayList.add(navigateAnnotation.resultCodeMatch());
                }
            } else if (navigateAnnotation.forResultCode()) {
                routerStatement.append("\n.resultCodeCall()");
            } else if (navigateAnnotation.resultCodeMatch() == Integer.MIN_VALUE) {
                routerStatement.append("\n.call()");
            } else {
                routerStatement.append("\n.resultCodeMatchCall($L)");
                arrayList.add(navigateAnnotation.resultCodeMatch());
            }
        } else if (isReturnCoroutines) {
            if (navigateAnnotation.forResult()) {
                routerStatement.insert(0, "$N.activityResultAwait(\n");
                arrayList.add(0, "com.xiaojinzi.component.RouterExtendsKt");
                routerStatement.append(",\n $N\n)");
                arrayList.add(continuationParameter.getSimpleName().toString());
            } else if (navigateAnnotation.forIntent()) {
                if (navigateAnnotation.resultCodeMatch() == Integer.MIN_VALUE) {
                    routerStatement.insert(0, "$N.intentAwait(\n");
                    arrayList.add(0, "com.xiaojinzi.component.RouterExtendsKt");
                    routerStatement.append(",\n $N\n)");
                    arrayList.add(continuationParameter.getSimpleName().toString());
                } else {
                    routerStatement.insert(0, "$N.intentResultCodeMatchAwait(\n");
                    arrayList.add(0, "com.xiaojinzi.component.RouterExtendsKt");
                    routerStatement.append(",\n $L,\n $N\n)");
                    arrayList.add(navigateAnnotation.resultCodeMatch());
                    arrayList.add(continuationParameter.getSimpleName().toString());
                }
            } else if (navigateAnnotation.forResultCode()) {
                routerStatement.insert(0, "$N.resultCodeAwait(\n");
                arrayList.add(0, "com.xiaojinzi.component.RouterExtendsKt");
                routerStatement.append(",\n $N\n)");
                arrayList.add(continuationParameter.getSimpleName().toString());
            } else if (navigateAnnotation.resultCodeMatch() == Integer.MIN_VALUE) {
                routerStatement.insert(0, "$N.await(\n");
                arrayList.add(0, "com.xiaojinzi.component.RouterExtendsKt");
                routerStatement.append(",\n $N\n)");
                arrayList.add(continuationParameter.getSimpleName().toString());
            } else {
                routerStatement.insert(0, "$N.resultCodeMatchAwait(\n");
                arrayList.add(0, "com.xiaojinzi.component.RouterExtendsKt");
                routerStatement.append(",\n $L,\n $N\n)");
                arrayList.add(navigateAnnotation.resultCodeMatch());
                arrayList.add(continuationParameter.getSimpleName().toString());
            }
        } else if (navigateAnnotation.forResult()) {
            routerStatement.append("\n.navigateForResult($N)");
            arrayList.add(biCallBackParameter.getSimpleName().toString());
        } else if (navigateAnnotation.forIntent()) {
            if (navigateAnnotation.resultCodeMatch() == Integer.MIN_VALUE) {
                routerStatement.append("\n.navigateForIntent($N)");
                arrayList.add(biCallBackParameter.getSimpleName().toString());
            } else {
                routerStatement.append("\n.navigateForIntentAndResultCodeMatch($N,$L)");
                arrayList.add(biCallBackParameter.getSimpleName().toString());
                arrayList.add(navigateAnnotation.resultCodeMatch());
            }
        } else if (navigateAnnotation.forResultCode()) {
            routerStatement.append("\n.navigateForResultCode($N)");
            arrayList.add(biCallBackParameter.getSimpleName().toString());
        } else if (navigateAnnotation.resultCodeMatch() == Integer.MIN_VALUE) {
            if (callBackParameter == null) {
                routerStatement.append("\n.navigate()");
            } else {
                routerStatement.append("\n.navigate($N)");
                arrayList.add(callBackParameter.getSimpleName().toString());
            }
        } else {
            routerStatement.append("\n.navigateForResultCodeMatch($N,$L)");
            arrayList.add(callBackParameter.getSimpleName().toString());
            arrayList.add(navigateAnnotation.resultCodeMatch());
        }
        if (isReturnNavigationDisposable || isReturnCall || isReturnObservable || isReturnCoroutines) {
            routerStatement.insert(0, "return ");
        }
        methodBuilder.addStatement(routerStatement.toString(), arrayList.toArray());
        typeSpecBuilder.addMethod(methodBuilder.build());
    }

    /*
     * WARNING - void declaration
     */
    private List<String> getImplClassName(UseInteceptorAnno anno) {
        ArrayList<String> implClassNames = new ArrayList<String>();
        try {
            void var6_10;
            Class[] interceptors;
            implClassNames.clear();
            Class[] classArray = interceptors = anno.classes();
            int n = classArray.length;
            boolean bl = false;
            while (var6_10 < n) {
                Class interceptor = classArray[var6_10];
                implClassNames.add(interceptor.getName());
                ++var6_10;
            }
        }
        catch (MirroredTypesException e) {
            implClassNames.clear();
            List<? extends TypeMirror> typeMirrors = e.getTypeMirrors();
            for (TypeMirror typeMirror : typeMirrors) {
                implClassNames.add(typeMirror.toString());
            }
        }
        return implClassNames;
    }
}

