/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.xiaojinzi.component.BaseHostProcessor;
import com.xiaojinzi.component.ComponentUtil;
import com.xiaojinzi.component.ProcessException;
import com.xiaojinzi.component.anno.ModuleAppAnno;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.collections4.CollectionUtils;

@SupportedOptions(value={"HOST"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"com.xiaojinzi.component.anno.ModuleAppAnno"})
@AutoService(value={Processor.class})
public class ModuleAppProcessor
extends BaseHostProcessor {
    private TypeElement centerInterceptorTypeElement;
    private TypeElement centerServiceTypeElement;
    private TypeElement centerRouterDegradeTypeElement;
    private TypeElement centerFragmentTypeElement;
    private TypeElement routerCenterTypeElement;
    private TypeElement classCacheTypeElement;
    private int priority = 0;
    private List<Element> applicationList = new ArrayList<Element>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        Map<String, String> options = this.processingEnv.getOptions();
        if (options != null) {
            String priorityStr = options.get("Priority");
            try {
                this.priority = Integer.parseInt(priorityStr);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.centerInterceptorTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.impl.interceptor.InterceptorCenter");
        this.centerRouterDegradeTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.impl.RouterDegradeCenter");
        this.centerFragmentTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.impl.fragment.FragmentCenter");
        this.centerServiceTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.impl.service.ServiceCenter");
        this.routerCenterTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.impl.RouterCenter");
        this.classCacheTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.cache.ClassCache");
        this.createImpl(true);
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (CollectionUtils.isNotEmpty(set)) {
            Set<? extends Element> moduleAppElements = roundEnvironment.getElementsAnnotatedWith(ModuleAppAnno.class);
            this.parseAnnotation(moduleAppElements);
            this.createImpl(false);
            return true;
        }
        return false;
    }

    private void parseAnnotation(Set<? extends Element> moduleAppElements) {
        this.applicationList.clear();
        TypeMirror typeApplicationLifecycle = this.mElements.getTypeElement("com.xiaojinzi.component.application.IApplicationLifecycle").asType();
        for (Element element : moduleAppElements) {
            TypeMirror tm = element.asType();
            if (!(element instanceof TypeElement)) {
                throw new ProcessException(element + " is not a 'TypeElement' ");
            }
            if (!this.mTypes.isSubtype(tm, typeApplicationLifecycle)) {
                throw new ProcessException(element + " you must implement IApplicationLifecycle interface");
            }
            ModuleAppAnno moduleApp = element.getAnnotation(ModuleAppAnno.class);
            if (moduleApp == null) continue;
            this.applicationList.add(element);
        }
    }

    private void createImpl(boolean isDefault) {
        String claName = isDefault ? ComponentUtil.genDefaultHostModuleApplicationClassName((String)this.componentModuleName) : ComponentUtil.genHostModuleApplicationClassName((String)this.componentModuleName);
        String classJavaDoc = null;
        classJavaDoc = isDefault ? "\u5f53\u4e1a\u52a1\u7ec4\u4ef6\u4e2d\u6ca1\u6709\u7528 {@link com.xiaojinzi.component.anno.ModuleAppAnno} \u6ce8\u89e3,\n\u672c\u7c7b\u5c31\u4f1a\u9ed8\u8ba4\u88ab\u52a0\u8f7d\u7684\u751f\u6548\n" : "\u5f53\u4e1a\u52a1\u7ec4\u4ef6\u4e2d\u4f7f\u7528\u4e86 {@link com.xiaojinzi.component.anno.ModuleAppAnno} \u6ce8\u89e3,\n\u672c\u7c7b\u5c31\u4f1a\u88ab\u52a0\u8f7d\u751f\u6548,\u9ed8\u8ba4\u7684 {@link " + claName + "} \u4f1a\u5931\u6548\n";
        String pkg = claName.substring(0, claName.lastIndexOf(46));
        String cn = claName.substring(claName.lastIndexOf(46) + 1);
        ClassName superClass = ClassName.get((TypeElement)this.mElements.getTypeElement("com.xiaojinzi.component.impl.application.ModuleApplicationImpl"));
        MethodSpec initHostMethod = this.generateInitHostMethod();
        MethodSpec getPriorityMethod = this.generateGetPriorityMethod();
        MethodSpec initMapMethod = this.generateInitMapMethod();
        MethodSpec onCreateMethod = this.generateOnCreateMethod();
        MethodSpec onDestroyMethod = this.generateOnDestroyMethod();
        TypeSpec typeSpec = TypeSpec.classBuilder((String)cn).addAnnotation(this.mClassNameKeep).addAnnotation(this.mClassNameComponentGeneratedAnno).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.FINAL}).superclass((TypeName)superClass).addMethod(initHostMethod).addMethod(getPriorityMethod).addMethod(initMapMethod).addJavadoc(classJavaDoc, new Object[0]).build();
        try {
            JavaFile.builder((String)pkg, (TypeSpec)typeSpec).indent("    ").build().writeTo(this.mFiler);
        }
        catch (IOException e) {
            throw new ProcessException(e);
        }
    }

    private MethodSpec generateInitMapMethod() {
        TypeName returnType = TypeName.VOID;
        final MethodSpec.Builder openUriMethodSpecBuilder = MethodSpec.methodBuilder((String)"initList").returns(returnType).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        openUriMethodSpecBuilder.addStatement("super.initList()", new Object[0]);
        this.applicationList.forEach(new Consumer<Element>(){

            @Override
            public void accept(Element element) {
                openUriMethodSpecBuilder.addStatement("moduleAppList.add(new $T())", new Object[]{ClassName.get((TypeElement)((TypeElement)element))});
            }
        });
        return openUriMethodSpecBuilder.build();
    }

    private MethodSpec generateOnCreateMethod() {
        TypeName returnType = TypeName.VOID;
        ClassName applicationName = ClassName.get((TypeElement)this.mElements.getTypeElement("android.app.Application"));
        ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)applicationName, (String)"application", (Modifier[])new Modifier[0]).build();
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"onCreate").returns(returnType).addAnnotation(Override.class).addParameter(parameterSpec).addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodSpecBuilder.addStatement("super.onCreate(application)", new Object[0]);
        return methodSpecBuilder.build();
    }

    private MethodSpec generateOnDestroyMethod() {
        TypeName returnType = TypeName.VOID;
        MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"onDestroy").returns(returnType).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodSpecBuilder.addStatement("super.onDestroy()", new Object[0]);
        return methodSpecBuilder.build();
    }

    private MethodSpec generateInitHostMethod() {
        TypeName returnType = TypeName.get((TypeMirror)this.mTypeElementString.asType());
        MethodSpec.Builder openUriMethodSpecBuilder = MethodSpec.methodBuilder((String)"getHost").returns(returnType).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        openUriMethodSpecBuilder.addStatement("return $S", new Object[]{this.componentModuleName});
        return openUriMethodSpecBuilder.build();
    }

    private MethodSpec generateGetPriorityMethod() {
        TypeName returnType = TypeName.get(Integer.TYPE);
        MethodSpec.Builder getPriorityMethodSpecBuilder = MethodSpec.methodBuilder((String)"getPriority").returns(returnType).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        getPriorityMethodSpecBuilder.addStatement("return $L", new Object[]{this.priority});
        return getPriorityMethodSpecBuilder.build();
    }
}

