/*
 * Decompiled with CFR 0.152.
 */
package com.xiaojinzi.component;

import com.google.auto.service.AutoService;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import com.xiaojinzi.component.BaseHostProcessor;
import com.xiaojinzi.component.ComponentUtil;
import com.xiaojinzi.component.ProcessException;
import com.xiaojinzi.component.anno.FragmentAnno;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.apache.commons.collections4.CollectionUtils;

@SupportedOptions(value={"HOST"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
@SupportedAnnotationTypes(value={"com.xiaojinzi.component.anno.FragmentAnno"})
@AutoService(value={Processor.class})
public class FragmentProcessor
extends BaseHostProcessor {
    private static final String NAME_OF_APPLICATION = "application";
    private ClassName classNameFragmentContainer;
    private ClassName function1ClassName;
    private ClassName singletonFunction1ClassName;
    private TypeElement bundleTypeElement;
    private TypeName bundleTypeName;
    private final List<Element> annoElementList = new ArrayList<Element>();
    private final Set<String> nameSet = new HashSet<String>();

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        TypeElement typeElementFragmentContainer = this.mElements.getTypeElement("com.xiaojinzi.component.impl.fragment.FragmentManager");
        this.classNameFragmentContainer = ClassName.get((TypeElement)typeElementFragmentContainer);
        TypeElement function1TypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.support.Function1");
        TypeElement singletonFunctionTypeElement = this.mElements.getTypeElement("com.xiaojinzi.component.support.SingletonFunction1");
        this.function1ClassName = ClassName.get((TypeElement)function1TypeElement);
        this.singletonFunction1ClassName = ClassName.get((TypeElement)singletonFunctionTypeElement);
        this.bundleTypeElement = this.mElements.getTypeElement("android.os.Bundle");
        this.bundleTypeName = TypeName.get((TypeMirror)this.bundleTypeElement.asType());
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (this.componentModuleName == null || this.componentModuleName.isEmpty()) {
            return false;
        }
        if (CollectionUtils.isNotEmpty(set)) {
            Set<? extends Element> annoElements = roundEnvironment.getElementsAnnotatedWith(FragmentAnno.class);
            this.parseAnnotation(annoElements);
            this.createImpl();
            return true;
        }
        return false;
    }

    private void parseAnnotation(Set<? extends Element> annoElements) {
        this.annoElementList.clear();
        this.nameSet.clear();
        for (Element element : annoElements) {
            String[] fragmentNames;
            FragmentAnno anno = element.getAnnotation(FragmentAnno.class);
            if (anno == null) continue;
            for (String fragmentName : fragmentNames = anno.value()) {
                if ("".equalsIgnoreCase(fragmentName)) {
                    throw new ProcessException("the name of fragment can't be empty or null");
                }
                if (this.nameSet.contains(fragmentName)) {
                    throw new ProcessException("the name of '" + fragmentName + "' is already exist");
                }
                this.nameSet.add(fragmentName);
            }
            this.annoElementList.add(element);
        }
    }

    private void createImpl() {
        String claName = ComponentUtil.genHostFragmentClassName((String)this.componentModuleName);
        String pkg = claName.substring(0, claName.lastIndexOf(46));
        String cn = claName.substring(claName.lastIndexOf(46) + 1);
        ClassName superClass = ClassName.get((TypeElement)this.mElements.getTypeElement("com.xiaojinzi.component.impl.fragment.ModuleFragmentImpl"));
        MethodSpec initHostMethod = this.generateInitHostMethod();
        MethodSpec onCreateMethod = this.generateOnCreateMethod();
        MethodSpec onDestroyMethod = this.generateOnDestroyMethod();
        MethodSpec onGetFragmentMapMethod = this.generateGetFragmentMapMethod();
        TypeSpec typeSpec = TypeSpec.classBuilder((String)cn).addAnnotation(this.mClassNameKeep).addAnnotation(this.mClassNameComponentGeneratedAnno).addModifiers(new Modifier[]{Modifier.PUBLIC}).addModifiers(new Modifier[]{Modifier.FINAL}).superclass((TypeName)superClass).addMethod(initHostMethod).addMethod(onCreateMethod).addMethod(onDestroyMethod).addMethod(onGetFragmentMapMethod).build();
        try {
            JavaFile.builder((String)pkg, (TypeSpec)typeSpec).indent("    ").build().writeTo(this.mFiler);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private MethodSpec generateOnCreateMethod() {
        final ParameterSpec bundleParameter = ParameterSpec.builder((TypeName)this.bundleTypeName, (String)"bundle", (Modifier[])new Modifier[0]).build();
        TypeName returnType = TypeName.VOID;
        ClassName applicationName = ClassName.get((TypeElement)this.mElements.getTypeElement("android.app.Application"));
        ParameterSpec parameterSpec = ParameterSpec.builder((TypeName)applicationName, (String)NAME_OF_APPLICATION, (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.FINAL}).build();
        final MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"onCreate").returns(returnType).addAnnotation(Override.class).addParameter(parameterSpec).addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodSpecBuilder.addStatement("super.onCreate(application)", new Object[0]);
        final AtomicInteger atomicInteger = new AtomicInteger();
        this.annoElementList.forEach(new Consumer<Element>(){

            @Override
            public void accept(Element element) {
                String serviceImplCallPath = null;
                TypeName serviceImplTypeName = null;
                if (element instanceof ExecutableElement) {
                    ExecutableElement methodElement = (ExecutableElement)element;
                    serviceImplTypeName = TypeName.get((TypeMirror)methodElement.getReturnType());
                    TypeElement declareClassType = (TypeElement)methodElement.getEnclosingElement();
                    serviceImplCallPath = declareClassType.toString() + "." + methodElement.getSimpleName();
                } else {
                    String serviceImplClassName = element.toString();
                    serviceImplTypeName = TypeName.get((TypeMirror)FragmentProcessor.this.mElements.getTypeElement(serviceImplClassName).asType());
                }
                FragmentAnno anno = element.getAnnotation(FragmentAnno.class);
                String implName = "implName" + atomicInteger.incrementAndGet();
                MethodSpec.Builder getMethodBuilder = MethodSpec.methodBuilder((String)"apply").addAnnotation(Override.class).addParameter(bundleParameter).addModifiers(new Modifier[]{Modifier.PUBLIC});
                if (serviceImplCallPath == null) {
                    boolean haveDefaultConstructor = FragmentProcessor.this.isHaveDefaultConstructor(element.toString());
                    getMethodBuilder.beginControlFlow("if(bundle == null)", new Object[0]).addStatement("bundle = new Bundle()", new Object[0]).endControlFlow().addStatement("$T fragment =  new $T($N)", new Object[]{serviceImplTypeName, serviceImplTypeName, haveDefaultConstructor ? "" : FragmentProcessor.NAME_OF_APPLICATION}).addStatement("fragment.setArguments(bundle)", new Object[0]).addStatement("return fragment", new Object[0]).returns(TypeName.get((TypeMirror)element.asType()));
                } else {
                    getMethodBuilder.beginControlFlow("if(bundle == null)", new Object[0]).addStatement("bundle = new Bundle()", new Object[0]).endControlFlow().addStatement("return $N(bundle)", new Object[]{serviceImplCallPath}).returns(serviceImplTypeName);
                }
                TypeSpec innerTypeSpec = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)ParameterizedTypeName.get((ClassName)FragmentProcessor.this.function1ClassName, (TypeName[])new TypeName[]{FragmentProcessor.this.bundleTypeName, serviceImplTypeName})).addMethod(getMethodBuilder.build()).build();
                methodSpecBuilder.addStatement("$T $N = $L", new Object[]{FragmentProcessor.this.function1ClassName, implName, innerTypeSpec});
                List<String> fragmentFlags = Arrays.asList(anno.value());
                for (String fragmentFlag : fragmentFlags) {
                    methodSpecBuilder.addStatement("$T.register($S,$N)", new Object[]{FragmentProcessor.this.classNameFragmentContainer, fragmentFlag, implName});
                }
            }
        });
        return methodSpecBuilder.build();
    }

    private MethodSpec generateOnDestroyMethod() {
        TypeName returnType = TypeName.VOID;
        final MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"onDestroy").returns(returnType).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodSpecBuilder.addStatement("super.onDestroy()", new Object[0]);
        this.annoElementList.forEach(new Consumer<Element>(){

            @Override
            public void accept(Element element) {
                FragmentAnno anno = element.getAnnotation(FragmentAnno.class);
                List<String> fragmentFlags = Arrays.asList(anno.value());
                for (String fragmentFlag : fragmentFlags) {
                    methodSpecBuilder.addStatement("$T.unregister($S)", new Object[]{FragmentProcessor.this.classNameFragmentContainer, fragmentFlag});
                }
            }
        });
        return methodSpecBuilder.build();
    }

    private MethodSpec generateGetFragmentMapMethod() {
        ParameterizedTypeName fragmentMapParameterizedTypeName = ParameterizedTypeName.get((ClassName)this.mClassNameHashSet, (TypeName[])new TypeName[]{TypeName.get((TypeMirror)this.mTypeElementString.asType())});
        final MethodSpec.Builder methodSpecBuilder = MethodSpec.methodBuilder((String)"getFragmentNameSet").returns((TypeName)fragmentMapParameterizedTypeName).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        methodSpecBuilder.addStatement("HashSet<String> set = new HashSet();", new Object[0]);
        this.annoElementList.forEach(new Consumer<Element>(){

            @Override
            public void accept(Element element) {
                FragmentAnno anno = element.getAnnotation(FragmentAnno.class);
                List<String> fragmentFlags = Arrays.asList(anno.value());
                for (String fragmentFlag : fragmentFlags) {
                    methodSpecBuilder.addStatement("set.add($S)", new Object[]{fragmentFlag});
                }
            }
        });
        methodSpecBuilder.addStatement("return set", new Object[0]);
        return methodSpecBuilder.build();
    }

    private MethodSpec generateInitHostMethod() {
        TypeName returnType = TypeName.get((TypeMirror)this.mTypeElementString.asType());
        MethodSpec.Builder openUriMethodSpecBuilder = MethodSpec.methodBuilder((String)"getHost").returns(returnType).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC});
        openUriMethodSpecBuilder.addStatement("return $S", new Object[]{this.componentModuleName});
        return openUriMethodSpecBuilder.build();
    }

    private boolean isHaveDefaultConstructor(String className) {
        TypeElement typeElementClassImpl = this.mElements.getTypeElement(className);
        String constructorName = typeElementClassImpl.getSimpleName().toString() + "()";
        List<? extends Element> enclosedElements = typeElementClassImpl.getEnclosedElements();
        for (Element element : enclosedElements) {
            if (!element.toString().equals(constructorName)) continue;
            return true;
        }
        return false;
    }
}

