/*
 * Decompiled with CFR 0.152.
 */
package com.stx.xhb.androidx;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.VelocityTracker;
import android.view.View;
import androidx.core.view.VelocityTrackerCompat;
import androidx.core.view.ViewCompat;
import androidx.viewpager.widget.ViewPager;
import com.stx.xhb.androidx.XBannerScroller;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class XBannerViewPager
extends ViewPager {
    private boolean overlapStyle = false;
    private boolean mIsAllowUserScroll = true;
    private AutoPlayDelegate mAutoPlayDelegate;

    public XBannerViewPager(Context context) {
        super(context);
    }

    public XBannerViewPager(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void setPageTransformer(boolean reverseDrawingOrder, ViewPager.PageTransformer transformer) {
        Class<ViewPager> viewpagerClass = ViewPager.class;
        try {
            boolean hasTransformer = transformer != null;
            Field pageTransformerField = viewpagerClass.getDeclaredField("mPageTransformer");
            pageTransformerField.setAccessible(true);
            ViewPager.PageTransformer mPageTransformer = (ViewPager.PageTransformer)pageTransformerField.get((Object)this);
            boolean needsPopulate = hasTransformer != (mPageTransformer != null);
            pageTransformerField.set((Object)this, transformer);
            Method setChildrenDrawingOrderEnabledCompatMethod = viewpagerClass.getDeclaredMethod("setChildrenDrawingOrderEnabledCompat", Boolean.TYPE);
            setChildrenDrawingOrderEnabledCompatMethod.setAccessible(true);
            setChildrenDrawingOrderEnabledCompatMethod.invoke((Object)this, hasTransformer);
            Field drawingOrderField = viewpagerClass.getDeclaredField("mDrawingOrder");
            drawingOrderField.setAccessible(true);
            if (hasTransformer) {
                drawingOrderField.setInt((Object)this, reverseDrawingOrder ? 2 : 1);
            } else {
                drawingOrderField.setInt((Object)this, 0);
            }
            if (needsPopulate) {
                Method populateMethod = viewpagerClass.getDeclaredMethod("populate", new Class[0]);
                populateMethod.setAccessible(true);
                populateMethod.invoke((Object)this, new Object[0]);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setScrollDuration(int duration) {
        try {
            Field scrollerField = ViewPager.class.getDeclaredField("mScroller");
            scrollerField.setAccessible(true);
            scrollerField.set((Object)this, (Object)new XBannerScroller(this.getContext(), duration));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setBannerCurrentItemInternal(int position, boolean smoothScroll) {
        Class<ViewPager> viewpagerClass = ViewPager.class;
        try {
            Method setCurrentItemInternalMethod = viewpagerClass.getDeclaredMethod("setCurrentItemInternal", Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            setCurrentItemInternalMethod.setAccessible(true);
            setCurrentItemInternalMethod.invoke((Object)this, position, smoothScroll, true);
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setIsAllowUserScroll(boolean iSallowUserScroll) {
        this.mIsAllowUserScroll = iSallowUserScroll;
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return this.mIsAllowUserScroll && super.onInterceptTouchEvent(ev);
    }

    public boolean onTouchEvent(MotionEvent ev) {
        if (this.mIsAllowUserScroll) {
            if (this.mAutoPlayDelegate != null && (ev.getAction() == 3 || ev.getAction() == 1)) {
                this.mAutoPlayDelegate.handleAutoPlayActionUpOrCancel(this.getXVelocity());
                return false;
            }
            return super.onTouchEvent(ev);
        }
        return false;
    }

    protected int getChildDrawingOrder(int childCount, int i) {
        if (this.overlapStyle) {
            if (i == childCount - 1) {
                return this.getCurrentItem();
            }
            return i >= this.getCurrentItem() ? i + 1 : i;
        }
        return super.getChildDrawingOrder(childCount, i);
    }

    private float getXVelocity() {
        float xVelocity = 0.0f;
        Class<ViewPager> viewpagerClass = ViewPager.class;
        try {
            Field velocityTrackerField = viewpagerClass.getDeclaredField("mVelocityTracker");
            velocityTrackerField.setAccessible(true);
            VelocityTracker velocityTracker = (VelocityTracker)velocityTrackerField.get((Object)this);
            Field activePointerIdField = viewpagerClass.getDeclaredField("mActivePointerId");
            activePointerIdField.setAccessible(true);
            Field maximumVelocityField = viewpagerClass.getDeclaredField("mMaximumVelocity");
            maximumVelocityField.setAccessible(true);
            int maximumVelocity = maximumVelocityField.getInt((Object)this);
            velocityTracker.computeCurrentVelocity(1000, (float)maximumVelocity);
            xVelocity = VelocityTrackerCompat.getXVelocity((VelocityTracker)velocityTracker, (int)activePointerIdField.getInt((Object)this));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return xVelocity;
    }

    public void setOverlapStyle(boolean overlapStyle) {
        this.overlapStyle = overlapStyle;
    }

    public void setAutoPlayDelegate(AutoPlayDelegate autoPlayDelegate) {
        this.mAutoPlayDelegate = autoPlayDelegate;
    }

    public static interface AutoPlayDelegate {
        public void handleAutoPlayActionUpOrCancel(float var1);
    }
}

