/*
 * Decompiled with CFR 0.152.
 */
package com.stx.xhb.xbanner.transformers;

import android.support.v4.view.ViewCompat;
import android.view.View;
import com.stx.xhb.xbanner.transformers.BasePageTransformer;

public class ZoomPageTransformer
extends BasePageTransformer {
    private float mMinScale = 0.85f;
    private float mMinAlpha = 0.65f;

    public ZoomPageTransformer() {
    }

    public ZoomPageTransformer(float minAlpha, float minScale) {
        this.setMinAlpha(minAlpha);
        this.setMinScale(minScale);
    }

    @Override
    public void handleInvisiblePage(View view, float position) {
        ViewCompat.setAlpha((View)view, (float)0.0f);
    }

    @Override
    public void handleLeftPage(View view, float position) {
        float scale = Math.max(this.mMinScale, 1.0f + position);
        float vertMargin = (float)view.getHeight() * (1.0f - scale) / 2.0f;
        float horzMargin = (float)view.getWidth() * (1.0f - scale) / 2.0f;
        ViewCompat.setTranslationX((View)view, (float)(horzMargin - vertMargin / 2.0f));
        ViewCompat.setScaleX((View)view, (float)scale);
        ViewCompat.setScaleY((View)view, (float)scale);
        ViewCompat.setAlpha((View)view, (float)(this.mMinAlpha + (scale - this.mMinScale) / (1.0f - this.mMinScale) * (1.0f - this.mMinAlpha)));
    }

    @Override
    public void handleRightPage(View view, float position) {
        float scale = Math.max(this.mMinScale, 1.0f - position);
        float vertMargin = (float)view.getHeight() * (1.0f - scale) / 2.0f;
        float horzMargin = (float)view.getWidth() * (1.0f - scale) / 2.0f;
        ViewCompat.setTranslationX((View)view, (float)(-horzMargin + vertMargin / 2.0f));
        ViewCompat.setScaleX((View)view, (float)scale);
        ViewCompat.setScaleY((View)view, (float)scale);
        ViewCompat.setAlpha((View)view, (float)(this.mMinAlpha + (scale - this.mMinScale) / (1.0f - this.mMinScale) * (1.0f - this.mMinAlpha)));
    }

    public void setMinAlpha(float minAlpha) {
        if (minAlpha >= 0.6f && minAlpha <= 1.0f) {
            this.mMinAlpha = minAlpha;
        }
    }

    public void setMinScale(float minScale) {
        if (minScale >= 0.6f && minScale <= 1.0f) {
            this.mMinScale = minScale;
        }
    }
}

