/*
 * Decompiled with CFR 0.152.
 */
package com.stx.xhb.xbanner.transformers;

import android.support.v4.view.ViewCompat;
import android.view.View;
import com.stx.xhb.xbanner.transformers.BasePageTransformer;

public class CubePageTransformer
extends BasePageTransformer {
    private float mMaxRotation = 90.0f;

    public CubePageTransformer() {
    }

    public CubePageTransformer(float maxRotation) {
        this.setMaxRotation(maxRotation);
    }

    @Override
    public void handleInvisiblePage(View view, float position) {
        ViewCompat.setPivotX((View)view, (float)view.getMeasuredWidth());
        ViewCompat.setPivotY((View)view, (float)((float)view.getMeasuredHeight() * 0.5f));
        ViewCompat.setRotationY((View)view, (float)0.0f);
    }

    @Override
    public void handleLeftPage(View view, float position) {
        ViewCompat.setPivotX((View)view, (float)view.getMeasuredWidth());
        ViewCompat.setPivotY((View)view, (float)((float)view.getMeasuredHeight() * 0.5f));
        ViewCompat.setRotationY((View)view, (float)(this.mMaxRotation * position));
    }

    @Override
    public void handleRightPage(View view, float position) {
        ViewCompat.setPivotX((View)view, (float)0.0f);
        ViewCompat.setPivotY((View)view, (float)((float)view.getMeasuredHeight() * 0.5f));
        ViewCompat.setRotationY((View)view, (float)(this.mMaxRotation * position));
    }

    public void setMaxRotation(float maxRotation) {
        if (maxRotation >= 0.0f && maxRotation <= 90.0f) {
            this.mMaxRotation = maxRotation;
        }
    }
}

