/*
 * Decompiled with CFR 0.152.
 */
package com.stx.xhb.xbanner.transformers;

import android.support.v4.view.ViewCompat;
import android.view.View;
import com.stx.xhb.xbanner.transformers.BasePageTransformer;

public class DepthPageTransformer
extends BasePageTransformer {
    private float mMinScale = 0.8f;

    public DepthPageTransformer() {
    }

    public DepthPageTransformer(float minScale) {
        this.setMinScale(minScale);
    }

    @Override
    public void handleInvisiblePage(View view, float position) {
        ViewCompat.setAlpha((View)view, (float)0.0f);
    }

    @Override
    public void handleLeftPage(View view, float position) {
        ViewCompat.setAlpha((View)view, (float)1.0f);
        ViewCompat.setTranslationX((View)view, (float)0.0f);
        ViewCompat.setScaleX((View)view, (float)1.0f);
        ViewCompat.setScaleY((View)view, (float)1.0f);
    }

    @Override
    public void handleRightPage(View view, float position) {
        ViewCompat.setAlpha((View)view, (float)(1.0f - position));
        ViewCompat.setTranslationX((View)view, (float)((float)(-view.getWidth()) * position));
        float scale = this.mMinScale + (1.0f - this.mMinScale) * (1.0f - position);
        ViewCompat.setScaleX((View)view, (float)scale);
        ViewCompat.setScaleY((View)view, (float)scale);
    }

    public void setMinScale(float minScale) {
        if (minScale >= 0.6f && minScale <= 1.0f) {
            this.mMinScale = minScale;
        }
    }
}

